/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.util.ui.colourpicker;

import java.awt.Color;
import java.util.ArrayList;
import javax.swing.JComponent;
import javax.swing.event.ChangeListener;
import org.openmicroscopy.shoola.util.ui.colourpicker.ColourChangedEvent;
import org.openmicroscopy.shoola.util.ui.colourpicker.RGBModel;

class RGBControl
extends JComponent {
    private RGBModel model;
    private ArrayList listeners;

    RGBControl(RGBModel m) {
        if (m == null) {
            throw new NullPointerException("No model.");
        }
        this.model = m;
        this.listeners = new ArrayList();
    }

    void setRed(float r) {
        this.model.setRed(r);
        this.fireChangeEvent();
    }

    void setBlue(float b) {
        this.model.setBlue(b);
        this.fireChangeEvent();
    }

    void setGreen(float g) {
        this.model.setGreen(g);
        this.fireChangeEvent();
    }

    void setAlpha(float a) {
        this.model.setAlpha(a);
        this.fireChangeEvent();
    }

    void setHue(float h) {
        this.model.setHue(h);
        this.fireChangeEvent();
    }

    void setSaturation(float s) {
        this.model.setSaturation(s);
        this.fireChangeEvent();
    }

    void setValue(float v) {
        this.model.setValue(v);
        this.fireChangeEvent();
    }

    void setColour(Color c) {
        this.model.setColour(c);
        this.fireChangeEvent();
    }

    void setHSVColour(float h, float s, float v, float a) {
        this.model.setHSVColour(h, s, v, a);
        this.fireChangeEvent();
    }

    void setRGBColour(float r, float g, float b, float a) {
        this.model.setRGBColour(r, g, b, a);
        this.fireChangeEvent();
    }

    void revert() {
        this.model.revert();
        this.fireChangeEvent();
    }

    Color getColour() {
        return this.model.getColour();
    }

    float getRed() {
        return this.model.getRed();
    }

    float getGreen() {
        return this.model.getGreen();
    }

    float getBlue() {
        return this.model.getBlue();
    }

    float getAlpha() {
        return this.model.getAlpha();
    }

    float getHue() {
        return this.model.getHue();
    }

    float getSaturation() {
        return this.model.getSaturation();
    }

    float getValue() {
        return this.model.getValue();
    }

    void addListener(ChangeListener e) {
        this.listeners.add(e);
    }

    void fireChangeEvent() {
        for (int i = 0; i < this.listeners.size(); ++i) {
            ChangeListener e = (ChangeListener)this.listeners.get(i);
            e.stateChanged(new ColourChangedEvent(this));
        }
        this.firePropertyChange("colourChanged", null, this.model.getColour());
    }
}

