/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.util.ui.clsf;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JToggleButton;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.plaf.ColorUIResource;
import javax.swing.tree.TreeCellRenderer;
import org.openmicroscopy.shoola.util.ui.clsf.TreeCheckLabel;
import org.openmicroscopy.shoola.util.ui.clsf.TreeCheckNode;

class TreeCheckRenderer
extends JPanel
implements TreeCellRenderer {
    private static final Dimension NULL_SIZE = new Dimension(0, 0);
    private static final int DEFAULT_HEIGHT = 16;
    protected JToggleButton check;
    protected TreeCheckLabel label;
    private boolean leafOnly;
    private Dimension restoredSize;

    TreeCheckRenderer(boolean leafOnly) {
        this.leafOnly = leafOnly;
        this.restoredSize = null;
        this.setLayout(null);
        this.setOpaque(false);
        this.label = new TreeCheckLabel();
        this.check = new JCheckBox();
        this.check.setBackground(UIManager.getColor("Tree.textBackground"));
        this.setBackground(UIManager.getColor("Tree.textBackground"));
    }

    void initToggleButton(Class buttonType) {
        this.check = buttonType.equals(JCheckBox.class) ? new JCheckBox() : new JRadioButton();
    }

    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        this.setEnabled(tree.isEnabled());
        if (this.restoredSize == null) {
            this.restoredSize = new Dimension(this.check.getPreferredSize().width, 16);
        }
        TreeCheckNode node = (TreeCheckNode)value;
        this.check.setSelected(node.isSelected());
        this.label.setFont(tree.getFont());
        this.label.setText(node.toString());
        this.label.setSelected(selected);
        this.label.setFocus(hasFocus);
        Icon nodeIcon = node.getNodeIcon();
        if (node.isLeafNode()) {
            if (nodeIcon == null) {
                nodeIcon = UIManager.getIcon("Tree.leafIcon");
            }
            this.check.setPreferredSize(this.restoredSize);
            this.add(this.check);
            this.add(this.label);
        } else {
            if (nodeIcon == null) {
                nodeIcon = expanded ? UIManager.getIcon("Tree.openIcon") : UIManager.getIcon("Tree.closedIcon");
            }
            if (this.leafOnly) {
                this.check.setPreferredSize(NULL_SIZE);
            } else {
                this.check.setPreferredSize(this.restoredSize);
                this.add(this.check);
            }
            this.add(this.label);
        }
        this.label.setIcon(nodeIcon);
        return this;
    }

    public Dimension getPreferredSize() {
        Dimension d_check = this.check.getPreferredSize();
        Dimension d_label = this.label.getPreferredSize();
        return new Dimension(d_check.width + d_label.width, d_check.height < d_label.height ? d_label.height : d_check.height);
    }

    public void doLayout() {
        Dimension d_check = this.check.getPreferredSize();
        Dimension d_label = this.label.getPreferredSize();
        int y_check = 0;
        int y_label = 0;
        if (d_check.height < d_label.height) {
            y_check = (d_label.height - d_check.height) / 2;
        } else {
            y_label = (d_check.height - d_label.height) / 2;
        }
        this.check.setBounds(0, y_check, d_check.width, d_check.height);
        this.label.setBounds(d_check.width, y_label, d_label.width, d_label.height);
    }

    public void setBackground(Color color) {
        if (color instanceof ColorUIResource) {
            color = null;
        }
        super.setBackground(color);
    }
}

