/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.util.ui.border;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;

public class TitledLineBorder
extends TitledBorder {
    private static final Color DEFAULT_COLOR = Color.LIGHT_GRAY;
    private Point textLoc = new Point();
    private Color lineColor;

    private static boolean computeIntersection(Rectangle dest, int rx, int ry, int rw, int rh) {
        int x1 = Math.max(rx, dest.x);
        int x2 = Math.min(rx + rw, dest.x + dest.width);
        int y1 = Math.max(ry, dest.y);
        int y2 = Math.min(ry + rh, dest.y + dest.height);
        dest.x = x1;
        dest.y = y1;
        dest.width = x2 - x1;
        dest.height = y2 - y1;
        return dest.width > 0 && dest.height > 0;
    }

    public TitledLineBorder(String title, Color lineColor) {
        super(title);
        this.setLineColor(lineColor);
    }

    public TitledLineBorder(String title) {
        this(title, null);
    }

    public void setLineColor(Color lineColor) {
        this.lineColor = lineColor == null ? DEFAULT_COLOR : lineColor;
    }

    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        Border border = this.getBorder();
        if (this.getTitle() == null || this.getTitle().equals("")) {
            if (border != null) {
                border.paintBorder(c, g, x, y, width, height);
            }
            return;
        }
        Rectangle grooveRect = new Rectangle(x + 2, y + 2, width - 4, height - 4);
        Font font = g.getFont();
        Color color = g.getColor();
        Font fontc = this.getFont(c);
        if (fontc != null) {
            g.setFont(fontc.deriveFont(1));
        }
        FontMetrics fm = g.getFontMetrics(g.getFont());
        int fontHeight = fm.getHeight();
        int descent = fm.getDescent();
        int ascent = fm.getAscent();
        int stringWidth = fm.stringWidth(this.getTitle());
        Insets insets = border != null ? border.getBorderInsets(c) : new Insets(0, 0, 0, 0);
        int titlePos = this.getTitlePosition();
        switch (titlePos) {
            case 1: {
                int diff = ascent + descent + Math.max(2, 4) - 2;
                grooveRect.y += diff;
                grooveRect.height -= diff;
                this.textLoc.y = grooveRect.y - descent - 2;
                break;
            }
            case 0: 
            case 2: {
                int diff = Math.max(0, ascent / 2 + 2 - 2);
                grooveRect.y += diff;
                grooveRect.height -= diff;
                this.textLoc.y = grooveRect.y - descent + (insets.top + ascent + descent) / 2;
                break;
            }
            case 3: {
                this.textLoc.y = grooveRect.y + insets.top + ascent + 2;
                break;
            }
            case 4: {
                this.textLoc.y = grooveRect.y + grooveRect.height - (insets.bottom + descent + 2);
                break;
            }
            case 5: {
                grooveRect.height -= fontHeight / 2;
                this.textLoc.y = grooveRect.y + grooveRect.height - descent + (ascent + descent - insets.bottom) / 2;
                break;
            }
            case 6: {
                grooveRect.height -= fontHeight;
                this.textLoc.y = grooveRect.y + grooveRect.height + ascent + 2;
            }
        }
        int justification = this.getTitleJustification();
        if (c.getComponentOrientation().isLeftToRight()) {
            if (justification == 4 || justification == 0) {
                justification = 1;
            } else if (justification == 5) {
                justification = 3;
            }
        } else if (justification == 4 || justification == 0) {
            justification = 3;
        } else if (justification == 5) {
            justification = 1;
        }
        switch (justification) {
            case 1: {
                this.textLoc.x = grooveRect.x + 5 + insets.left;
                break;
            }
            case 3: {
                this.textLoc.x = grooveRect.x + grooveRect.width - (stringWidth + 5 + insets.right);
                break;
            }
            case 2: {
                this.textLoc.x = grooveRect.x + (grooveRect.width - stringWidth) / 2;
            }
        }
        if (border != null) {
            if ((titlePos == 2 || titlePos == 0) && grooveRect.y > this.textLoc.y - ascent || titlePos == 5 && grooveRect.y + grooveRect.height < this.textLoc.y + descent) {
                Rectangle clipRect = new Rectangle();
                Rectangle saveClip = g.getClipBounds();
                clipRect.setBounds(saveClip);
                if (TitledLineBorder.computeIntersection(clipRect, x, y, this.textLoc.x - 1 - x, height)) {
                    g.setClip(clipRect);
                    g.setColor(this.lineColor);
                    g.drawLine(grooveRect.x, grooveRect.y, grooveRect.x + grooveRect.width, grooveRect.y);
                    g.setColor(color);
                }
                clipRect.setBounds(saveClip);
                if (TitledLineBorder.computeIntersection(clipRect, this.textLoc.x + stringWidth + 1, y, x + width - (this.textLoc.x + stringWidth + 1), height)) {
                    g.setClip(clipRect);
                    g.setColor(this.lineColor);
                    g.drawLine(grooveRect.x, grooveRect.y, grooveRect.x + grooveRect.width, grooveRect.y);
                    g.setColor(color);
                }
                if (titlePos == 2 || titlePos == 0) {
                    clipRect.setBounds(saveClip);
                    if (TitledLineBorder.computeIntersection(clipRect, this.textLoc.x - 1, this.textLoc.y + descent, stringWidth + 2, y + height - this.textLoc.y - descent)) {
                        g.setClip(clipRect);
                        g.setColor(this.lineColor);
                        g.drawLine(grooveRect.x, grooveRect.y, grooveRect.x + grooveRect.width, grooveRect.y);
                        g.setColor(color);
                    }
                } else {
                    clipRect.setBounds(saveClip);
                    if (TitledLineBorder.computeIntersection(clipRect, this.textLoc.x - 1, y, stringWidth + 2, this.textLoc.y - ascent - y)) {
                        g.setClip(clipRect);
                        g.setColor(this.lineColor);
                        g.drawLine(grooveRect.x, grooveRect.y + grooveRect.height, grooveRect.x + grooveRect.width, grooveRect.y + grooveRect.height);
                        g.setColor(color);
                    }
                }
                g.setClip(saveClip);
            } else {
                border.paintBorder(c, g, grooveRect.x, grooveRect.y, grooveRect.width, grooveRect.height);
            }
        }
        g.setColor(this.getTitleColor());
        g.drawString(this.getTitle(), this.textLoc.x, this.textLoc.y);
        g.setFont(font);
        g.setColor(color);
    }
}

