/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.util.ui.border;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import javax.swing.border.LineBorder;

public class PartialLineBorder
extends LineBorder {
    public static final int TOP_REMOVE = 0;
    public static final int BOTTOM_REMOVE = 1;
    private int removeIndex = 1;

    public PartialLineBorder(Color color) {
        super(color);
    }

    public PartialLineBorder(Color color, int thickness) {
        super(color, thickness);
    }

    public void setRemoveIndex(int index) {
        this.removeIndex = index;
    }

    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        super.paintBorder(c, g, x, y, width, height);
        g.setColor(c.getBackground());
        switch (this.removeIndex) {
            case 0: {
                for (int i = 0; i < this.thickness; ++i) {
                    g.drawLine(x + i, y + i, x + width - i - 1, y + i);
                }
                break;
            }
            default: {
                for (int i = 0; i < this.thickness; ++i) {
                    g.drawLine(x + width - i - 1, y + height - i - 1, x + i + 1, y + height - i - 1);
                }
            }
        }
    }
}

