/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.util.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.geom.Area;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import org.openmicroscopy.shoola.util.ui.MultilineLabel;

public class TitlePanel
extends JPanel {
    private static final Color DEFAULT_BG = Color.WHITE;
    private JComponent title;
    private JComponent subTitle;
    private JComponent text;
    private JSeparator hLine;
    protected JComponent graphx;

    private void buildGUI() {
        this.add(this.title);
        this.add(this.subTitle);
        this.add(this.text);
        this.add(this.graphx);
        this.add(this.hLine);
        this.setBorder(BorderFactory.createEmptyBorder(5, 10, 5, 10));
        this.setLayout(new TitlePanelLayout());
        Font f = this.title.getFont();
        this.title.setFont(f.deriveFont(1));
        f = this.subTitle.getFont();
        this.subTitle.setFont(f.deriveFont(0));
        f = this.text.getFont();
        this.text.setFont(f.deriveFont(2));
        this.setBackground(DEFAULT_BG);
    }

    public TitlePanel(String title, String subTitle, String text, JComponent graphx) {
        this.title = new JLabel(title);
        this.subTitle = new JLabel(subTitle);
        this.text = new MultilineLabel(text);
        this.graphx = graphx == null ? new JLabel() : graphx;
        this.hLine = new JSeparator();
        this.setOpaque(true);
        this.buildGUI();
    }

    public TitlePanel(String title, String subTitle, JComponent graphx) {
        this(title, subTitle, null, graphx);
    }

    public TitlePanel(String title, String subTitle, String text, Icon icon) {
        this(title, subTitle, text, new JLabel(icon));
    }

    public TitlePanel(String title, String subTitle, Icon icon) {
        this(title, subTitle, null, new JLabel(icon));
    }

    public void setIconComponent(JComponent c) {
        if (c == null) {
            throw new IllegalArgumentException("No component no set.");
        }
        this.remove(this.graphx);
        this.graphx = c;
        this.add(this.graphx);
        this.repaint();
    }

    private class TitlePanelLayout
    implements LayoutManager {
        private static final int H_GAP = 20;
        private static final int INDENT = 10;
        private Rectangle curLayoutBounds;

        private TitlePanelLayout() {
        }

        private void updateLayoutBounds(Rectangle r) {
            Area a = new Area(this.curLayoutBounds);
            Area b = new Area(r);
            a.subtract(b);
            this.curLayoutBounds = a.getBounds();
        }

        private boolean shouldLayout(JComponent c) {
            if (this.curLayoutBounds.width * this.curLayoutBounds.height <= 0) {
                c.setBounds(0, 0, 0, 0);
                return false;
            }
            return true;
        }

        private int getActualHeight(int preferredHeight) {
            return preferredHeight < this.curLayoutBounds.height ? preferredHeight : this.curLayoutBounds.height;
        }

        private void layoutHLine() {
            int h = TitlePanel.this.getHeight();
            Insets i = TitlePanel.this.getInsets();
            Dimension d = TitlePanel.this.hLine.getPreferredSize();
            int height = d.height < i.bottom ? d.height : i.bottom - 1;
            TitlePanel.this.hLine.setBounds(0, h - height, TitlePanel.this.getWidth(), height);
        }

        private void layoutGraphx() {
            Rectangle r;
            if (!this.shouldLayout(TitlePanel.this.graphx)) {
                return;
            }
            Dimension d = TitlePanel.this.graphx.getPreferredSize();
            if (d.width + 20 < this.curLayoutBounds.width) {
                r = new Rectangle(this.curLayoutBounds.x + this.curLayoutBounds.width - d.width - 20, this.curLayoutBounds.y, d.width + 20, this.curLayoutBounds.height);
                TitlePanel.this.graphx.setBounds(this.curLayoutBounds.x + this.curLayoutBounds.width - d.width, this.curLayoutBounds.y, d.width, this.getActualHeight(d.height));
            } else {
                r = new Rectangle(0, 0, 0, 0);
                TitlePanel.this.graphx.setBounds(r);
            }
            this.updateLayoutBounds(r);
        }

        private void layoutTitle() {
            if (!this.shouldLayout(TitlePanel.this.title)) {
                return;
            }
            int height = this.getActualHeight(((TitlePanel)TitlePanel.this).title.getPreferredSize().height);
            TitlePanel.this.title.setBounds(this.curLayoutBounds.x, this.curLayoutBounds.y, this.curLayoutBounds.width, height);
            this.updateLayoutBounds(TitlePanel.this.title.getBounds());
        }

        private void layoutSubTitle() {
            int height = this.getActualHeight(((TitlePanel)TitlePanel.this).subTitle.getPreferredSize().height);
            Rectangle r = new Rectangle(this.curLayoutBounds.x, this.curLayoutBounds.y, this.curLayoutBounds.width, height);
            TitlePanel.this.subTitle.setBounds(r.x + 10, r.y, r.width - 10, r.height);
            this.updateLayoutBounds(r);
        }

        private void layoutText() {
            Rectangle r = new Rectangle(this.curLayoutBounds);
            TitlePanel.this.text.setBounds(r.x + 10, r.y, r.width - 10, r.height);
            this.updateLayoutBounds(r);
        }

        public Dimension minimumLayoutSize(Container c) {
            return this.preferredLayoutSize(c);
        }

        public Dimension preferredLayoutSize(Container c) {
            Insets i = TitlePanel.this.getInsets();
            Dimension titleD = TitlePanel.this.title.getPreferredSize();
            Dimension subTitleD = TitlePanel.this.subTitle.getPreferredSize();
            Dimension textD = TitlePanel.this.text.getPreferredSize();
            Dimension graphxD = TitlePanel.this.graphx.getPreferredSize();
            int w = i.left + i.right + 20 + graphxD.width + Math.max(titleD.width, subTitleD.width);
            int h = i.top + i.bottom + Math.max(titleD.height + subTitleD.height + textD.height, graphxD.height);
            return new Dimension(w, h);
        }

        public void layoutContainer(Container c) {
            Insets i = TitlePanel.this.getInsets();
            int availW = TitlePanel.this.getWidth() - i.left - i.right;
            int availH = TitlePanel.this.getHeight() - i.top - i.bottom;
            this.curLayoutBounds = new Rectangle(i.left, i.top, availW, availH);
            this.layoutHLine();
            this.layoutGraphx();
            this.layoutTitle();
            this.layoutSubTitle();
            this.layoutText();
        }

        public void addLayoutComponent(String name, Component c) {
        }

        public void removeLayoutComponent(Component c) {
        }
    }
}

