/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.util.ui;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import javax.swing.JPanel;

public class ReferenceFramePanel
extends JPanel {
    public static final int UP_RIGHT = 0;
    public static final int DOWN_RIGHT = 1;
    private static final int LENGTH = 25;
    private static final int ARROW = 3;
    private static final int START = 10;
    private static final Dimension DIM = new Dimension(50, 50);
    private String hAxis;
    private String vAxis;
    private String origin;
    private boolean drawOrigin;
    private Color axisColor;
    private int type;

    public ReferenceFramePanel(String hAxis, String vAxis, String origin) {
        this.hAxis = hAxis;
        this.vAxis = vAxis;
        this.origin = origin;
        this.type = 0;
        this.setPreferredSize(DIM);
    }

    public void setAxisColor(Color c) {
        this.axisColor = c;
    }

    public void setTypeFrame(int type) {
        this.type = type;
    }

    public void setDrawOrigin(boolean b) {
        this.drawOrigin = b;
    }

    public void paint(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2D = (Graphics2D)g;
        FontMetrics fontMetrics = g2D.getFontMetrics();
        if (this.axisColor == null) {
            this.axisColor = Color.BLACK;
        }
        g2D.setColor(this.getBackground());
        Dimension d = this.getSize();
        g2D.fillRect(0, 0, d.width, d.height);
        g2D.setColor(this.axisColor);
        g2D.setStroke(new BasicStroke(1.5f));
        switch (this.type) {
            case 0: {
                this.upFrame(g2D, fontMetrics.getHeight());
                break;
            }
            case 1: {
                this.downFrame(g2D, fontMetrics.getHeight());
            }
        }
    }

    private void downFrame(Graphics2D g2D, int hFont) {
        int x1 = 20;
        int y1 = 15;
        g2D.drawLine(x1, y1, x1 + 25, y1);
        g2D.drawLine(x1 - 3 + 25, y1 - 3, x1 + 25, y1);
        g2D.drawLine(x1 - 3 + 25, y1 + 3, x1 + 25, y1);
        g2D.drawLine(x1, y1, x1, y1 + 25);
        g2D.drawLine(x1 - 3, y1 + 25 - 3, x1, y1 + 25);
        g2D.drawLine(x1 + 3, y1 + 25 - 3, x1, y1 + 25);
        if (this.drawOrigin) {
            g2D.drawString(this.origin, x1 - hFont / 4, y1 - hFont / 4);
        }
        g2D.drawString(this.hAxis, x1 + 12, y1 - hFont / 4);
        g2D.drawString(this.vAxis, x1 - hFont, y1 + 12);
    }

    private void upFrame(Graphics2D g2D, int hFont) {
        int x1 = 20;
        int y1 = 5;
        g2D.drawLine(x1, y1 + 25, x1 + 25, y1 + 25);
        g2D.drawLine(x1 - 3 + 25, y1 + 25 - 3, x1 + 25, y1 + 25);
        g2D.drawLine(x1 - 3 + 25, y1 + 25 + 3, x1 + 25, y1 + 25);
        g2D.drawLine(x1, y1, x1, y1 + 25);
        g2D.drawLine(x1 - 3, y1 + 3, x1, y1);
        g2D.drawLine(x1 + 3, y1 + 3, x1, y1);
        if (this.drawOrigin) {
            g2D.drawString(this.origin, x1 - hFont / 4, y1 + 25 + hFont);
        }
        g2D.drawString(this.hAxis, x1 + 12, y1 + 25 + hFont);
        g2D.drawString(this.vAxis, x1 - hFont, y1 + 12);
    }
}

