/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.util.ui;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextPane;
import org.openmicroscopy.shoola.util.ui.UIUtilities;

public class OptionsDialog
extends JDialog {
    protected static final Dimension MSG_AREA_SIZE = new Dimension(300, 50);
    protected static final Dimension H_SPACER_SIZE = new Dimension(20, 1);
    protected static final Dimension V_SPACER_SIZE = new Dimension(1, 20);
    protected JPanel contentPanel;
    protected JPanel messagePanel;
    protected JPanel buttonPanel;
    private JButton noButton;
    private JButton yesButton;

    private void yesSelection() {
        this.onYesSelection();
        this.close();
    }

    private void noSelection() {
        this.onNoSelection();
        this.close();
    }

    private void createComponents() {
        this.contentPanel = new JPanel();
        this.messagePanel = new JPanel();
        this.buttonPanel = new JPanel();
        this.noButton = new JButton("No");
        this.yesButton = new JButton("Yes");
        this.getRootPane().setDefaultButton(this.yesButton);
    }

    private void attachListeners() {
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent we) {
                OptionsDialog.this.close();
            }
        });
        this.noButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                OptionsDialog.this.noSelection();
            }
        });
        this.yesButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                OptionsDialog.this.yesSelection();
            }
        });
    }

    private void close() {
        this.setVisible(false);
        this.dispose();
    }

    private void buildMessagePanel(String msg, Icon msgIcon) {
        this.messagePanel.setLayout(new BoxLayout(this.messagePanel, 0));
        this.messagePanel.setOpaque(false);
        if (msgIcon != null) {
            JLabel iconLabel = new JLabel(msgIcon);
            iconLabel.setAlignmentY(0.0f);
            JPanel p = UIUtilities.buildComponentPanel(iconLabel);
            p.setAlignmentY(0.0f);
            this.messagePanel.add(p);
            this.messagePanel.add(Box.createRigidArea(H_SPACER_SIZE));
        }
        JTextPane message = UIUtilities.buildTextPane(msg);
        message.setOpaque(false);
        message.setPreferredSize(MSG_AREA_SIZE);
        message.setAlignmentY(0.0f);
        this.messagePanel.add(UIUtilities.buildComponentPanelRight(message));
    }

    private void buildButtonsPanel() {
        this.buttonPanel.setLayout(new BoxLayout(this.buttonPanel, 0));
        this.buttonPanel.add(Box.createHorizontalGlue());
        this.buttonPanel.add(this.yesButton);
        this.buttonPanel.add(Box.createRigidArea(H_SPACER_SIZE));
        this.buttonPanel.add(this.noButton);
    }

    private void buildGUI(String message, Icon messageIcon) {
        this.contentPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEtchedBorder(), BorderFactory.createEmptyBorder(5, 5, 15, 10)));
        this.contentPanel.setLayout(new BoxLayout(this.contentPanel, 1));
        this.buildMessagePanel(message, messageIcon);
        this.contentPanel.add(this.messagePanel);
        JPanel vSpacer = new JPanel();
        vSpacer.add(Box.createRigidArea(V_SPACER_SIZE));
        this.contentPanel.add(vSpacer);
        this.buildButtonsPanel();
        this.contentPanel.add(this.buttonPanel);
        this.getContentPane().add(this.contentPanel);
        this.pack();
    }

    public OptionsDialog(JFrame owner, String title, String message, Icon messageIcon) {
        super(owner, title, true);
        this.createComponents();
        this.attachListeners();
        this.buildGUI(message, messageIcon);
    }

    public OptionsDialog(JDialog owner, String title, String message, Icon messageIcon) {
        super(owner, title, true);
        this.createComponents();
        this.attachListeners();
        this.buildGUI(message, messageIcon);
    }

    protected void onYesSelection() {
    }

    protected void onNoSelection() {
    }
}

