/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.util.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import layout.TableLayout;
import org.openmicroscopy.shoola.util.ui.UIUtilities;

public class NotificationDialog
extends JDialog {
    protected static final Dimension MSG_AREA_SIZE = new Dimension(300, 50);
    protected static final Dimension H_SPACER_SIZE = new Dimension(20, 1);
    protected static final Dimension V_SPACER_SIZE = new Dimension(1, 20);
    protected static final Color DEFAULT_COLOR = Color.WHITE;
    protected JPanel contentPanel;
    protected JPanel messagePanel;
    protected JPanel buttonPanel;
    protected JButton okButton;

    private void createComponents() {
        this.contentPanel = new JPanel();
        this.contentPanel.setOpaque(true);
        this.messagePanel = new JPanel();
        this.messagePanel.setOpaque(true);
        this.buttonPanel = new JPanel();
        this.buttonPanel.setOpaque(true);
        this.okButton = new JButton("OK");
        this.getRootPane().setDefaultButton(this.okButton);
    }

    private void attachListeners() {
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent we) {
                NotificationDialog.this.close();
            }
        });
        this.okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                NotificationDialog.this.close();
            }
        });
    }

    private void close() {
        this.setVisible(false);
        this.dispose();
    }

    private void buildMessagePanel(String msg, Icon icon) {
        int iconSpace = 0;
        if (icon != null) {
            iconSpace = icon.getIconWidth() + 20;
        }
        double[][] tableSize = new double[][]{{iconSpace, 160 - iconSpace, -1.0}, {-1.0}};
        TableLayout layout = new TableLayout((double[][])tableSize);
        this.messagePanel.setLayout((LayoutManager)layout);
        this.messagePanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        if (icon != null) {
            this.messagePanel.add((Component)new JLabel(icon), "0, 0, l, c");
        }
        this.messagePanel.add((Component)UIUtilities.buildTextPane(msg), "1, 0, 2, 0");
    }

    private void buildButtonPanel() {
        this.buttonPanel.setLayout(new BoxLayout(this.buttonPanel, 0));
        this.buttonPanel.add(Box.createHorizontalGlue());
        this.buttonPanel.add(this.okButton);
        this.buttonPanel.add(Box.createRigidArea(H_SPACER_SIZE));
    }

    private void buildGUI(String message, Icon messageIcon) {
        this.contentPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEtchedBorder(), BorderFactory.createEmptyBorder(5, 5, 15, 10)));
        this.contentPanel.setLayout(new BoxLayout(this.contentPanel, 1));
        this.buildMessagePanel(message, messageIcon);
        this.contentPanel.add(this.messagePanel);
        JPanel vSpacer = new JPanel();
        vSpacer.add(Box.createRigidArea(V_SPACER_SIZE));
        this.contentPanel.add(vSpacer);
        this.buildButtonPanel();
        this.contentPanel.add(this.buttonPanel);
        this.getContentPane().add(this.contentPanel);
    }

    public NotificationDialog(JFrame owner, String title, String message, Icon messageIcon) {
        super(owner, title, true);
        this.setAlwaysOnTop(true);
        this.createComponents();
        this.attachListeners();
        this.buildGUI(message, messageIcon);
    }
}

