/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.util.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.UIManager;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;
import javax.swing.text.TabSet;
import javax.swing.text.TabStop;
import layout.TableLayout;
import org.openmicroscopy.shoola.util.ui.IconManager;
import org.openmicroscopy.shoola.util.ui.MessengerDetails;
import org.openmicroscopy.shoola.util.ui.MultilineLabel;
import org.openmicroscopy.shoola.util.ui.UIUtilities;

public class MessengerDialog
extends JDialog {
    public static final int ERROR_TYPE = 0;
    public static final int COMMENT_TYPE = 1;
    public static final String SEND_PROPERTY = "send";
    private static final Dimension DEFAULT_SIZE = new Dimension(700, 400);
    private static final String CANCEL_TOOLTIP = "Cancel your message";
    private static final String SEND_TOOLTIP = "Send the information to the development team";
    private static final String COPY_TOOLTIP = "Copy the Exception Message to the clipboard";
    private static final String MESSAGE = "Thank you for taking the time to send us your comments. \n\nYour feedback will be used to further the development of OMERO and improve our software. Any personal details you provide are purely optional, and will only be used for development purposes.";
    private static final String DEBUG_MESSAGE = "An error message has been generated by the application.\n\nTo help us improve our software, please fill out the following form. Your personal details are purely optional, and will only be used for development purposes.\n\nPlease note that your application may need to be restarted to work properly.";
    private static final String EMAIL_MESSAGE = "The e-mail address entered \n does not seem to be valid. \n Please enter a new e-mail address.";
    private static final String COMMENT_FIELD = "Comment: ";
    private static final String DEBUG_COMMENT_FIELD = "What you were doing when you crashed?";
    private static final String EMAIL_FIELD = "Email: ";
    private static final String EMAIL_TOOLTIP = "Enter your email address here.";
    private static final String EMAIL_SUFFIX = " (Optional)";
    private int dialogType;
    private JButton cancelButton;
    private JButton sendButton;
    private JTextField emailArea;
    private MultilineLabel commentArea;
    private String emailAddress;
    private Exception exception;
    private JTextPane debugArea;
    private JButton copyButton;

    private void formatButton(JButton b, int mnemonic, String tooltip) {
        b.setMnemonic(mnemonic);
        b.setOpaque(false);
        b.setToolTipText(tooltip);
    }

    private void close() {
        this.setVisible(false);
        this.dispose();
    }

    private void copy() {
        if (this.debugArea != null) {
            this.debugArea.selectAll();
            this.debugArea.copy();
        }
    }

    private boolean checkValidEmail(String email) {
        if (email == null || email.length() == 0) {
            return true;
        }
        String[] array = email.split("@");
        if (array == null || array.length != 2) {
            return false;
        }
        return array[1].contains(".");
    }

    private void send() {
        String email = this.emailArea.getText().trim();
        String comment = this.commentArea.getText().trim();
        if (!this.checkValidEmail(email)) {
            JOptionPane.showMessageDialog(this, EMAIL_MESSAGE, "Unvalid email", 1);
            return;
        }
        String error = null;
        if (this.debugArea != null) {
            error = this.debugArea.getText().trim();
        }
        MessengerDetails details = new MessengerDetails(email, comment);
        details.setExtra("Add extra info");
        details.setError(error);
        this.firePropertyChange(SEND_PROPERTY, null, details);
    }

    private void initComponents() {
        this.cancelButton = new JButton("Cancel");
        this.formatButton(this.cancelButton, 67, CANCEL_TOOLTIP);
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MessengerDialog.this.close();
            }
        });
        this.sendButton = new JButton("Send");
        this.formatButton(this.sendButton, 83, SEND_TOOLTIP);
        this.sendButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MessengerDialog.this.send();
            }
        });
        this.emailArea = new JTextField(20);
        this.emailArea.setToolTipText(EMAIL_TOOLTIP);
        this.emailArea.setText(this.emailAddress);
        this.commentArea = new MultilineLabel();
        this.commentArea.setEditable(true);
        this.commentArea.setBorder(BorderFactory.createBevelBorder(1));
        this.commentArea.setBackground(Color.WHITE);
        this.commentArea.setOpaque(true);
        if (this.exception != null) {
            this.debugArea = this.buildExceptionArea();
            this.copyButton = new JButton("Copy to Clipboard");
            this.formatButton(this.copyButton, 67, COPY_TOOLTIP);
            this.copyButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    MessengerDialog.this.copy();
                }
            });
        }
        this.getRootPane().setDefaultButton(this.sendButton);
        this.setAlwaysOnTop(true);
    }

    private JTextPane buildExceptionArea() {
        StyleContext context = new StyleContext();
        DefaultStyledDocument document = new DefaultStyledDocument(context);
        JTextPane textPane = new JTextPane(document);
        textPane.setOpaque(false);
        textPane.setEditable(false);
        ArrayList<TabStop> list = new ArrayList<TabStop>();
        float pos = 15.0f;
        int align = 0;
        int leader = 0;
        TabStop tstop = new TabStop(pos, align, leader);
        list.add(tstop);
        pos = 15.0f;
        align = 1;
        leader = 0;
        tstop = new TabStop(pos, align, leader);
        list.add(tstop);
        pos = 15.0f;
        align = 2;
        leader = 0;
        tstop = new TabStop(pos, align, leader);
        list.add(tstop);
        pos = 15.0f;
        align = 4;
        leader = 0;
        tstop = new TabStop(pos, align, leader);
        list.add(tstop);
        TabSet tabs = new TabSet(list.toArray(new TabStop[0]));
        Style style = textPane.getLogicalStyle();
        StyleConstants.setTabSet(style, tabs);
        textPane.setLogicalStyle(style);
        Style debugStyle = document.addStyle("StyleName", null);
        StyleConstants.setForeground(debugStyle, Color.BLACK);
        StyleConstants.setFontFamily(debugStyle, "SansSerif");
        StyleConstants.setFontSize(debugStyle, 12);
        StyleConstants.setBold(debugStyle, false);
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        this.exception.printStackTrace(pw);
        try {
            document.insertString(document.getLength(), sw.toString(), style);
        }
        catch (BadLocationException e) {
            // empty catch block
        }
        return textPane;
    }

    private JPanel buildCommentAreaPanel(String comment, int mnemonic) {
        JPanel panel = new JPanel();
        panel.setOpaque(false);
        double[][] size = new double[][]{{-1.0}, {20.0, -1.0}};
        TableLayout layout = new TableLayout((double[][])size);
        panel.setLayout((LayoutManager)layout);
        JScrollPane areaScrollPane = new JScrollPane(this.commentArea);
        areaScrollPane.setVerticalScrollBarPolicy(20);
        JLabel label = new JLabel(comment);
        label.setOpaque(false);
        label.setDisplayedMnemonic(mnemonic);
        panel.add((Component)label, "0, 0, l, c");
        panel.add((Component)areaScrollPane, "0, 1, f, f");
        return panel;
    }

    private JPanel buildEmailAreaPanel(int mnemonic) {
        Object size = null;
        JPanel panel = new JPanel();
        panel.setOpaque(false);
        size = EMAIL_SUFFIX.length() == 0 ? (Object)new double[][]{{-2.0, -1.0}, {30.0}} : (Object)new double[][]{{-2.0, -1.0, -2.0}, {30.0}};
        TableLayout layout = new TableLayout((double[][])size);
        panel.setLayout((LayoutManager)layout);
        JLabel label = new JLabel(EMAIL_FIELD);
        label.setDisplayedMnemonic(mnemonic);
        label.setLabelFor(this.emailArea);
        label.setOpaque(false);
        panel.add((Component)label, "0, 0, r, c");
        panel.add((Component)this.emailArea, "1, 0, f, c");
        if (EMAIL_SUFFIX.length() != 0) {
            panel.add((Component)new JLabel(EMAIL_SUFFIX), "2, 0, l, c");
        }
        return panel;
    }

    private JPanel buildDebugPanel() {
        JPanel panel = new JPanel();
        panel.setOpaque(false);
        double[][] tableSize = new double[][]{{-1.0}, {-1.0, 32.0}};
        TableLayout layout = new TableLayout((double[][])tableSize);
        panel.setLayout((LayoutManager)layout);
        panel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        panel.add((Component)new JScrollPane(this.debugArea), "0, 0");
        panel.add((Component)this.copyButton, "0, 1, c, b");
        return panel;
    }

    private JPanel buildCommentPanel(String instructions, String comment, Icon icon) {
        JPanel commentPanel = new JPanel();
        int iconSpace = 0;
        if (icon != null) {
            iconSpace = icon.getIconWidth() + 20;
        }
        double[][] tableSize = new double[][]{{iconSpace, 160 - iconSpace, -1.0}, {100.0, 30.0, -1.0}};
        TableLayout layout = new TableLayout((double[][])tableSize);
        commentPanel.setLayout((LayoutManager)layout);
        commentPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        if (icon != null) {
            commentPanel.add((Component)new JLabel(icon), "0, 0, l, c");
        }
        commentPanel.add((Component)UIUtilities.buildTextPane(instructions), "1, 0, 2, 0");
        commentPanel.add((Component)this.buildEmailAreaPanel(69), "0, 1, 2, 1");
        commentPanel.add((Component)this.buildCommentAreaPanel(comment, 87), "0, 2, 2, 2");
        return commentPanel;
    }

    private JTabbedPane buildExceptionPane() {
        JTabbedPane tPane = new JTabbedPane();
        tPane.setOpaque(false);
        IconManager icons = IconManager.getInstance();
        Icon icon = icons.getIcon(22);
        if (icon == null) {
            icon = UIManager.getIcon("OptionPane.errorIcon");
        }
        tPane.addTab("Comments", null, this.buildCommentPanel(DEBUG_MESSAGE, DEBUG_COMMENT_FIELD, icon), "Your comments go here.");
        tPane.addTab("Error Message", null, this.buildDebugPanel(), "The Exception Message.");
        return tPane;
    }

    private void buildGUI() {
        JComponent component;
        JPanel mainPanel = new JPanel();
        mainPanel.setOpaque(false);
        double[][] tableSize = new double[][]{{-1.0, 100.0, 5.0, 100.0, 10.0}, {-1.0, 40.0}};
        TableLayout layout = new TableLayout((double[][])tableSize);
        mainPanel.setLayout((LayoutManager)layout);
        mainPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        mainPanel.add((Component)this.cancelButton, "1, 1, f, c");
        mainPanel.add((Component)this.sendButton, "3, 1, f, c");
        if (this.exception == null) {
            IconManager icons = IconManager.getInstance();
            Icon icon = icons.getIcon(21);
            if (icon == null) {
                icon = UIManager.getIcon("OptionPane.questionIcon");
            }
            component = this.buildCommentPanel(MESSAGE, COMMENT_FIELD, icon);
        } else {
            component = this.buildExceptionPane();
        }
        mainPanel.add((Component)component, "0, 0, 4, 0");
        this.getContentPane().add((Component)mainPanel, "Center");
    }

    private void initialize(String title) {
        this.setTitle(title);
        this.setSize(DEFAULT_SIZE);
        this.initComponents();
        this.buildGUI();
    }

    public MessengerDialog(JFrame parent, String title, String emailAddress) {
        super(parent);
        this.emailAddress = emailAddress;
        this.dialogType = 1;
        this.initialize(title);
    }

    public MessengerDialog(JFrame parent, String title, String emailAddress, Exception exception) {
        super(parent);
        this.dialogType = 0;
        this.emailAddress = emailAddress;
        this.exception = exception;
        this.initialize(title);
    }

    public int getDialogType() {
        return this.dialogType;
    }
}

