/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.util.ui;

import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.openmicroscopy.shoola.util.ui.IconFactory;

public class IconManager {
    public static final int COLOUR_SLIDER = 0;
    public static final int COLOUR_SWATCH = 1;
    public static final int COLOUR_WHEEL = 2;
    public static final int CANCEL = 3;
    public static final int OK = 4;
    public static final int UNDO = 5;
    public static final int THUMB = 6;
    public static final int THUMB_DISABLED = 7;
    public static final int UP_ARROW = 8;
    public static final int DOWN_ARROW = 9;
    public static final int LEFT_ARROW = 10;
    public static final int RIGHT_ARROW = 11;
    public static final int UP_ARROW_DISABLED = 12;
    public static final int DOWN_ARROW_DISABLED = 13;
    public static final int LEFT_ARROW_DISABLED = 14;
    public static final int RIGHT_ARROW_DISABLED = 15;
    public static final int QUESTION_ICON = 16;
    public static final int ANNOTATION_48 = 17;
    public static final int INFO = 18;
    public static final int PROGRESS = 19;
    public static final int CLASSIFICATION_48 = 20;
    public static final int COMMENT_ICON_64 = 21;
    public static final int ERROR_ICON_64 = 22;
    public static final int SERVER = 23;
    public static final int REMOVE = 24;
    public static final int CONFIG = 25;
    public static final int CONFIG_PRESSED = 26;
    public static final int CONFIG_48 = 27;
    public static final int ADD = 28;
    public static final int INFO_32 = 29;
    public static final int DOWNLOAD_48 = 30;
    public static final int MINUS = 31;
    public static final int MINUS_OVER = 32;
    public static final int PLUS = 33;
    public static final int PLUS_OVER = 34;
    public static final int CROSS = 35;
    public static final int CROSS_OVER = 36;
    public static final int ERROR = 37;
    public static final int HISTORY = 38;
    public static final int BACKWARD_NAV = 39;
    public static final int TRASH_CAN = 40;
    public static final int SAVE = 41;
    public static final int OWNER = 42;
    public static final int CALENDAR = 43;
    public static final int IMAGE = 44;
    public static final int DATASET = 45;
    private static int MAX_ID = 49;
    private static String[] relPaths = new String[MAX_ID + 1];
    private static IconManager singleton;
    private IconFactory factory = new IconFactory();

    public Icon getIcon(int id) {
        if (id < 0 || relPaths.length <= id) {
            return null;
        }
        return this.getIcon(relPaths[id]);
    }

    public Icon getIcon(String name) {
        Icon icon = this.factory.getIcon(name);
        if (icon == null) {
            StringBuffer buf = new StringBuffer("Failed to retrieve icon: ");
            buf.append("<classpath>");
            buf.append(this.factory.getResourcePathname(name));
            buf.append(".");
        }
        return icon;
    }

    public ImageIcon getImageIcon(int id) {
        if (id < 0 || relPaths.length <= id) {
            return null;
        }
        return this.getImageIcon(relPaths[id]);
    }

    public ImageIcon getImageIcon(String name) {
        ImageIcon icon = this.factory.getImageIcon(name);
        if (icon == null) {
            StringBuffer buf = new StringBuffer("Failed to retrieve icon: ");
            buf.append("<classpath>");
            buf.append(this.factory.getResourcePathname(name));
            buf.append(".");
        }
        return icon;
    }

    public static IconManager getInstance() {
        if (singleton == null) {
            singleton = new IconManager();
        }
        return singleton;
    }

    private IconManager() {
    }

    static {
        IconManager.relPaths[0] = "coloursliders24.png";
        IconManager.relPaths[1] = "colourswatch24.png";
        IconManager.relPaths[2] = "colourwheel24.png";
        IconManager.relPaths[3] = "nuvola_cancel22.png";
        IconManager.relPaths[4] = "nuvola_button_accept22.png";
        IconManager.relPaths[5] = "nuvola_undo22.png";
        IconManager.relPaths[6] = "sliderthumb.png";
        IconManager.relPaths[7] = "sliderthumb_disabled.png";
        IconManager.relPaths[8] = "nuvola_player_play10_up.png";
        IconManager.relPaths[9] = "nuvola_player_play10_down.png";
        IconManager.relPaths[10] = "nuvola_player_play10_left.png";
        IconManager.relPaths[11] = "nuvola_player_play10_right.png";
        IconManager.relPaths[12] = "nuvola_player_play10_up_disabled.png";
        IconManager.relPaths[13] = "nuvola_player_play10_down_disabled.png";
        IconManager.relPaths[14] = "nuvola_player_play10_left_disabled.png";
        IconManager.relPaths[15] = "nuvola_player_play10_right_disabled.png";
        IconManager.relPaths[16] = "nuvola_filetypes48.png";
        IconManager.relPaths[17] = "nuvola_kwrite48.png";
        IconManager.relPaths[18] = "nuvola_messagebox_info16.png";
        IconManager.relPaths[19] = "eclipse_progress_none16";
        IconManager.relPaths[20] = "nuvola_filenew48.png";
        IconManager.relPaths[22] = "nuvola_error64.png";
        IconManager.relPaths[21] = "nuvola_knotes64.png";
        IconManager.relPaths[23] = "nuvola_server22.png";
        IconManager.relPaths[25] = "config.png";
        IconManager.relPaths[26] = "config_pressed.png";
        IconManager.relPaths[27] = "nuvola_configure48.png";
        IconManager.relPaths[24] = "nuvola_edit_remove16.png";
        IconManager.relPaths[28] = "nuvola_edit_add16.png";
        IconManager.relPaths[29] = "nuvola_messagebox_info32.png";
        IconManager.relPaths[30] = "nuvola_download_manager48.png";
        IconManager.relPaths[31] = "minus.png";
        IconManager.relPaths[32] = "minus_over.png";
        IconManager.relPaths[33] = "plus.png";
        IconManager.relPaths[34] = "plus_over.png";
        IconManager.relPaths[35] = "cross.png";
        IconManager.relPaths[36] = "cross_over.png";
        IconManager.relPaths[37] = "eclipse_error_tsk16.png";
        IconManager.relPaths[38] = "eclipse_history_list16.png";
        IconManager.relPaths[39] = "eclipse_backward_nav16.png";
        IconManager.relPaths[40] = "nuvola_trashcan_full16.png";
        IconManager.relPaths[41] = "nuvola_filesaveas16.png";
        IconManager.relPaths[42] = "nuvola_kdmconfig16.png";
        IconManager.relPaths[43] = "nuvola_date16.png";
        IconManager.relPaths[45] = "nuvola_folder_image16.png";
        IconManager.relPaths[44] = "nuvola_image16.png";
    }
}

