/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.util.ui;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.FontMetrics;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class HistoryDialog
extends JPopupMenu {
    public static final String SELECTION_PROPERTY = "selection";
    private JList history;
    private int width;
    private Object[] data;

    private void buildGUI() {
        JPanel list = new JPanel();
        list.setLayout(new BorderLayout());
        list.add(this.history);
        FontMetrics fm = this.getFontMetrics(this.history.getFont());
        int height = fm.getHeight() * this.data.length + 4;
        Dimension d = new Dimension(this.width, height);
        list.setSize(d);
        list.setPreferredSize(d);
        this.add(list);
    }

    private void initComponents() {
        this.history = new JList<Object>(this.data);
        this.history.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                ListSelectionModel model = (ListSelectionModel)e.getSource();
                if (!model.isSelectionEmpty() && e.getValueIsAdjusting()) {
                    int minIndex = model.getMinSelectionIndex();
                    int maxIndex = model.getMaxSelectionIndex();
                    for (int i = minIndex; i <= maxIndex; ++i) {
                        if (!model.isSelectedIndex(i)) continue;
                        HistoryDialog.this.firePropertyChange(HistoryDialog.SELECTION_PROPERTY, null, HistoryDialog.this.data[i]);
                        HistoryDialog.this.setVisible(false);
                    }
                }
            }
        });
    }

    public HistoryDialog(Object[] data, int width) {
        this.data = data;
        this.width = width;
        this.initComponents();
        this.buildGUI();
    }
}

