/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.util.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.io.File;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.UIManager;
import org.openmicroscopy.shoola.util.ui.FolderChooser;
import org.openmicroscopy.shoola.util.ui.IconManager;
import org.openmicroscopy.shoola.util.ui.TitlePanel;
import org.openmicroscopy.shoola.util.ui.UIUtilities;

public class FolderChooserDialog
extends JDialog {
    static final String TITLE = "Download archived files";
    public static final String LOCATION_PROPERTY = "location";
    private static final String TEXT = "Select a directory where to download the files.";
    private JCheckBox settings;
    private FolderChooser chooser;

    private void initComponents() {
        this.settings = new JCheckBox();
        this.settings.setText("Set the current directory as default.");
        this.settings.setSelected(true);
        this.chooser = new FolderChooser(this);
    }

    private void buildGUI() {
        boolean supportsWindowDecorations;
        JPanel p = new JPanel();
        p.setLayout(new BorderLayout(0, 0));
        p.add((Component)this.chooser, "Center");
        p.add((Component)UIUtilities.buildComponentPanel(this.settings), "South");
        IconManager im = IconManager.getInstance();
        Container c = this.getContentPane();
        c.setLayout(new BorderLayout(0, 0));
        TitlePanel tp = new TitlePanel(TITLE, TEXT, im.getIcon(30));
        c.add((Component)tp, "North");
        c.add((Component)p, "Center");
        if (JDialog.isDefaultLookAndFeelDecorated() && (supportsWindowDecorations = UIManager.getLookAndFeel().getSupportsWindowDecorations())) {
            this.getRootPane().setWindowDecorationStyle(6);
        }
    }

    private void setProperties() {
        this.setTitle(TITLE);
        this.setModal(true);
    }

    public FolderChooserDialog(JFrame owner) {
        super(owner);
        this.setProperties();
        this.initComponents();
        this.buildGUI();
        this.pack();
    }

    void close() {
        this.setVisible(false);
        this.dispose();
    }

    void setFolderPath(String path) {
        if (path == null) {
            return;
        }
        char separator = File.separatorChar;
        this.firePropertyChange(LOCATION_PROPERTY, null, path + separator);
        if (this.settings.isSelected()) {
            UIUtilities.setDefaultFolder(path);
        }
        this.close();
    }
}

