/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.util.ui;

import java.io.File;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JTextField;
import org.openmicroscopy.shoola.util.ui.FolderChooserDialog;
import org.openmicroscopy.shoola.util.ui.UIUtilities;

class FolderChooser
extends JFileChooser {
    private FolderChooserDialog model;

    private void initialize() {
        JTextField field;
        JLabel label = (JLabel)UIUtilities.findComponent(this, JLabel.class);
        if (label != null) {
            label.setText("Selected Folder:");
        }
        if ((field = (JTextField)UIUtilities.findComponent(this, JTextField.class)) != null) {
            field.setEditable(false);
        }
        this.setAcceptAllFileFilterUsed(false);
        this.setDialogType(2);
        this.setFileSelectionMode(1);
        this.setApproveButtonText("Download");
        this.setApproveButtonToolTipText("Download archived files");
        String s = UIUtilities.getDefaultFolderAsString();
        if (s == null) {
            return;
        }
        if (s == null || s.equals("") || !new File(s).exists()) {
            this.setCurrentDirectory(this.getFileSystemView().getHomeDirectory());
        } else {
            this.setCurrentDirectory(new File(s));
        }
    }

    FolderChooser(FolderChooserDialog model) {
        if (model == null) {
            throw new NullPointerException("No model.");
        }
        this.model = model;
        this.initialize();
    }

    public void cancelSelection() {
        this.model.close();
        super.cancelSelection();
    }

    public void approveSelection() {
        File file = this.getSelectedFile();
        if (file != null) {
            this.model.setFolderPath(file.getAbsolutePath());
        }
        super.approveSelection();
    }
}

