/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.util.ui;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Stroke;
import javax.swing.JComponent;
import javax.swing.plaf.basic.BasicButtonUI;
import org.openmicroscopy.shoola.util.ui.ColouredButton;
import org.openmicroscopy.shoola.util.ui.colour.HSV;

class ColouredButtonUI
extends BasicButtonUI {
    private static final Color GRADIENT_START = new Color(0.8f, 0.8f, 0.8f, 1.0f);
    private static final Color GRADIENT_END = new Color(0.5f, 0.5f, 0.5f, 1.0f);
    private static final Stroke STROKE = new BasicStroke(1.0f);
    private Color colour;
    private ColouredButton button;
    private Rectangle buttonRect;
    private HSV gradientStartHSV;
    private Color gradientStartRGB;
    private HSV gradientEndHSV;
    private Color gradientEndRGB;
    private boolean greyedOut;
    private int fontIndex;

    private void drawGreyMask(Graphics2D g) {
        GradientPaint gp = new GradientPaint((int)this.buttonRect.getX(), (int)this.buttonRect.getY(), GRADIENT_START, (int)this.buttonRect.getWidth(), (int)this.buttonRect.getHeight(), GRADIENT_END, false);
        g.setPaint(gp);
        g.fill(this.buttonRect);
    }

    private void drawText(Graphics2D g) {
        HSV col = new HSV(this.colour);
        Font fnt = this.button.getFont();
        fnt = fnt.deriveFont(this.fontIndex, 10.0f);
        g.setFont(fnt);
        FontMetrics fm = g.getFontMetrics();
        int x = (int)((float)this.buttonRect.width / 2.0f - (float)(fm.stringWidth(this.button.getText()) / 2));
        int y = (int)((float)this.buttonRect.height / 2.0f + (float)((fm.getHeight() - fm.getDescent()) / 2));
        if ((double)col.getValue() < 0.6 || (double)col.getHue() > 0.6 && (double)col.getSaturation() > 0.7 || this.greyedOut) {
            g.setPaint(Color.white);
        } else {
            g.setPaint(Color.black);
        }
        g.drawString(this.button.getText(), x, y);
    }

    private void setGradientColours() {
        float topGradientSaturation;
        float bottomGradientSaturation;
        HSV col = new HSV(this.colour);
        float topGradientValue = col.getValue();
        float bottomGradientValue = col.getValue();
        if (col.getSaturation() == 0.0f) {
            topGradientSaturation = bottomGradientSaturation = col.getSaturation();
            topGradientValue = col.getValue() + 0.3f;
            if (col.getValue() * 1.3f > topGradientValue) {
                topGradientValue = col.getValue() * 1.3f;
            }
            if (topGradientValue > 1.0f) {
                topGradientValue = 1.0f;
            }
            bottomGradientValue = col.getValue() * 0.75f;
        } else {
            topGradientValue = col.getValue() * 1.5f;
            if (topGradientValue > 1.0f) {
                topGradientValue = 1.0f;
            }
            topGradientSaturation = col.getSaturation() * 0.6f;
            bottomGradientSaturation = col.getSaturation();
        }
        this.gradientStartHSV = new HSV(col.getHue(), topGradientSaturation, topGradientValue, 1.0f);
        this.gradientStartRGB = this.gradientStartHSV.toColorA();
        this.gradientEndHSV = new HSV(col.getHue(), bottomGradientSaturation, bottomGradientValue, 1.0f);
        this.gradientEndRGB = this.gradientEndHSV.toColorA();
    }

    private void drawButtonFace(Graphics2D g) {
        g.setPaint(this.colour);
        g.fill(this.buttonRect);
        GradientPaint gp = new GradientPaint((int)this.buttonRect.getX(), (int)this.buttonRect.getY(), this.gradientStartRGB, (int)this.buttonRect.getWidth(), (int)this.buttonRect.getHeight(), this.gradientEndRGB, false);
        g.setPaint(gp);
        g.fill(this.buttonRect);
    }

    private void drawSelectedButtonFace(Graphics2D g) {
        GradientPaint gp = new GradientPaint((int)this.buttonRect.getX(), (int)this.buttonRect.getY(), this.gradientEndRGB, (int)this.buttonRect.getWidth(), (int)this.buttonRect.getHeight(), this.gradientEndRGB, false);
        g.setPaint(gp);
        g.fill(this.buttonRect);
    }

    private void drawBorder(Graphics2D g) {
        Color borderColour = this.gradientStartRGB.brighter();
        g.setPaint(borderColour);
        g.drawLine(0, 0, 0, (int)this.buttonRect.getHeight());
        g.drawLine(0, 0, (int)this.buttonRect.getWidth(), 0);
        g.drawLine(1, 1, 1, (int)this.buttonRect.getHeight() - 1);
        g.drawLine(1, 1, (int)this.buttonRect.getWidth() - 1, 1);
        borderColour = this.gradientEndRGB.darker();
        g.setPaint(borderColour);
        g.drawLine((int)this.buttonRect.getWidth() - 1, 0, (int)this.buttonRect.getWidth() - 1, (int)this.buttonRect.getHeight() - 1);
        g.drawLine(0, (int)this.buttonRect.getHeight() - 1, (int)this.buttonRect.getWidth() - 1, (int)this.buttonRect.getHeight() - 1);
        g.drawLine((int)this.buttonRect.getWidth() - 2, 2, (int)this.buttonRect.getWidth() - 2, (int)this.buttonRect.getHeight() - 2);
        g.drawLine(1, (int)this.buttonRect.getHeight() - 2, (int)this.buttonRect.getWidth() - 1, (int)this.buttonRect.getHeight() - 2);
    }

    private void drawGreyBorder(Graphics2D g) {
        HSV borderColourHSV = new HSV(0.0f, 0.0f, this.gradientStartHSV.getValue(), 0.8f);
        Color borderColour = borderColourHSV.toColorA();
        g.setPaint(borderColour);
        g.setStroke(STROKE);
        int height = (int)this.buttonRect.getHeight();
        int width = (int)this.buttonRect.getWidth();
        g.drawLine(0, 0, 0, height);
        g.drawLine(0, 0, width, 0);
        g.drawLine(1, 1, 1, height - 1);
        g.drawLine(1, 1, width - 1, 1);
        borderColourHSV = new HSV(0.0f, 0.0f, this.gradientEndHSV.getValue(), 0.8f);
        borderColour = borderColourHSV.toColorA();
        g.setPaint(borderColour.darker().darker().darker());
        g.drawLine(width - 1, 0, width - 1, height - 1);
        g.drawLine(0, height - 1, width - 1, height - 1);
        g.drawLine(width - 2, 2, width - 2, height - 2);
        g.drawLine(1, height - 2, width - 1, height - 2);
    }

    private void drawGreySelectedBorder(Graphics2D g) {
        HSV borderColourHSV = new HSV(0.0f, 0.0f, this.gradientEndHSV.getValue(), 0.8f);
        Color borderColour = borderColourHSV.toColorA();
        g.setPaint(borderColour.darker().darker().darker());
        g.setStroke(STROKE);
        int height = (int)this.buttonRect.getHeight();
        int width = (int)this.buttonRect.getWidth();
        g.drawLine(0, 0, 0, height);
        g.drawLine(0, 0, width, 0);
        g.drawLine(1, 1, 1, height - 1);
        g.drawLine(1, 1, width - 1, 1);
        borderColourHSV = new HSV(0.0f, 0.0f, this.gradientStartHSV.getValue(), 0.8f);
        borderColour = borderColourHSV.toColorA();
        g.setPaint(borderColour.darker());
        g.drawLine(width - 1, 0, width - 1, height - 1);
        g.drawLine(0, height - 1, width - 1, height - 1);
        g.drawLine(width - 2, 2, width - 2, height - 2);
        g.drawLine(1, height - 2, width - 1, height - 2);
    }

    private void drawSelectedBorder(Graphics2D g) {
        Color borderColour = this.gradientEndRGB.darker();
        HSV col = new HSV(borderColour);
        g.setPaint(col.toColorA());
        g.setStroke(STROKE);
        int height = (int)this.buttonRect.getHeight();
        int width = (int)this.buttonRect.getWidth();
        g.drawLine(0, 0, 0, height);
        g.drawLine(0, 0, width, 0);
        g.drawLine(1, 1, 1, height - 1);
        g.drawLine(1, 1, width - 1, 1);
        borderColour = this.gradientStartRGB;
        col = new HSV(borderColour);
        col.setSaturation(col.getSaturation() * 0.8f);
        borderColour = col.toColorA();
        g.setPaint(borderColour);
        g.drawLine(width - 1, 0, width - 1, (int)this.buttonRect.getHeight() - 1);
        g.drawLine(0, height - 1, width - 1, height - 1);
        g.drawLine(width - 2, 2, width - 2, height - 2);
        g.drawLine(1, width - 2, width - 1, height - 2);
    }

    private void paintSquareButton(Graphics2D g) {
        this.setGradientColours();
        if (this.button.isSelected()) {
            this.drawSelectedButtonFace(g);
            if (!this.greyedOut) {
                this.drawSelectedBorder(g);
            } else {
                this.drawGreyMask(g);
                this.drawGreySelectedBorder(g);
            }
        } else {
            this.drawButtonFace(g);
            if (!this.greyedOut) {
                this.drawBorder(g);
            } else {
                this.drawGreyMask(g);
                this.drawGreyBorder(g);
            }
        }
        this.drawText(g);
    }

    ColouredButtonUI(ColouredButton b, Color c) {
        if (b == null) {
            throw new IllegalArgumentException("No button.");
        }
        if (c == null) {
            throw new IllegalArgumentException("No color.");
        }
        this.setColor(c);
        this.button = b;
        this.greyedOut = false;
        this.fontIndex = 0;
        this.uninstallListeners(b);
    }

    void setGrayedOut(boolean greyedOut) {
        this.greyedOut = greyedOut;
    }

    void setColor(Color c) {
        if (c == null) {
            throw new IllegalArgumentException("No color.");
        }
        this.colour = c;
    }

    void setDeriveFont(int fontIndex) {
        this.fontIndex = fontIndex;
    }

    public void paint(Graphics og, JComponent comp) {
        Graphics2D g = (Graphics2D)og;
        this.buttonRect = new Rectangle(comp.getWidth(), comp.getHeight());
        this.paintSquareButton(g);
    }
}

