/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.util.ui;

import java.awt.Color;
import java.awt.Dimension;
import javax.swing.AbstractButton;
import javax.swing.DefaultButtonModel;
import org.openmicroscopy.shoola.util.ui.ColouredButtonUI;

public class ColouredButton
extends AbstractButton {
    private ColouredButtonUI uiDelegate;

    public ColouredButton(String text, Color color) {
        if (color == null) {
            throw new IllegalArgumentException("No color.");
        }
        this.setModel(new DefaultButtonModel());
        this.init(text, null);
        this.uiDelegate = new ColouredButtonUI(this, color);
        this.setUI(this.uiDelegate);
        this.setRolloverEnabled(false);
        this.setBorder(null);
    }

    public void setGrayedOut(boolean greyedOut) {
        if (this.uiDelegate == null) {
            return;
        }
        this.uiDelegate.setGrayedOut(greyedOut);
        this.repaint();
    }

    public void setColor(Color c) {
        if (this.uiDelegate != null && c != null) {
            this.uiDelegate.setColor(c);
        }
        this.repaint();
    }

    public void setFontIndex(int index) {
        if (this.uiDelegate != null) {
            this.uiDelegate.setDeriveFont(index);
        }
    }

    public void setBackground(Color c) {
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public Dimension getMaximumSize() {
        return this.getPreferredSize();
    }
}

