/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.util.ui;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import javax.swing.ImageIcon;
import javax.swing.JMenuItem;

public class ColorMenuItem
extends JMenuItem {
    private static final int ICON_WIDTH = 16;
    private static final int ICON_HEIGHT = 16;
    private static final int MINIMUM = 4;
    private Color color;
    private int iconWidth = 16;
    private int iconHeight = 16;

    private ImageIcon createIcon() {
        BufferedImage img = new BufferedImage(this.iconWidth, this.iconHeight, 2);
        Graphics2D g = (Graphics2D)img.getGraphics();
        g.setColor(this.color);
        g.fillRect(0, 0, this.iconWidth, this.iconHeight);
        g.setColor(this.color.darker());
        g.drawRect(0, 0, this.iconWidth, this.iconHeight);
        return new ImageIcon(img);
    }

    public ColorMenuItem(Color c) {
        this.setColor(c);
        this.iconWidth = 16;
        this.iconHeight = 16;
    }

    public ColorMenuItem(String text, Color c) {
        this.setColor(c);
        this.setText(text);
        this.iconWidth = 16;
        this.iconHeight = 16;
    }

    public void setColor(Color c) {
        if (c == null) {
            throw new IllegalArgumentException("No color specified.");
        }
        this.color = c;
        this.setIcon(this.createIcon());
    }

    public Color getColor() {
        return this.color;
    }

    public void setIconWidth(int w) {
        if (w > 4) {
            this.iconWidth = w;
        }
    }

    public void setIconHeight(int h) {
        if (h > 4) {
            this.iconHeight = h;
        }
    }

    public int getIconWidth() {
        return this.iconWidth;
    }

    public int getIconHeight() {
        return this.iconHeight;
    }
}

