/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.util.roi.model.annotation;

import java.util.Map;
import org.openmicroscopy.shoola.util.roi.model.ROI;
import org.openmicroscopy.shoola.util.roi.model.ROIShape;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotationKey<T> {
    private String key;
    private T defaultValue;
    private boolean isNullValueAllowed;

    public AnnotationKey(String key) {
        this(key, null, true);
    }

    public AnnotationKey(String key, T defaultValue) {
        this(key, defaultValue, true);
    }

    public AnnotationKey(String key, T defaultValue, boolean isNullValueAllowed) {
        this.key = key;
        this.defaultValue = defaultValue;
        this.isNullValueAllowed = isNullValueAllowed;
    }

    public String getKey() {
        return this.key;
    }

    public T getDefaultValue() {
        return this.defaultValue;
    }

    public T get(ROIShape shape) {
        Object value = shape.getAnnotation(this);
        return (T)(value == null && !this.isNullValueAllowed ? this.defaultValue : value);
    }

    public T get(ROI roi) {
        Object value = roi.getAnnotation(this);
        return (T)(value == null && !this.isNullValueAllowed ? this.defaultValue : value);
    }

    public T get(Map<AnnotationKey, Object> a) {
        Object value = a.get(this);
        return (T)(value == null && !this.isNullValueAllowed ? this.defaultValue : value);
    }

    public void set(ROIShape shape, T value) {
        if (value == null && !this.isNullValueAllowed) {
            throw new NullPointerException("Null value not allowed for AnnotationKey " + this.key);
        }
        shape.setAnnotation(this, value);
    }

    public void set(ROI roi, T value) {
        if (value == null && !this.isNullValueAllowed) {
            throw new NullPointerException("Null value not allowed for AnnotationKey " + this.key);
        }
        roi.setAnnotation(this, value);
    }

    public void set(Map<AnnotationKey, Object> a, T value) {
        if (value == null && !this.isNullValueAllowed) {
            throw new NullPointerException("Null value not allowed for AnnotationKey " + this.key);
        }
        a.put(this, value);
    }

    public void basicSet(ROIShape shape, T value) {
        if (value == null && !this.isNullValueAllowed) {
            throw new NullPointerException("Null value not allowed for AnnotationKey " + this.key);
        }
        shape.basicSetAnnotation(this, value);
    }

    public void basicSet(ROI roi, T value) {
        if (value == null && !this.isNullValueAllowed) {
            throw new NullPointerException("Null value not allowed for AnnotationKey " + this.key);
        }
        roi.basicSetAnnotation(this, value);
    }

    public boolean equals(Object o) {
        if (o instanceof AnnotationKey) {
            AnnotationKey that = (AnnotationKey)o;
            return that.key.equals(this.key);
        }
        return false;
    }

    public int hashCode() {
        return this.key.hashCode();
    }

    public String toString() {
        return this.key;
    }

    public boolean isNullValueAllowed() {
        return this.isNullValueAllowed;
    }

    public boolean isAssignable(Object value) {
        if (value == null) {
            return this.isNullValueAllowed();
        }
        try {
            Object a = value;
            return true;
        }
        catch (ClassCastException e) {
            return false;
        }
    }
}

