/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.util.roi.model;

import java.util.Iterator;
import java.util.SortedMap;
import java.util.TreeMap;
import org.openmicroscopy.shoola.util.roi.exception.NoSuchROIException;
import org.openmicroscopy.shoola.util.roi.model.ROI;
import org.openmicroscopy.shoola.util.roi.model.ROIShape;
import org.openmicroscopy.shoola.util.roi.model.ShapeList;
import org.openmicroscopy.shoola.util.roi.model.util.Coord3D;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ROICoordMap {
    private TreeMap<Coord3D, ShapeList> coordMap = new TreeMap(new Coord3D());

    public boolean containsKey(Coord3D coord) {
        return this.coordMap.containsKey(coord);
    }

    public boolean containsKey(Coord3D start, Coord3D end) {
        for (int t = start.getTimePoint(); t < end.getTimePoint(); ++t) {
            for (int z = start.getZSection(); z < end.getZSection(); ++z) {
                if (this.coordMap.containsKey(new Coord3D(z, t))) continue;
                return false;
            }
        }
        return true;
    }

    public ShapeList getShapeList(Coord3D coord) throws NoSuchROIException {
        if (!this.containsKey(coord)) {
            throw new NoSuchROIException("No ROIShape on coord " + coord);
        }
        return this.coordMap.get(coord);
    }

    public SortedMap<Coord3D, ShapeList> getShapeList(Coord3D start, Coord3D end) throws NoSuchROIException {
        if (!this.containsKey(start, end)) {
            throw new NoSuchROIException();
        }
        return this.coordMap.subMap(start, end);
    }

    public void deleteROI(ROI roi) throws NoSuchROIException {
        TreeMap<Coord3D, ROIShape> roiMap = roi.getShapes();
        for (ROIShape rOIShape : roiMap.keySet()) {
            ShapeList list = this.coordMap.get(rOIShape.getCoord3D());
            list.deleteShape(rOIShape.getID());
        }
    }

    public void deleteShape(long id, Coord3D coord) throws NoSuchROIException {
        ShapeList shapeList = this.coordMap.get(coord);
        shapeList.deleteShape(id);
        if (shapeList.getList().size() == 0) {
            this.coordMap.remove(coord);
        }
    }

    public void add(ROI roi) {
        TreeMap<Coord3D, ROIShape> roiMap = roi.getShapes();
        Iterator<Coord3D> roiIterator = roiMap.keySet().iterator();
        while (roiIterator.hasNext()) {
            ROIShape shape = roiMap.get(roiIterator.next());
            if (!this.coordMap.containsKey(shape.getCoord3D())) {
                // empty if block
            }
            this.createShapeList(shape.getCoord3D());
            ShapeList shapeList = this.coordMap.get(shape.getCoord3D());
            shapeList.add(roi.getID(), shape);
        }
    }

    public void addShape(long id, Coord3D coord, ROIShape shape) {
        if (!this.coordMap.containsKey(coord)) {
            this.createShapeList(coord);
        }
        ShapeList shapeList = this.coordMap.get(coord);
        shapeList.add(id, shape);
    }

    private void createShapeList(Coord3D coord) {
        ShapeList shapeList = new ShapeList(coord);
        this.coordMap.put(coord, shapeList);
    }

    private void createShapeList(Coord3D start, Coord3D end) {
        for (int t = start.getTimePoint(); t < end.getTimePoint(); ++t) {
            for (int z = start.getZSection(); z < end.getZSection(); ++z) {
                Coord3D coord = new Coord3D(z, t);
                if (this.coordMap.containsKey(coord)) continue;
                ShapeList shapeList = new ShapeList(coord);
                this.coordMap.put(coord, shapeList);
            }
        }
    }
}

