/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.util.roi.model;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.TreeMap;
import org.openmicroscopy.shoola.util.roi.exception.NoSuchROIException;
import org.openmicroscopy.shoola.util.roi.exception.ROICreationException;
import org.openmicroscopy.shoola.util.roi.figures.ROIFigure;
import org.openmicroscopy.shoola.util.roi.model.ROIShape;
import org.openmicroscopy.shoola.util.roi.model.annotation.AnnotationKey;
import org.openmicroscopy.shoola.util.roi.model.annotation.AnnotationKeys;
import org.openmicroscopy.shoola.util.roi.model.attachment.Attachment;
import org.openmicroscopy.shoola.util.roi.model.attachment.AttachmentKey;
import org.openmicroscopy.shoola.util.roi.model.attachment.AttachmentMap;
import org.openmicroscopy.shoola.util.roi.model.util.Coord3D;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ROI {
    static final int DEFAULTMAPSIZE = 101;
    private long id;
    TreeMap<Coord3D, ROIShape> roiShapes;
    AttachmentMap attachments;
    private HashMap<AnnotationKey, Object> annotations = new HashMap();
    private HashSet<AnnotationKey> forbiddenAnnotations;

    public ROI(long id) {
        this.init(id);
    }

    public void addAttachment(AttachmentKey key, Attachment attachment) {
        this.attachments.addAttachment(key, attachment);
    }

    public Attachment getAttachment(AttachmentKey key) {
        return this.attachments.getAttachment(key);
    }

    public AttachmentMap getAttachmentMap() {
        return this.attachments;
    }

    public ROI(long id, Coord3D coord, ROIShape shape) {
        this.init(id);
        this.roiShapes.put(coord, shape);
    }

    private void init(long id) {
        this.id = id;
        this.roiShapes = new TreeMap(new Coord3D());
    }

    public long getID() {
        return this.id;
    }

    public boolean containsKey(Coord3D coord) {
        return this.roiShapes.containsKey(coord);
    }

    public boolean containsKey(Coord3D start, Coord3D end) {
        for (int t = start.getTimePoint(); t < end.getTimePoint(); ++t) {
            for (int z = start.getZSection(); z < end.getZSection(); ++z) {
                if (this.roiShapes.containsKey(new Coord3D(z, t))) continue;
                return false;
            }
        }
        return true;
    }

    public TreeMap<Coord3D, ROIShape> getShapes() {
        return this.roiShapes;
    }

    public ROIShape getShape(Coord3D coord) throws NoSuchROIException {
        try {
            return this.roiShapes.get(coord);
        }
        catch (Exception e) {
            throw new NoSuchROIException(e);
        }
    }

    public ROIFigure getFigure(Coord3D coord) throws NoSuchROIException {
        return this.getShape(coord).getFigure();
    }

    public void addShape(ROIShape shape) throws ROICreationException {
        if (this.roiShapes.containsKey(shape.getCoord3D())) {
            throw new ROICreationException();
        }
        this.roiShapes.put(shape.getCoord3D(), shape);
    }

    public void deleteShape(Coord3D coord) throws NoSuchROIException {
        try {
            this.roiShapes.remove(coord);
        }
        catch (Exception e) {
            throw new NoSuchROIException(e);
        }
    }

    public void setAnnotation(AnnotationKey key, Object newValue) {
        if (this.forbiddenAnnotations == null || !this.forbiddenAnnotations.contains(key)) {
            Object oldValue = this.annotations.get(key);
            if (!this.annotations.containsKey(key) || oldValue != newValue || oldValue != null && newValue != null && !oldValue.equals(newValue)) {
                this.basicSetAnnotation(key, newValue);
            }
        }
    }

    public void setAnnotationEnabled(AnnotationKey key, boolean b) {
        if (this.forbiddenAnnotations == null) {
            this.forbiddenAnnotations = new HashSet();
        }
        if (b) {
            this.forbiddenAnnotations.remove(key);
        } else {
            this.forbiddenAnnotations.add(key);
        }
    }

    public boolean isAnnotationEnabled(AnnotationKey key) {
        return this.forbiddenAnnotations == null || !this.forbiddenAnnotations.contains(key);
    }

    public void basicSetAnnotations(Map<AnnotationKey, Object> map) {
        for (Map.Entry<AnnotationKey, Object> entry : map.entrySet()) {
            this.basicSetAnnotation(entry.getKey(), entry.getValue());
        }
    }

    public void setAnnotations(Map<AnnotationKey, Object> map) {
        for (Map.Entry<AnnotationKey, Object> entry : map.entrySet()) {
            this.setAnnotation(entry.getKey(), entry.getValue());
        }
    }

    public Map<AnnotationKey, Object> getAnnotation() {
        return new HashMap<AnnotationKey, Object>(this.annotations);
    }

    public void basicSetAnnotation(AnnotationKey key, Object newValue) {
        if (this.forbiddenAnnotations == null || !this.forbiddenAnnotations.contains(key)) {
            this.annotations.put(key, newValue);
        }
    }

    public Object getAnnotation(AnnotationKey key) {
        return this.hasAnnotation(key) ? this.annotations.get(key) : key.getDefaultValue();
    }

    protected AnnotationKey getAnnotationKey(String name) {
        return AnnotationKeys.supportedAnnotationMap.get(name);
    }

    protected void applyAnnotationsTo(ROIShape that) {
        for (Map.Entry<AnnotationKey, Object> entry : this.annotations.entrySet()) {
            that.setAnnotation(entry.getKey(), entry.getValue());
        }
    }

    public void removeAnnotation(AnnotationKey key) {
        if (this.hasAnnotation(key)) {
            Object oldValue = this.getAnnotation(key);
            this.annotations.remove(key);
        }
    }

    public boolean hasAnnotation(AnnotationKey key) {
        return this.annotations.containsKey(key);
    }
}

