/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.util.roi.io.util;

import java.awt.geom.AffineTransform;
import java.io.IOException;
import java.io.StreamTokenizer;
import java.io.StringReader;

public class SVGTransform {
    public static AffineTransform toTransform(String str) throws IOException {
        AffineTransform t = new AffineTransform();
        if (str != null && !str.equals("none")) {
            StreamTokenizer tt = new StreamTokenizer(new StringReader(str));
            tt.resetSyntax();
            tt.wordChars(97, 122);
            tt.wordChars(65, 90);
            tt.wordChars(160, 255);
            tt.whitespaceChars(0, 32);
            tt.whitespaceChars(44, 44);
            tt.parseNumbers();
            while (tt.nextToken() != -1) {
                double mantissa;
                double mantissa2;
                if (tt.ttype != -3) {
                    throw new IOException("Illegal transform " + str);
                }
                String type = tt.sval;
                if (tt.nextToken() != 40) {
                    throw new IOException("'(' not found in transform " + str);
                }
                if (type.equals("matrix")) {
                    double[] m = new double[6];
                    for (int i = 0; i < 6; ++i) {
                        if (tt.nextToken() != -2) {
                            throw new IOException("Matrix value " + i + " not found in transform " + str + " token:" + tt.ttype + " " + tt.sval);
                        }
                        m[i] = tt.nval;
                        if (tt.nextToken() == -3 && (tt.sval.startsWith("E") || tt.sval.startsWith("e"))) {
                            mantissa2 = tt.nval;
                            m[i] = Double.valueOf(m[i] + tt.sval);
                            continue;
                        }
                        tt.pushBack();
                    }
                    t.concatenate(new AffineTransform(m));
                } else if (type.equals("translate")) {
                    double ty;
                    if (tt.nextToken() != -2) {
                        throw new IOException("X-translation value not found in transform " + str);
                    }
                    double tx = tt.nval;
                    if (tt.nextToken() == -3 && (tt.sval.startsWith("E") || tt.sval.startsWith("e"))) {
                        mantissa = tt.nval;
                        tx = Double.valueOf(tx + tt.sval);
                    } else {
                        tt.pushBack();
                    }
                    if (tt.nextToken() == -2) {
                        ty = tt.nval;
                        if (tt.nextToken() == -3 && (tt.sval.startsWith("E") || tt.sval.startsWith("e"))) {
                            mantissa = tt.nval;
                            ty = Double.valueOf(ty + tt.sval);
                        } else {
                            tt.pushBack();
                        }
                    } else {
                        tt.pushBack();
                        ty = 0.0;
                    }
                    t.translate(tx, ty);
                } else if (type.equals("scale")) {
                    double sy;
                    if (tt.nextToken() != -2) {
                        throw new IOException("X-scale value not found in transform " + str);
                    }
                    double sx = tt.nval;
                    if (tt.nextToken() == -3 && (tt.sval.startsWith("E") || tt.sval.startsWith("e"))) {
                        mantissa = tt.nval;
                        sx = Double.valueOf(sx + tt.sval);
                    } else {
                        tt.pushBack();
                    }
                    if (tt.nextToken() == -2) {
                        sy = tt.nval;
                        if (tt.nextToken() == -3 && (tt.sval.startsWith("E") || tt.sval.startsWith("e"))) {
                            mantissa = tt.nval;
                            sy = Double.valueOf(sy + tt.sval);
                        } else {
                            tt.pushBack();
                        }
                    } else {
                        tt.pushBack();
                        sy = sx;
                    }
                    t.scale(sx, sy);
                } else if (type.equals("rotate")) {
                    double cy;
                    double cx;
                    double mantissa3;
                    if (tt.nextToken() != -2) {
                        throw new IOException("Angle value not found in transform " + str);
                    }
                    double angle = tt.nval;
                    if (tt.nextToken() == -3 && (tt.sval.startsWith("E") || tt.sval.startsWith("e"))) {
                        mantissa3 = tt.nval;
                        angle = Double.valueOf(angle + tt.sval);
                    } else {
                        tt.pushBack();
                    }
                    if (tt.nextToken() == -2) {
                        cx = tt.nval;
                        if (tt.nextToken() == -3 && (tt.sval.startsWith("E") || tt.sval.startsWith("e"))) {
                            mantissa3 = tt.nval;
                            cx = Double.valueOf(cx + tt.sval);
                        } else {
                            tt.pushBack();
                        }
                        if (tt.nextToken() != -2) {
                            throw new IOException("Y-center value not found in transform " + str);
                        }
                        cy = tt.nval;
                        if (tt.nextToken() == -3 && (tt.sval.startsWith("E") || tt.sval.startsWith("e"))) {
                            mantissa3 = tt.nval;
                            cy = Double.valueOf(cy + tt.sval);
                        } else {
                            tt.pushBack();
                        }
                    } else {
                        tt.pushBack();
                        cy = 0.0;
                        cx = 0.0;
                    }
                    t.rotate(angle * Math.PI / 180.0, cx * Math.PI / 180.0, cy * Math.PI / 180.0);
                } else if (type.equals("skewX")) {
                    if (tt.nextToken() != -2) {
                        throw new IOException("Skew angle not found in transform " + str);
                    }
                    double angle = tt.nval;
                    if (tt.nextToken() == -3 && (tt.sval.startsWith("E") || tt.sval.startsWith("e"))) {
                        mantissa2 = tt.nval;
                        angle = Double.valueOf(angle + tt.sval);
                    } else {
                        tt.pushBack();
                    }
                    t.concatenate(new AffineTransform(1.0, 0.0, Math.tan(angle * Math.PI / 180.0), 1.0, 0.0, 0.0));
                } else if (type.equals("skewY")) {
                    if (tt.nextToken() != -2) {
                        throw new IOException("Skew angle not found in transform " + str);
                    }
                    double angle = tt.nval;
                    if (tt.nextToken() == -3 && (tt.sval.startsWith("E") || tt.sval.startsWith("e"))) {
                        mantissa2 = tt.nval;
                        angle = Double.valueOf(angle + tt.sval);
                    } else {
                        tt.pushBack();
                    }
                    t.concatenate(new AffineTransform(1.0, Math.tan(angle * Math.PI / 180.0), 0.0, 1.0, 0.0, 0.0));
                } else {
                    throw new IOException("Unknown transform " + type + " in " + str);
                }
                if (tt.nextToken() == 41) continue;
                throw new IOException("')' not found in transform " + str);
            }
        }
        return t;
    }
}

