/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.util.roi.io;

import java.awt.Color;
import java.awt.Font;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.TreeMap;
import net.n3.nanoxml.IXMLElement;
import net.n3.nanoxml.XMLElement;
import net.n3.nanoxml.XMLWriter;
import org.jhotdraw.draw.AttributeKey;
import org.jhotdraw.draw.AttributeKeys;
import org.jhotdraw.draw.TextHolderFigure;
import org.jhotdraw.geom.BezierPath;
import org.jhotdraw.samples.svg.LinearGradient;
import org.jhotdraw.samples.svg.RadialGradient;
import org.jhotdraw.samples.svg.SVGAttributeKeys;
import org.openmicroscopy.shoola.util.roi.ROIComponent;
import org.openmicroscopy.shoola.util.roi.exception.ParsingException;
import org.openmicroscopy.shoola.util.roi.figures.BezierAnnotationFigure;
import org.openmicroscopy.shoola.util.roi.figures.DrawingAttributes;
import org.openmicroscopy.shoola.util.roi.figures.EllipseAnnotationFigure;
import org.openmicroscopy.shoola.util.roi.figures.LineAnnotationFigure;
import org.openmicroscopy.shoola.util.roi.figures.LineConnectionAnnotationFigure;
import org.openmicroscopy.shoola.util.roi.figures.MeasureTextFigure;
import org.openmicroscopy.shoola.util.roi.figures.PointAnnotationFigure;
import org.openmicroscopy.shoola.util.roi.figures.ROIFigure;
import org.openmicroscopy.shoola.util.roi.figures.RectAnnotationFigure;
import org.openmicroscopy.shoola.util.roi.model.ROI;
import org.openmicroscopy.shoola.util.roi.model.ROIShape;
import org.openmicroscopy.shoola.util.roi.model.annotation.AnnotationKey;
import org.openmicroscopy.shoola.util.roi.model.util.Coord3D;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OutputStrategy {
    private static final HashMap<Integer, String> strokeLinejoinMap = new HashMap();
    private static final HashMap<Integer, String> strokeLinecapMap;
    private IXMLElement document;
    private IXMLElement defs;
    private int nextId = 0;
    private HashMap<IXMLElement, String> identifiedElements;

    OutputStrategy() {
    }

    private String getId(IXMLElement element) {
        if (this.identifiedElements.containsKey(element)) {
            return this.identifiedElements.get(element);
        }
        String id = Integer.toString(this.nextId++, 36);
        this.identifiedElements.put(element, id);
        return id;
    }

    public void write(OutputStream out, ROIComponent roiComponent) throws ParsingException {
        this.document = new XMLElement("roiset", "http://www.openmicroscopy.org.uk");
        this.document.setAttribute("version", "1.0");
        this.defs = new XMLElement("defs");
        this.document.addChild(this.defs);
        ROIComponent collection = roiComponent;
        TreeMap<Long, ROI> roiMap = collection.getROIMap();
        Iterator<ROI> iterator = roiMap.values().iterator();
        try {
            while (iterator.hasNext()) {
                this.write(this.document, iterator.next());
            }
            new XMLWriter(out).write(this.document);
        }
        catch (Exception e) {
            throw new ParsingException("Cannot create XML output", e);
        }
    }

    private void write(IXMLElement document, ROI roi) throws ParsingException {
        XMLElement roiElement = new XMLElement("roi");
        document.addChild((IXMLElement)roiElement);
        this.writeROIAnnotations((IXMLElement)roiElement, roi);
        TreeMap<Coord3D, ROIShape> roiShapes = roi.getShapes();
        Iterator<ROIShape> iterator = roiShapes.values().iterator();
        while (iterator.hasNext()) {
            this.writeROIShape(roiElement, iterator.next());
        }
    }

    private void writeROIAnnotations(IXMLElement roiElement, ROI roi) {
        roiElement.setAttribute("id", roi.getID() + "");
        Map<AnnotationKey, Object> annotationMap = roi.getAnnotation();
        for (AnnotationKey key : annotationMap.keySet()) {
            XMLElement annotation = new XMLElement(key.getKey());
            this.addAttributes(annotation, annotationMap.get(key));
        }
    }

    private void writeROIShapeAnnotations(IXMLElement shapeElement, ROIShape shape) {
        Map<AnnotationKey, Object> annotationMap = shape.getAnnotation();
        XMLElement annotationLeaf = new XMLElement("annotation");
        for (AnnotationKey key : annotationMap.keySet()) {
            XMLElement annotation = new XMLElement(key.getKey());
            this.addAttributes(annotation, annotationMap.get(key));
            annotationLeaf.addChild((IXMLElement)annotation);
        }
        shapeElement.addChild((IXMLElement)annotationLeaf);
    }

    private void addAttributes(XMLElement annotation, Object value) {
        if (value instanceof Double || value instanceof Float || value instanceof Integer || value instanceof Long || value instanceof Boolean) {
            if (value instanceof Double) {
                annotation.setAttribute("type", "Double");
            }
            if (value instanceof Float) {
                annotation.setAttribute("type", "Float");
            }
            if (value instanceof Integer) {
                annotation.setAttribute("type", "Integer");
            }
            if (value instanceof Long) {
                annotation.setAttribute("type", "Long");
            }
            if (value instanceof Boolean) {
                annotation.setAttribute("type", "Boolean");
            }
            annotation.setAttribute("value", value + "");
        } else if (value instanceof Color) {
            Color colour = (Color)value;
            annotation.setAttribute("type", "Color");
            annotation.setAttribute("r", colour.getRed() + "");
            annotation.setAttribute("g", colour.getGreen() + "");
            annotation.setAttribute("b", colour.getBlue() + "");
            annotation.setAttribute("a", colour.getAlpha() + "");
        } else if (value instanceof Rectangle2D) {
            Rectangle2D object = (Rectangle2D)value;
            annotation.setAttribute("type", "Rectangle2D");
            annotation.setAttribute("x", object.getX() + "");
            annotation.setAttribute("y", object.getY() + "");
            annotation.setAttribute("width", object.getWidth() + "");
            annotation.setAttribute("height", object.getHeight() + "");
        } else if (value instanceof Ellipse2D) {
            Ellipse2D object = (Ellipse2D)value;
            annotation.setAttribute("type", "Ellipse2D");
            annotation.setAttribute("x", object.getX() + "");
            annotation.setAttribute("y", object.getY() + "");
            annotation.setAttribute("width", object.getWidth() + "");
            annotation.setAttribute("height", object.getHeight() + "");
        } else if (value instanceof String) {
            annotation.setAttribute("type", "String");
            annotation.setAttribute("value", (String)value);
        } else if (value instanceof Point2D) {
            Point2D point = (Point2D)value;
            annotation.setAttribute("type", "Point2D");
            annotation.setAttribute("x", point.getX() + "");
            annotation.setAttribute("y", point.getY() + "");
        } else if (value instanceof Coord3D) {
            Coord3D coord = (Coord3D)value;
            annotation.setAttribute("type", "Coord3D");
            annotation.setAttribute("t", coord.getTimePoint() + "");
            annotation.setAttribute("z", coord.getZSection() + "");
        } else if (value instanceof ArrayList) {
            ArrayList list = (ArrayList)value;
            annotation.setAttribute("type", "ArrayList");
            annotation.setAttribute("size", list.size() + "");
            for (int i = 0; i < list.size(); ++i) {
                XMLElement valueElement = new XMLElement("value");
                Object object = list.get(i);
                this.addAttributes(valueElement, object);
                annotation.addChild((IXMLElement)valueElement);
            }
        }
    }

    private String newLine() {
        return System.getProperty("line.separator");
    }

    private void writeROIShape(XMLElement roiElement, ROIShape shape) throws ParsingException {
        XMLElement shapeElement = new XMLElement("roishape");
        roiElement.addChild((IXMLElement)shapeElement);
        shapeElement.setAttribute("t", shape.getCoord3D().getTimePoint() + "");
        shapeElement.setAttribute("z", shape.getCoord3D().getZSection() + "");
        this.writeROIShapeAnnotations((IXMLElement)shapeElement, shape);
        ROIFigure figure = shape.getFigure();
        figure.calculateMeasurements();
        this.writeFigure(shapeElement, figure);
    }

    private void writeFigure(XMLElement shapeElement, ROIFigure figure) throws ParsingException {
        if (figure instanceof RectAnnotationFigure) {
            this.writeSVGHeader(shapeElement);
            this.writeRectAnnotationFigure(shapeElement, (RectAnnotationFigure)figure);
            this.writeTextFigure(shapeElement, (RectAnnotationFigure)figure);
        } else if (figure instanceof EllipseAnnotationFigure) {
            this.writeSVGHeader(shapeElement);
            this.writeEllipseAnnotationFigure(shapeElement, (EllipseAnnotationFigure)figure);
            this.writeTextFigure(shapeElement, (EllipseAnnotationFigure)figure);
        } else if (figure instanceof PointAnnotationFigure) {
            this.writeSVGHeader(shapeElement);
            this.writePointAnnotationFigure(shapeElement, (PointAnnotationFigure)figure);
            this.writeTextFigure(shapeElement, (PointAnnotationFigure)figure);
        } else if (figure instanceof LineConnectionAnnotationFigure) {
            this.writeSVGHeader(shapeElement);
            this.writeLineConnectionFigure(shapeElement, (LineConnectionAnnotationFigure)figure);
            this.writeTextFigure(shapeElement, (LineConnectionAnnotationFigure)figure);
        } else if (figure instanceof BezierAnnotationFigure) {
            this.writeSVGHeader(shapeElement);
            this.writeBezierAnnotationFigure(shapeElement, (BezierAnnotationFigure)figure);
            this.writeTextFigure(shapeElement, (BezierAnnotationFigure)figure);
        } else if (figure instanceof LineAnnotationFigure) {
            this.writeSVGHeader(shapeElement);
            this.writeLineAnnotationFigure(shapeElement, (LineAnnotationFigure)figure);
            this.writeTextFigure(shapeElement, (LineAnnotationFigure)figure);
        } else if (figure instanceof MeasureTextFigure) {
            this.writeSVGHeader(shapeElement);
            this.writeTextFigure(shapeElement, (MeasureTextFigure)figure);
        }
    }

    private void writeSVGHeader(XMLElement shapeElement) {
        XMLElement svgElement = new XMLElement("svg", "http://www.w3.org/2000/svg");
        svgElement.setAttribute("xmlns:xlink", "http://www.w3.org/1999/xlink");
        svgElement.setAttribute("version", "1.2");
        shapeElement.addChild((IXMLElement)svgElement);
    }

    private void writeTextFigure(XMLElement shapeElement, MeasureTextFigure fig) throws ParsingException {
        this.writeTextFigure(shapeElement, (TextHolderFigure)fig);
    }

    private void writeTextFigure(XMLElement shapeElement, TextHolderFigure fig) throws ParsingException {
        XMLElement textElement = new XMLElement("text");
        IXMLElement svgElement = shapeElement.getFirstChildNamed("svg");
        svgElement.addChild((IXMLElement)textElement);
        textElement.setContent(fig.getText());
        textElement.setAttribute("x", fig.getStartPoint().getX() + "");
        textElement.setAttribute("y", fig.getStartPoint().getY() + "");
        this.writeTransformAttribute((IXMLElement)textElement, fig.getAttributes());
        this.writeFontAttributes((IXMLElement)textElement, fig.getAttributes());
    }

    private void writeLineConnectionFigure(XMLElement shapeElement, LineConnectionAnnotationFigure fig) throws ParsingException {
        IXMLElement svgElement = shapeElement.getFirstChildNamed("svg");
        XMLElement lineConnectionElement = new XMLElement("line");
        svgElement.addChild((IXMLElement)lineConnectionElement);
        ROIFigure startConnection = (ROIFigure)fig.getStartConnector().getOwner();
        ROIFigure endConnection = (ROIFigure)fig.getEndConnector().getOwner();
        lineConnectionElement.setAttribute("from", startConnection.getROI().getID() + "");
        lineConnectionElement.setAttribute("to", endConnection.getROI().getID() + "");
        if (fig.getNodeCount() == 2) {
            lineConnectionElement.setAttribute("x1", fig.getNode((int)0).x[0] + "");
            lineConnectionElement.setAttribute("y1", fig.getNode((int)0).y[0] + "");
            lineConnectionElement.setAttribute("x2", fig.getNode((int)1).x[0] + "");
            lineConnectionElement.setAttribute("y2", fig.getNode((int)1).y[0] + "");
        } else {
            LinkedList<Point2D.Double> points = new LinkedList<Point2D.Double>();
            BezierPath bezier = fig.getBezierPath();
            for (BezierPath.Node node : bezier) {
                points.add(new Point2D.Double(node.x[0], node.y[0]));
            }
            String pointsValues = OutputStrategy.toPoints(points.toArray(new Point2D.Double[points.size()]));
            lineConnectionElement.setAttribute("points", pointsValues);
        }
        this.writeShapeAttributes((IXMLElement)lineConnectionElement, fig.getAttributes());
        this.writeTransformAttribute((IXMLElement)lineConnectionElement, fig.getAttributes());
    }

    private void writeBezierAnnotationFigure(XMLElement shapeElement, BezierAnnotationFigure fig) throws ParsingException {
        IXMLElement svgElement = shapeElement.getFirstChildNamed("svg");
        if (fig.isClosed()) {
            this.writePolygonFigure(svgElement, fig);
        } else {
            this.writePolylineFigure(svgElement, fig);
        }
    }

    private void writePolygonFigure(IXMLElement svgElement, BezierAnnotationFigure fig) throws ParsingException {
        XMLElement bezierElement = new XMLElement("polygon");
        svgElement.addChild((IXMLElement)bezierElement);
        LinkedList<Point2D.Double> points = new LinkedList<Point2D.Double>();
        LinkedList<Point2D.Double> points1 = new LinkedList<Point2D.Double>();
        LinkedList<Point2D.Double> points2 = new LinkedList<Point2D.Double>();
        LinkedList<Integer> maskList = new LinkedList<Integer>();
        BezierPath bezier = fig.getBezierPath();
        for (BezierPath.Node node : bezier) {
            points.add(new Point2D.Double(node.x[0], node.y[0]));
            points1.add(new Point2D.Double(node.x[1], node.y[1]));
            points2.add(new Point2D.Double(node.x[2], node.y[2]));
            maskList.add(new Integer(node.getMask()));
        }
        String pointsValues = OutputStrategy.toPoints(points.toArray(new Point2D.Double[points.size()]));
        String points1Values = OutputStrategy.toPoints(points1.toArray(new Point2D.Double[points1.size()]));
        String points2Values = OutputStrategy.toPoints(points2.toArray(new Point2D.Double[points2.size()]));
        String maskValues = "";
        for (int i = 0; i < maskList.size() - 1; ++i) {
            maskValues = maskValues + maskList.get(i) + ",";
        }
        maskValues = maskValues + maskList.get(maskList.size() - 1) + "";
        bezierElement.setAttribute("points", pointsValues);
        bezierElement.setAttribute("points-c1", points1Values);
        bezierElement.setAttribute("points-c2", points2Values);
        bezierElement.setAttribute("mask", maskValues);
        this.writeShapeAttributes((IXMLElement)bezierElement, fig.getAttributes());
        this.writeTransformAttribute((IXMLElement)bezierElement, fig.getAttributes());
    }

    private void writePolylineFigure(IXMLElement svgElement, BezierAnnotationFigure fig) throws ParsingException {
        XMLElement bezierElement = new XMLElement("polyline");
        svgElement.addChild((IXMLElement)bezierElement);
        LinkedList<Point2D.Double> points = new LinkedList<Point2D.Double>();
        LinkedList<Point2D.Double> points1 = new LinkedList<Point2D.Double>();
        LinkedList<Point2D.Double> points2 = new LinkedList<Point2D.Double>();
        LinkedList<Integer> maskList = new LinkedList<Integer>();
        BezierPath bezier = fig.getBezierPath();
        for (BezierPath.Node node : bezier) {
            points.add(new Point2D.Double(node.x[0], node.y[0]));
            points1.add(new Point2D.Double(node.x[1], node.y[1]));
            points2.add(new Point2D.Double(node.x[2], node.y[2]));
            maskList.add(new Integer(node.getMask()));
        }
        String pointsValues = OutputStrategy.toPoints(points.toArray(new Point2D.Double[points.size()]));
        String points1Values = OutputStrategy.toPoints(points1.toArray(new Point2D.Double[points1.size()]));
        String points2Values = OutputStrategy.toPoints(points2.toArray(new Point2D.Double[points2.size()]));
        String maskValues = "";
        for (int i = 0; i < maskList.size() - 1; ++i) {
            maskValues = maskValues + maskList.get(i) + ",";
        }
        maskValues = maskValues + maskList.get(maskList.size() - 1) + "";
        bezierElement.setAttribute("points", pointsValues);
        bezierElement.setAttribute("points-c1", points1Values);
        bezierElement.setAttribute("points-c2", points2Values);
        bezierElement.setAttribute("mask", maskValues);
        this.writeShapeAttributes((IXMLElement)bezierElement, fig.getAttributes());
        this.writeTransformAttribute((IXMLElement)bezierElement, fig.getAttributes());
    }

    private void writeLineAnnotationFigure(XMLElement shapeElement, LineAnnotationFigure fig) throws ParsingException {
        IXMLElement svgElement = shapeElement.getFirstChildNamed("svg");
        XMLElement lineElement = new XMLElement("line");
        svgElement.addChild((IXMLElement)lineElement);
        if (fig.getNodeCount() == 2) {
            lineElement.setAttribute("x1", fig.getNode((int)0).x[0] + "");
            lineElement.setAttribute("y1", fig.getNode((int)0).y[0] + "");
            lineElement.setAttribute("x2", fig.getNode((int)1).x[0] + "");
            lineElement.setAttribute("y2", fig.getNode((int)1).y[0] + "");
        } else {
            LinkedList<Point2D.Double> points = new LinkedList<Point2D.Double>();
            BezierPath bezier = fig.getBezierPath();
            for (BezierPath.Node node : bezier) {
                points.add(new Point2D.Double(node.x[0], node.y[0]));
            }
            String pointsValues = OutputStrategy.toPoints(points.toArray(new Point2D.Double[points.size()]));
            lineElement.setAttribute("points", pointsValues);
        }
        this.writeShapeAttributes((IXMLElement)lineElement, fig.getAttributes());
        this.writeTransformAttribute((IXMLElement)lineElement, fig.getAttributes());
    }

    private void writeEllipseAnnotationFigure(XMLElement shapeElement, EllipseAnnotationFigure fig) throws ParsingException {
        IXMLElement svgElement = shapeElement.getFirstChildNamed("svg");
        XMLElement ellipseElement = new XMLElement("ellipse");
        svgElement.addChild((IXMLElement)ellipseElement);
        double rx = fig.getWidth() / 2.0;
        double ry = fig.getHeight() / 2.0;
        double cx = fig.getX() + rx;
        double cy = fig.getY() + ry;
        ellipseElement.setAttribute("cx", cx + "");
        ellipseElement.setAttribute("cy", cy + "");
        ellipseElement.setAttribute("rx", rx + "");
        ellipseElement.setAttribute("ry", ry + "");
        this.writeShapeAttributes((IXMLElement)ellipseElement, fig.getAttributes());
        this.writeTransformAttribute((IXMLElement)ellipseElement, fig.getAttributes());
    }

    private void writePointAnnotationFigure(XMLElement shapeElement, PointAnnotationFigure fig) throws ParsingException {
        IXMLElement svgElement = shapeElement.getFirstChildNamed("svg");
        XMLElement ellipseElement = new XMLElement("point");
        svgElement.addChild((IXMLElement)ellipseElement);
        double cx = fig.getCentre().getX();
        double cy = fig.getCentre().getY();
        double rx = fig.getWidth() / 2.0;
        double ry = fig.getHeight() / 2.0;
        ellipseElement.setAttribute("cx", cx + "");
        ellipseElement.setAttribute("cy", cy + "");
        ellipseElement.setAttribute("rx", rx + "");
        ellipseElement.setAttribute("ry", ry + "");
        this.writeShapeAttributes((IXMLElement)ellipseElement, fig.getAttributes());
        this.writeTransformAttribute((IXMLElement)ellipseElement, fig.getAttributes());
    }

    private void writeRectAnnotationFigure(XMLElement shapeElement, RectAnnotationFigure fig) throws ParsingException {
        IXMLElement svgElement = shapeElement.getFirstChildNamed("svg");
        XMLElement rectElement = new XMLElement("rect");
        svgElement.addChild((IXMLElement)rectElement);
        rectElement.setAttribute("x", fig.getX() + "");
        rectElement.setAttribute("y", fig.getY() + "");
        rectElement.setAttribute("width", fig.getWidth() + "");
        rectElement.setAttribute("height", fig.getHeight() + "");
        this.writeShapeAttributes((IXMLElement)rectElement, fig.getAttributes());
        this.writeTransformAttribute((IXMLElement)rectElement, fig.getAttributes());
    }

    protected void writeShapeAttributes(IXMLElement elem, Map<AttributeKey, Object> f) throws ParsingException {
        String id;
        RadialGradient rg;
        IXMLElement gradientElem;
        LinearGradient lg;
        Object gradient = SVGAttributeKeys.FILL_GRADIENT.get(f);
        if (gradient != null) {
            if (gradient instanceof LinearGradient) {
                lg = (LinearGradient)gradient;
                gradientElem = this.createLinearGradient(this.document, lg.getX1(), lg.getY1(), lg.getX2(), lg.getY2(), lg.getStopOffsets(), lg.getStopColors(), lg.isRelativeToFigureBounds());
            } else {
                rg = (RadialGradient)gradient;
                gradientElem = this.createRadialGradient(this.document, rg.getCX(), rg.getCY(), rg.getR(), rg.getStopOffsets(), rg.getStopColors(), rg.isRelativeToFigureBounds());
            }
            id = this.getId(gradientElem);
            gradientElem.setAttribute("id", "xml", id);
            this.defs.addChild(gradientElem);
            this.writeAttribute(elem, "fill", "url(#" + id + ")", "#000");
        } else {
            this.writeAttribute(elem, "fill", OutputStrategy.toColor((Color)AttributeKeys.FILL_COLOR.get(f)), "#000");
        }
        this.writeAttribute(elem, "fill-opacity", (double)((Color)AttributeKeys.FILL_COLOR.get(f)).getAlpha() / 255.0, 1.0);
        if (AttributeKeys.WINDING_RULE.get(f) != AttributeKeys.WindingRule.NON_ZERO) {
            this.writeAttribute(elem, "fill-rule", "evenodd", "nonzero");
        }
        if ((gradient = SVGAttributeKeys.STROKE_GRADIENT.get(f)) != null) {
            if (gradient instanceof LinearGradient) {
                lg = (LinearGradient)gradient;
                gradientElem = this.createLinearGradient(this.document, lg.getX1(), lg.getY1(), lg.getX2(), lg.getY2(), lg.getStopOffsets(), lg.getStopColors(), lg.isRelativeToFigureBounds());
            } else {
                rg = (RadialGradient)gradient;
                gradientElem = this.createRadialGradient(this.document, rg.getCX(), rg.getCY(), rg.getR(), rg.getStopOffsets(), rg.getStopColors(), rg.isRelativeToFigureBounds());
            }
            id = this.getId(gradientElem);
            gradientElem.setAttribute("id", "xml", id);
            this.defs.addChild(gradientElem);
            this.writeAttribute(elem, "stroke", "url(#" + id + ")", "none");
        } else {
            this.writeAttribute(elem, "stroke", OutputStrategy.toColor((Color)AttributeKeys.STROKE_COLOR.get(f)), "none");
        }
        double[] dashes = (double[])AttributeKeys.STROKE_DASHES.get(f);
        if (dashes != null) {
            StringBuilder buf = new StringBuilder();
            for (int i = 0; i < dashes.length; ++i) {
                if (i != 0) {
                    buf.append(',');
                }
                buf.append(OutputStrategy.toNumber(dashes[i]));
            }
            this.writeAttribute(elem, "stroke-dasharray", buf.toString(), null);
        }
        this.writeAttribute(elem, "stroke-dashoffset", (Double)AttributeKeys.STROKE_DASH_PHASE.get(f), 0.0);
        this.writeAttribute(elem, "stroke-linecap", strokeLinecapMap.get(AttributeKeys.STROKE_CAP.get(f)), "butt");
        this.writeAttribute(elem, "stroke-linejoin", strokeLinejoinMap.get(AttributeKeys.STROKE_JOIN.get(f)), "miter");
        this.writeAttribute(elem, "stroke-miterlimit", (Double)AttributeKeys.STROKE_MITER_LIMIT.get(f), 4.0);
        this.writeAttribute(elem, "stroke-opacity", (double)((Color)AttributeKeys.STROKE_COLOR.get(f)).getAlpha() / 255.0, 1.0);
        this.writeAttribute(elem, "stroke-width", (Double)AttributeKeys.STROKE_WIDTH.get(f), 1.0);
        this.writeAttribute(elem, DrawingAttributes.SHOWMEASUREMENT.getKey(), ((Boolean)DrawingAttributes.SHOWMEASUREMENT.get(f)).toString(), "false");
        this.writeAttribute(elem, DrawingAttributes.SHOWTEXT.getKey(), ((Boolean)DrawingAttributes.SHOWTEXT.get(f)).toString(), "false");
    }

    protected void writeTransformAttribute(IXMLElement elem, Map<AttributeKey, Object> a) throws ParsingException {
        AffineTransform t = (AffineTransform)SVGAttributeKeys.TRANSFORM.get(a);
        if (t != null) {
            this.writeAttribute(elem, "transform", OutputStrategy.toTransform(t), "none");
        }
    }

    private void writeFontAttributes(IXMLElement elem, Map<AttributeKey, Object> a) throws ParsingException {
        Object gradient = SVGAttributeKeys.FILL_GRADIENT.get(a);
        if (gradient != null) {
            IXMLElement gradientElem;
            if (gradient instanceof LinearGradient) {
                LinearGradient lg = (LinearGradient)gradient;
                gradientElem = this.createLinearGradient(this.document, lg.getX1(), lg.getY1(), lg.getX2(), lg.getY2(), lg.getStopOffsets(), lg.getStopColors(), lg.isRelativeToFigureBounds());
            } else {
                RadialGradient rg = (RadialGradient)gradient;
                gradientElem = this.createRadialGradient(this.document, rg.getCX(), rg.getCY(), rg.getR(), rg.getStopOffsets(), rg.getStopColors(), rg.isRelativeToFigureBounds());
            }
            String id = this.getId(gradientElem);
            gradientElem.setAttribute("id", "xml", id);
            this.defs.addChild(gradientElem);
            this.writeAttribute(elem, "fill", "url(#" + id + ")", "#000");
        } else {
            this.writeAttribute(elem, "fill", OutputStrategy.toColor((Color)AttributeKeys.TEXT_COLOR.get(a)), "#000");
        }
        this.writeAttribute(elem, "fill-opacity", (double)((Color)AttributeKeys.TEXT_COLOR.get(a)).getAlpha() / 255.0, 1.0);
        this.writeAttribute(elem, "font-family", ((Font)AttributeKeys.FONT_FACE.get(a)).getFamily(), "Dialog");
        this.writeAttribute(elem, "font-size", (Double)AttributeKeys.FONT_SIZE.get(a), 0.0);
        this.writeAttribute(elem, "font-style", (Boolean)AttributeKeys.FONT_ITALIC.get(a) != false ? "italic" : "normal", "normal");
        this.writeAttribute(elem, "font-variant", "normal", "normal");
        this.writeAttribute(elem, "font-weight", (Boolean)AttributeKeys.FONT_BOLD.get(a) != false ? "bold" : "normal", "normal");
    }

    private static String toPath(BezierPath[] paths) {
        StringBuilder buf = new StringBuilder();
        for (int j = 0; j < paths.length; ++j) {
            BezierPath.Node current;
            BezierPath path = paths[j];
            if (path.size() == 0) continue;
            if (path.size() == 1) {
                BezierPath.Node current2 = (BezierPath.Node)path.get(0);
                buf.append("M ");
                buf.append(current2.x[0]);
                buf.append(' ');
                buf.append(current2.y[0]);
                buf.append(" L ");
                buf.append(current2.x[0]);
                buf.append(' ');
                buf.append(current2.y[0] + 1.0);
                continue;
            }
            BezierPath.Node previous = current = (BezierPath.Node)path.get(0);
            buf.append("M ");
            buf.append(current.x[0]);
            buf.append(' ');
            buf.append(current.y[0]);
            int n = path.size();
            for (int i = 1; i < n; ++i) {
                previous = current;
                current = (BezierPath.Node)path.get(i);
                if ((previous.mask & 2) == 0) {
                    if ((current.mask & 1) == 0) {
                        buf.append(" L ");
                        buf.append(current.x[0]);
                        buf.append(' ');
                        buf.append(current.y[0]);
                        continue;
                    }
                    buf.append(" Q ");
                    buf.append(current.x[1]);
                    buf.append(' ');
                    buf.append(current.y[1]);
                    buf.append(' ');
                    buf.append(current.x[0]);
                    buf.append(' ');
                    buf.append(current.y[0]);
                    continue;
                }
                if ((current.mask & 1) == 0) {
                    buf.append(" Q ");
                    buf.append(current.x[2]);
                    buf.append(' ');
                    buf.append(current.y[2]);
                    buf.append(' ');
                    buf.append(current.x[0]);
                    buf.append(' ');
                    buf.append(current.y[0]);
                    continue;
                }
                buf.append(" C ");
                buf.append(previous.x[2]);
                buf.append(' ');
                buf.append(previous.y[2]);
                buf.append(' ');
                buf.append(current.x[1]);
                buf.append(' ');
                buf.append(current.y[1]);
                buf.append(' ');
                buf.append(current.x[0]);
                buf.append(' ');
                buf.append(current.y[0]);
            }
            if (!path.isClosed()) continue;
            if (path.size() > 1) {
                previous = (BezierPath.Node)path.get(path.size() - 1);
                current = (BezierPath.Node)path.get(0);
                if ((previous.mask & 2) == 0) {
                    if ((current.mask & 1) == 0) {
                        buf.append(" L ");
                        buf.append(current.x[0]);
                        buf.append(' ');
                        buf.append(current.y[0]);
                    } else {
                        buf.append(" Q ");
                        buf.append(current.x[1]);
                        buf.append(' ');
                        buf.append(current.y[1]);
                        buf.append(' ');
                        buf.append(current.x[0]);
                        buf.append(' ');
                        buf.append(current.y[0]);
                    }
                } else if ((current.mask & 1) == 0) {
                    buf.append(" Q ");
                    buf.append(previous.x[2]);
                    buf.append(' ');
                    buf.append(previous.y[2]);
                    buf.append(' ');
                    buf.append(current.x[0]);
                    buf.append(' ');
                    buf.append(current.y[0]);
                } else {
                    buf.append(" C ");
                    buf.append(previous.x[2]);
                    buf.append(' ');
                    buf.append(previous.y[2]);
                    buf.append(' ');
                    buf.append(current.x[1]);
                    buf.append(' ');
                    buf.append(current.y[1]);
                    buf.append(' ');
                    buf.append(current.x[0]);
                    buf.append(' ');
                    buf.append(current.y[0]);
                }
            }
            buf.append(" Z");
        }
        return buf.toString();
    }

    protected void writeAttribute(IXMLElement elem, String name, String value, String defaultValue) {
        this.writeAttribute(elem, name, "", value, defaultValue);
    }

    protected void writeAttribute(IXMLElement elem, String name, String namespace, String value, String defaultValue) {
        elem.setAttribute(name, value);
    }

    protected void writeAttribute(IXMLElement elem, String name, Color color, Color defaultColor) {
        this.writeAttribute(elem, name, "http://www.w3.org/2000/svg", OutputStrategy.toColor(color), OutputStrategy.toColor(defaultColor));
    }

    protected void writeAttribute(IXMLElement elem, String name, double value, double defaultValue) {
        this.writeAttribute(elem, name, "http://www.w3.org/2000/svg", value, defaultValue);
    }

    protected void writeAttribute(IXMLElement elem, String name, String namespace, double value, double defaultValue) {
        elem.setAttribute(name, OutputStrategy.toNumber(value));
    }

    private static String toNumber(double number) {
        String str = Double.toString(number);
        if (str.endsWith(".0")) {
            str = str.substring(0, str.length() - 2);
        }
        return str;
    }

    private static String toPoints(Point2D.Double[] points) throws ParsingException {
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < points.length; ++i) {
            if (i != 0) {
                buf.append(", ");
            }
            buf.append(OutputStrategy.toNumber(points[i].x));
            buf.append(',');
            buf.append(OutputStrategy.toNumber(points[i].y));
        }
        return buf.toString();
    }

    private static String toTransform(AffineTransform t) throws ParsingException {
        StringBuilder buf = new StringBuilder();
        switch (t.getType()) {
            case 0: {
                buf.append("none");
                break;
            }
            case 1: {
                buf.append("translate(");
                buf.append(OutputStrategy.toNumber(t.getTranslateX()));
                if (t.getTranslateY() != 0.0) {
                    buf.append(' ');
                    buf.append(OutputStrategy.toNumber(t.getTranslateY()));
                }
                buf.append(')');
                break;
            }
            case 2: {
                buf.append("scale(");
                buf.append(OutputStrategy.toNumber(t.getScaleX()));
                buf.append(')');
                break;
            }
            case 4: 
            case 6: {
                buf.append("scale(");
                buf.append(OutputStrategy.toNumber(t.getScaleX()));
                buf.append(' ');
                buf.append(OutputStrategy.toNumber(t.getScaleY()));
                buf.append(')');
                break;
            }
            default: {
                buf.append("matrix(");
                double[] matrix = new double[6];
                t.getMatrix(matrix);
                for (int i = 0; i < matrix.length; ++i) {
                    if (i != 0) {
                        buf.append(' ');
                    }
                    buf.append(OutputStrategy.toNumber(matrix[i]));
                }
                buf.append(')');
            }
        }
        return buf.toString();
    }

    private static String toColor(Color color) {
        if (color == null) {
            return "none";
        }
        String value = "000000" + Integer.toHexString(color.getRGB());
        value = "#" + value.substring(value.length() - 6);
        if (value.charAt(1) == value.charAt(2) && value.charAt(3) == value.charAt(4) && value.charAt(5) == value.charAt(6)) {
            value = "#" + value.charAt(1) + value.charAt(3) + value.charAt(5);
        }
        return value;
    }

    protected IXMLElement createLinearGradient(IXMLElement doc, double x1, double y1, double x2, double y2, double[] stopOffsets, Color[] stopColors, boolean isRelativeToFigureBounds) throws ParsingException {
        IXMLElement elem = doc.createElement("linearGradient");
        this.writeAttribute(elem, "x1", OutputStrategy.toNumber(x1), "0");
        this.writeAttribute(elem, "y1", OutputStrategy.toNumber(y1), "0");
        this.writeAttribute(elem, "x2", OutputStrategy.toNumber(x2), "1");
        this.writeAttribute(elem, "y2", OutputStrategy.toNumber(y2), "0");
        this.writeAttribute(elem, "gradientUnits", isRelativeToFigureBounds ? "objectBoundingBox" : "useSpaceOnUse", "objectBoundingBox");
        for (int i = 0; i < stopOffsets.length; ++i) {
            XMLElement stop = new XMLElement("stop");
            this.writeAttribute((IXMLElement)stop, "offset", OutputStrategy.toNumber(stopOffsets[i]), null);
            this.writeAttribute((IXMLElement)stop, "stop-color", OutputStrategy.toColor(stopColors[i]), null);
            this.writeAttribute((IXMLElement)stop, "stop-opacity", OutputStrategy.toNumber((double)stopColors[i].getAlpha() / 255.0), "1");
            elem.addChild((IXMLElement)stop);
        }
        return elem;
    }

    protected IXMLElement createRadialGradient(IXMLElement doc, double cx, double cy, double r, double[] stopOffsets, Color[] stopColors, boolean isRelativeToFigureBounds) throws ParsingException {
        IXMLElement elem = doc.createElement("radialGradient");
        this.writeAttribute(elem, "cx", OutputStrategy.toNumber(cx), "0.5");
        this.writeAttribute(elem, "cy", OutputStrategy.toNumber(cy), "0.5");
        this.writeAttribute(elem, "r", OutputStrategy.toNumber(r), "0.5");
        this.writeAttribute(elem, "gradientUnits", isRelativeToFigureBounds ? "objectBoundingBox" : "useSpaceOnUse", "objectBoundingBox");
        for (int i = 0; i < stopOffsets.length; ++i) {
            XMLElement stop = new XMLElement("stop");
            this.writeAttribute((IXMLElement)stop, "offset", OutputStrategy.toNumber(stopOffsets[i]), null);
            this.writeAttribute((IXMLElement)stop, "stop-color", OutputStrategy.toColor(stopColors[i]), null);
            this.writeAttribute((IXMLElement)stop, "stop-opacity", OutputStrategy.toNumber((double)stopColors[i].getAlpha() / 255.0), "1");
            elem.addChild((IXMLElement)stop);
        }
        return elem;
    }

    static {
        strokeLinejoinMap.put(0, "miter");
        strokeLinejoinMap.put(1, "round");
        strokeLinejoinMap.put(2, "bevel");
        strokeLinecapMap = new HashMap();
        strokeLinecapMap.put(0, "butt");
        strokeLinecapMap.put(1, "round");
        strokeLinecapMap.put(2, "square");
    }
}

