/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.util.roi.figures.textutil;

import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.Map;
import javax.swing.undo.UndoableEdit;
import org.jhotdraw.draw.CreationTool;
import org.jhotdraw.draw.DrawingEditor;
import org.jhotdraw.draw.Figure;
import org.jhotdraw.draw.TextHolderFigure;
import org.openmicroscopy.shoola.util.roi.figures.textutil.MeasureFloatingTextField;

public class MeasureTextTool
extends CreationTool
implements ActionListener {
    private MeasureFloatingTextField textField;
    private TextHolderFigure typingTarget;

    public MeasureTextTool(TextHolderFigure prototype) {
        super((Figure)prototype);
    }

    public MeasureTextTool(TextHolderFigure prototype, Map attributes) {
        super((Figure)prototype, attributes);
    }

    public void deactivate(DrawingEditor editor) {
        this.endEdit();
        super.deactivate(editor);
    }

    public void mousePressed(MouseEvent e) {
        TextHolderFigure textHolder = null;
        Figure pressedFigure = this.getDrawing().findFigureInside(this.getView().viewToDrawing(new Point(e.getX(), e.getY())));
        if (pressedFigure instanceof TextHolderFigure && !(textHolder = ((TextHolderFigure)pressedFigure).getLabelFor()).isEditable()) {
            textHolder = null;
        }
        if (textHolder != null) {
            this.beginEdit(textHolder);
            return;
        }
        if (this.typingTarget != null) {
            this.endEdit();
            this.fireToolDone();
        } else {
            super.mousePressed(e);
            textHolder = (TextHolderFigure)this.getCreatedFigure();
            this.beginEdit(textHolder);
        }
    }

    public void mouseDragged(MouseEvent e) {
    }

    protected void beginEdit(TextHolderFigure textHolder) {
        if (this.textField == null) {
            this.textField = new MeasureFloatingTextField();
            this.textField.addActionListener(this);
        }
        if (textHolder != this.typingTarget && this.typingTarget != null) {
            this.endEdit();
        }
        this.textField.createOverlay(this.getView(), textHolder);
        this.textField.setBounds(this.getFieldBounds(textHolder), textHolder.getText());
        this.textField.requestFocus();
        this.typingTarget = textHolder;
    }

    protected Rectangle getFieldBounds(TextHolderFigure figure) {
        Rectangle textBox = this.getView().drawingToView(figure.getBounds());
        int h = (int)Math.min(24.0, textBox.getHeight());
        int y = (int)textBox.getY() + (int)(textBox.getHeight() / 2.0) - h / 2;
        Rectangle box = new Rectangle((int)textBox.getX(), y, (int)textBox.getWidth(), h);
        Insets insets = this.textField.getInsets();
        return new Rectangle(box.x - insets.left, box.y - insets.top, box.width + insets.left + insets.right, box.height + insets.top + insets.bottom);
    }

    public void mouseReleased(MouseEvent evt) {
    }

    protected void endEdit() {
        if (this.typingTarget != null) {
            if (this.textField.getText().length() > 0) {
                this.typingTarget.setText(this.textField.getText());
                if (this.createdFigure != null) {
                    this.getDrawing().fireUndoableEditHappened((UndoableEdit)this.creationEdit);
                    this.createdFigure = null;
                }
            } else if (this.createdFigure != null) {
                this.getDrawing().remove(this.getAddedFigure());
            } else {
                this.typingTarget.setText("");
            }
            this.typingTarget = null;
            this.textField.endOverlay();
        }
    }

    public void actionPerformed(ActionEvent event) {
        this.endEdit();
        this.fireToolDone();
    }
}

