/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.util.roi.figures;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.font.FontRenderContext;
import java.awt.font.TextAttribute;
import java.awt.font.TextLayout;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import org.jhotdraw.draw.AttributeKeys;
import org.jhotdraw.draw.Figure;
import org.jhotdraw.draw.Handle;
import org.jhotdraw.draw.MoveHandle;
import org.jhotdraw.draw.RelativeLocator;
import org.jhotdraw.draw.TextHolderFigure;
import org.jhotdraw.draw.Tool;
import org.jhotdraw.geom.Insets2D;
import org.openmicroscopy.shoola.util.roi.figures.DrawingAttributes;
import org.openmicroscopy.shoola.util.roi.figures.MeasurePointFigure;
import org.openmicroscopy.shoola.util.roi.figures.textutil.MeasureTextTool;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PointAnnotationFigure
extends MeasurePointFigure
implements TextHolderFigure {
    public static final double POINTSIZE = 6.0;
    public static final double FIGURESIZE = 22.0;
    private boolean editable;
    private boolean displayText = true;
    private transient TextLayout textLayout;
    private Rectangle2D.Double textBounds;

    public PointAnnotationFigure() {
        this("Text", 0.0, 0.0, 22.0, 22.0);
    }

    public PointAnnotationFigure(double x, double y, double w, double h) {
        this("Text", x, y, 22.0, 22.0);
    }

    public PointAnnotationFigure(String text) {
        this(text, 0.0, 0.0, 22.0, 22.0);
    }

    public PointAnnotationFigure(String text, double x, double y, double w, double h) {
        super(x, y, 22.0, 22.0);
        this.setText(text);
        this.textLayout = null;
        this.textBounds = null;
        this.editable = true;
    }

    protected void drawStroke(Graphics2D g) {
        Ellipse2D.Double newEllipse = new Ellipse2D.Double(this.ellipse.getCenterX() - 6.0, this.ellipse.getCenterY() - 6.0, 12.0, 12.0);
        g.draw(newEllipse);
        this.drawCrossHairs(g);
    }

    private void drawCrossHairs(Graphics2D g) {
        Ellipse2D.Double newEllipse = new Ellipse2D.Double(this.ellipse.getCenterX() - 6.0, this.ellipse.getCenterY() - 6.0, 12.0, 12.0);
        double cx = Math.floor(newEllipse.getCenterX());
        double cy = Math.floor(newEllipse.getCenterY());
        double x = Math.floor(newEllipse.getX());
        double y = Math.floor(newEllipse.getY());
        double width = 6.0;
        double height = 6.0;
        double loffset = 3.0;
        Line2D.Double lhline = new Line2D.Double(x - loffset * 2.0, cy, cx - loffset, cy);
        Line2D.Double rhline = new Line2D.Double(cx + loffset, cy, cx + width + loffset * 2.0, cy);
        Line2D.Double tvline = new Line2D.Double(cx, y - loffset * 2.0, cx, cy - loffset);
        Line2D.Double bvline = new Line2D.Double(cx, cy + loffset, cx, cy + height + loffset * 2.0);
        g.draw(lhline);
        g.draw(rhline);
        g.draw(tvline);
        g.draw(bvline);
    }

    protected void drawFill(Graphics2D g) {
        Ellipse2D.Double newEllipse = new Ellipse2D.Double(this.ellipse.getCenterX() - 6.0, this.ellipse.getCenterY() - 6.0, 12.0, 12.0);
        g.fill(newEllipse);
        this.drawText(g);
    }

    protected void drawText(Graphics2D g) {
        if (((Boolean)DrawingAttributes.SHOWTEXT.get((Figure)this)).booleanValue() && this.displayText && (this.getText() != null || this.isEditable())) {
            TextLayout layout = this.getTextLayout();
            this.setTextBounds(g);
            layout.draw(g, (float)this.textBounds.x, (float)this.textBounds.y);
        }
    }

    protected void setTextBounds(Graphics2D g) {
        this.textBounds = new Rectangle2D.Double(this.getTextX(g), this.getTextY(g), this.getTextWidth(g), this.getTextHeight(g));
    }

    protected double getTextX(Graphics2D g) {
        return this.getBounds().getX() + this.getBounds().getWidth() / 2.0 - this.getTextWidth(g) / 2.0;
    }

    protected double getTextY(Graphics2D g) {
        return this.getBounds().getY() + this.getBounds().getHeight() / 2.0 + this.getTextHeight(g) / 2.0;
    }

    protected double getTextWidth(Graphics2D g) {
        return g.getFontMetrics((Font)AttributeKeys.FONT_FACE.get((Figure)this)).stringWidth(this.getText().trim());
    }

    protected double getTextHeight(Graphics2D g) {
        return g.getFontMetrics((Font)AttributeKeys.FONT_FACE.get((Figure)this)).getAscent();
    }

    protected Rectangle2D.Double getTextBounds() {
        if (this.textBounds == null) {
            return new Rectangle2D.Double(0.0, 0.0, 0.0, 0.0);
        }
        return this.textBounds;
    }

    public Collection<Handle> createHandles(int detailLevel) {
        LinkedList<Handle> handles = new LinkedList<Handle>();
        if (detailLevel == 0) {
            handles.add((Handle)new MoveHandle((Figure)this, RelativeLocator.northWest()));
            handles.add((Handle)new MoveHandle((Figure)this, RelativeLocator.northEast()));
            handles.add((Handle)new MoveHandle((Figure)this, RelativeLocator.southWest()));
            handles.add((Handle)new MoveHandle((Figure)this, RelativeLocator.southEast()));
        }
        return handles;
    }

    public void invalidate() {
        super.invalidate();
        this.textLayout = null;
    }

    protected void validate() {
        super.validate();
        this.textLayout = null;
    }

    @Override
    public Rectangle2D.Double getDrawingArea() {
        Rectangle2D.Double r = super.getDrawingArea();
        r.add(this.getTextBounds());
        return r;
    }

    public Tool getTool(Point2D.Double p) {
        if (this.isEditable() && this.contains(p)) {
            this.displayText = false;
            this.invalidate();
            return new MeasureTextTool(this);
        }
        return null;
    }

    private TextLayout getTextLayout() {
        if (this.textLayout == null) {
            String text = this.getText();
            if (text == null || text.length() == 0) {
                text = " ";
            }
            FontRenderContext frc = this.getFontRenderContext();
            HashMap<TextAttribute, Serializable> textAttributes = new HashMap<TextAttribute, Serializable>();
            textAttributes.put(TextAttribute.FONT, this.getFont());
            if (((Boolean)AttributeKeys.FONT_UNDERLINED.get((Figure)this)).booleanValue()) {
                textAttributes.put(TextAttribute.UNDERLINE, TextAttribute.UNDERLINE_LOW_ONE_PIXEL);
            }
            this.textLayout = new TextLayout(text, textAttributes, frc);
        }
        return this.textLayout;
    }

    public String getText() {
        return (String)this.getAttribute(AttributeKeys.TEXT);
    }

    public void setText(String newText) {
        this.displayText = true;
        this.setAttribute(AttributeKeys.TEXT, newText);
    }

    public int getTextColumns() {
        return this.getText() == null ? 4 : Math.max(this.getText().length(), 4);
    }

    public int getTabSize() {
        return 8;
    }

    public TextHolderFigure getLabelFor() {
        return this;
    }

    public Insets2D.Double getInsets() {
        return new Insets2D.Double();
    }

    public Font getFont() {
        return AttributeKeys.getFont((Figure)this);
    }

    public Color getTextColor() {
        return (Color)AttributeKeys.TEXT_COLOR.get((Figure)this);
    }

    public Color getFillColor() {
        return (Color)AttributeKeys.FILL_COLOR.get((Figure)this);
    }

    public void setFontSize(float size) {
    }

    public float getFontSize() {
        return ((Double)AttributeKeys.FONT_SIZE.get((Figure)this)).floatValue();
    }

    public boolean isEditable() {
        return this.editable;
    }

    public void setEditable(boolean b) {
        this.editable = b;
    }
}

