/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.util.roi.figures;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.text.DecimalFormat;
import org.jhotdraw.draw.AttributeKeys;
import org.jhotdraw.draw.EllipseFigure;
import org.jhotdraw.draw.Figure;
import org.openmicroscopy.shoola.util.math.geom2D.PlanePoint2D;
import org.openmicroscopy.shoola.util.roi.figures.DrawingAttributes;
import org.openmicroscopy.shoola.util.roi.figures.ROIFigure;
import org.openmicroscopy.shoola.util.roi.model.ROI;
import org.openmicroscopy.shoola.util.roi.model.ROIShape;
import org.openmicroscopy.shoola.util.roi.model.annotation.AnnotationKeys;
import org.openmicroscopy.shoola.util.roi.model.util.MeasurementUnits;

public class MeasurePointFigure
extends EllipseFigure
implements ROIFigure {
    private Rectangle2D bounds;
    private ROI roi;
    private ROIShape shape;
    private MeasurementUnits units;

    public MeasurePointFigure(double x, double y, double width, double height) {
        super(x, y, width, height);
        this.setAttributeEnabled(AttributeKeys.TEXT_COLOR, true);
        this.shape = null;
        this.roi = null;
    }

    public double getMeasurementX() {
        if (this.units.isInMicrons()) {
            return this.getX() * this.units.getMicronsPixelX();
        }
        return this.getX();
    }

    public Point2D getMeasurementCentre() {
        if (this.units.isInMicrons()) {
            return new Point2D.Double(this.getCentre().getX() * this.units.getMicronsPixelX(), this.getCentre().getY() * this.units.getMicronsPixelY());
        }
        return this.getCentre();
    }

    public double getMeasurementY() {
        if (this.units.isInMicrons()) {
            return this.getY() * this.units.getMicronsPixelY();
        }
        return this.getY();
    }

    public double getMeasurementWidth() {
        if (this.units.isInMicrons()) {
            return this.getWidth() * this.units.getMicronsPixelX();
        }
        return this.getWidth();
    }

    public double getMeasurementHeight() {
        if (this.units.isInMicrons()) {
            return this.getHeight() * this.units.getMicronsPixelY();
        }
        return this.getHeight();
    }

    public double getX() {
        return this.ellipse.getX();
    }

    public double getY() {
        return this.ellipse.getY();
    }

    public double getWidth() {
        return this.ellipse.getWidth();
    }

    public double getHeight() {
        return this.ellipse.getHeight();
    }

    public void draw(Graphics2D g) {
        super.draw(g);
        if (((Boolean)DrawingAttributes.SHOWMEASUREMENT.get((Figure)this)).booleanValue()) {
            DecimalFormat formatter = new DecimalFormat("###.#");
            String pointCentre = "(" + formatter.format(this.getMeasurementCentre().getX()) + "," + formatter.format(this.getMeasurementCentre().getY()) + ")";
            double sz = (Double)this.getAttribute(AttributeKeys.FONT_SIZE);
            g.setFont(new Font("Arial", 0, (int)sz));
            this.bounds = g.getFontMetrics().getStringBounds(pointCentre, g);
            this.bounds = new Rectangle2D.Double(this.getBounds().getCenterX() - this.bounds.getWidth() / 2.0, this.getBounds().getCenterY() + this.bounds.getHeight() / 2.0, this.bounds.getWidth(), this.bounds.getHeight());
            g.setColor((Color)DrawingAttributes.MEASUREMENTTEXT_COLOUR.get((Figure)this));
            g.drawString(pointCentre, (int)this.bounds.getX(), (int)this.bounds.getY());
        }
    }

    public Rectangle2D.Double getDrawingArea() {
        Rectangle2D.Double newBounds = super.getDrawingArea();
        if (this.bounds != null) {
            double diff;
            if (newBounds.getX() > this.bounds.getX()) {
                diff = newBounds.x - this.bounds.getX();
                newBounds.x = this.bounds.getX();
                newBounds.width += diff;
            }
            if (newBounds.getY() > this.bounds.getY()) {
                diff = newBounds.y - this.bounds.getY();
                newBounds.y = this.bounds.getY();
                newBounds.height += diff;
            }
            if (this.bounds.getX() + this.bounds.getWidth() > newBounds.getX() + newBounds.getWidth()) {
                diff = this.bounds.getX() + this.bounds.getWidth() - newBounds.getX() + newBounds.getWidth();
                newBounds.width += diff;
            }
            if (this.bounds.getY() + this.bounds.getHeight() > newBounds.getY() + newBounds.getHeight()) {
                diff = this.bounds.getY() + this.bounds.getHeight() - newBounds.getY() + newBounds.getHeight();
                newBounds.height += diff;
            }
        }
        return newBounds;
    }

    public String addUnits(String str) {
        if (this.shape == null) {
            return str;
        }
        if (this.units.isInMicrons()) {
            return str + "\u00b5m" + "\u00b2";
        }
        return str + "px" + "\u00b2";
    }

    public Point2D getCentre() {
        return new Point2D.Double(Math.round(this.ellipse.getCenterX()), Math.round(this.ellipse.getCenterY()));
    }

    public ROI getROI() {
        return this.roi;
    }

    public ROIShape getROIShape() {
        return this.shape;
    }

    public void setROI(ROI roi) {
        this.roi = roi;
    }

    public void setROIShape(ROIShape shape) {
        this.shape = shape;
    }

    public void calculateMeasurements() {
        if (this.shape == null) {
            return;
        }
        AnnotationKeys.CENTREX.set(this.shape, (Double)this.getMeasurementCentre().getX());
        AnnotationKeys.CENTREY.set(this.shape, (Double)this.getMeasurementCentre().getY());
    }

    public String getType() {
        return "Point";
    }

    public void setMeasurementUnits(MeasurementUnits units) {
        this.units = units;
    }

    public PlanePoint2D[] getPoints() {
        PlanePoint2D[] points = new PlanePoint2D[]{new PlanePoint2D(this.getX(), this.getY())};
        return points;
    }
}

