/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.util.roi.figures;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import org.jhotdraw.draw.AttributeKeys;
import org.jhotdraw.draw.Figure;
import org.jhotdraw.draw.LineFigure;
import org.openmicroscopy.shoola.util.math.geom2D.PlanePoint2D;
import org.openmicroscopy.shoola.util.roi.figures.DrawingAttributes;
import org.openmicroscopy.shoola.util.roi.figures.ROIFigure;
import org.openmicroscopy.shoola.util.roi.model.ROI;
import org.openmicroscopy.shoola.util.roi.model.ROIShape;
import org.openmicroscopy.shoola.util.roi.model.annotation.AnnotationKeys;
import org.openmicroscopy.shoola.util.roi.model.util.MeasurementUnits;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MeasureLineFigure
extends LineFigure
implements ROIFigure {
    private ArrayList<Rectangle2D> boundsArray = new ArrayList();
    private ArrayList<Double> lengthArray = new ArrayList();
    private ArrayList<Double> angleArray = new ArrayList();
    private ArrayList<Double> pointArrayX = new ArrayList();
    private ArrayList<Double> pointArrayY = new ArrayList();
    private ROI roi = null;
    private ROIShape shape = null;
    private MeasurementUnits units;

    private Point2D.Double getPt(int i) {
        if (this.units.isInMicrons()) {
            Point2D.Double pt = this.getPoint(i);
            return new Point2D.Double(pt.getX() * this.units.getMicronsPixelX(), pt.getY() * this.units.getMicronsPixelY());
        }
        return this.getPoint(i);
    }

    public void draw(Graphics2D g) {
        super.draw(g);
        this.boundsArray.clear();
        this.lengthArray.clear();
        this.angleArray.clear();
        if (((Boolean)DrawingAttributes.SHOWMEASUREMENT.get((Figure)this)).booleanValue()) {
            double sz;
            int x;
            Rectangle2D.Double bounds;
            Point2D.Double lengthPoint;
            if (this.getPointCount() == 2) {
                DecimalFormat formatter = new DecimalFormat("###.#");
                double angle = this.getAngle(0, 1);
                if (angle > 90.0) {
                    angle = Math.abs(angle - 180.0);
                }
                this.angleArray.add(angle);
                String lineAngle = formatter.format(angle);
                lineAngle = this.addDegrees(lineAngle);
                double sz2 = (Double)this.getAttribute(AttributeKeys.FONT_SIZE);
                g.setFont(new Font("Arial", 0, (int)sz2));
                Rectangle2D rect = g.getFontMetrics().getStringBounds(lineAngle, g);
                lengthPoint = this.getLengthPosition(0, 1);
                bounds = new Rectangle2D.Double(lengthPoint.x, lengthPoint.y + rect.getHeight() * 2.0, rect.getWidth(), rect.getHeight());
                g.setColor((Color)DrawingAttributes.MEASUREMENTTEXT_COLOUR.get((Figure)this));
                g.drawString(lineAngle, (int)((RectangularShape)bounds).getX(), (int)((RectangularShape)bounds).getY());
                this.boundsArray.add(bounds);
            }
            for (x = 1; x < this.getPointCount() - 1; ++x) {
                DecimalFormat formatter = new DecimalFormat("###.#");
                double angle = this.getAngle(x - 1, x, x + 1);
                this.angleArray.add(angle);
                String lineAngle = formatter.format(angle);
                lineAngle = this.addDegrees(lineAngle);
                sz = (Double)this.getAttribute(AttributeKeys.FONT_SIZE);
                g.setFont(new Font("Arial", 0, (int)sz));
                Rectangle2D rect = g.getFontMetrics().getStringBounds(lineAngle, g);
                bounds = new Rectangle2D.Double(this.getPoint((int)x).x, this.getPoint((int)x).y, rect.getWidth(), rect.getHeight());
                g.setColor((Color)DrawingAttributes.MEASUREMENTTEXT_COLOUR.get((Figure)this));
                g.drawString(lineAngle, (int)((RectangularShape)bounds).getX(), (int)((RectangularShape)bounds).getY());
                this.boundsArray.add(bounds);
            }
            for (x = 1; x < this.getPointCount(); ++x) {
                DecimalFormat formatter = new DecimalFormat("###.#");
                double length = this.getLength(x - 1, x);
                this.lengthArray.add(length);
                String lineLength = formatter.format(length);
                lineLength = this.addUnits(lineLength);
                sz = (Double)this.getAttribute(AttributeKeys.FONT_SIZE);
                g.setFont(new Font("Arial", 0, (int)sz));
                lengthPoint = this.getLengthPosition(x - 1, x);
                Rectangle2D rect = g.getFontMetrics().getStringBounds(lineLength, g);
                Rectangle2D.Double bounds2 = new Rectangle2D.Double(lengthPoint.x - 15.0, lengthPoint.y - 15.0, rect.getWidth() + 30.0, rect.getHeight() + 30.0);
                g.setColor((Color)DrawingAttributes.MEASUREMENTTEXT_COLOUR.get((Figure)this));
                g.drawString(lineLength, (int)lengthPoint.x, (int)lengthPoint.y);
                this.boundsArray.add(bounds2);
            }
        }
    }

    public ArrayList<Double> getLengthArray() {
        return this.lengthArray;
    }

    public ArrayList<Double> getAngleArray() {
        return this.angleArray;
    }

    public String addDegrees(String str) {
        return str + "\u00b0";
    }

    public String addUnits(String str) {
        if (this.shape == null) {
            return str;
        }
        if (this.units.isInMicrons()) {
            return str + "\u00b5m";
        }
        return str + "px";
    }

    public Rectangle2D.Double getDrawingArea() {
        Rectangle2D.Double newBounds = super.getDrawingArea();
        if (this.boundsArray != null) {
            for (int i = 0; i < this.boundsArray.size(); ++i) {
                double diff;
                Rectangle2D bounds = this.boundsArray.get(i);
                if (newBounds.getX() > bounds.getX()) {
                    diff = newBounds.x - bounds.getX();
                    newBounds.x = bounds.getX();
                    newBounds.width += diff;
                }
                if (newBounds.getY() > bounds.getY()) {
                    diff = newBounds.y - bounds.getY();
                    newBounds.y = bounds.getY();
                    newBounds.height += diff;
                }
                if (bounds.getX() + bounds.getWidth() > newBounds.getX() + newBounds.getWidth()) {
                    diff = bounds.getX() + bounds.getWidth() - newBounds.getX() + newBounds.getWidth();
                    newBounds.width += diff;
                }
                if (!(bounds.getY() + bounds.getHeight() > newBounds.getY() + newBounds.getHeight())) continue;
                diff = bounds.getY() + bounds.getHeight() - newBounds.getY() + newBounds.getHeight();
                newBounds.height += diff;
            }
        }
        return newBounds;
    }

    public Point2D.Double getLengthPosition(int i, int j) {
        Point2D.Double p0 = this.getPoint(i);
        Point2D.Double p1 = this.getPoint(j);
        double lx = (p0.x - p1.x) / 2.0;
        double ly = (p0.y - p1.y) / 2.0;
        double x = p0.x - lx;
        double y = p0.y - ly;
        return new Point2D.Double(x, y);
    }

    public double getLength(int i, int j) {
        Point2D.Double pt1 = this.getPt(i);
        Point2D.Double pt2 = this.getPt(j);
        return pt1.distance(pt2);
    }

    public double getAngle(int i, int j, int k) {
        Point2D.Double p0 = this.getPt(i);
        Point2D.Double p1 = this.getPt(j);
        Point2D.Double p2 = this.getPt(k);
        Point2D.Double v0 = new Point2D.Double(((Point2D)p0).getX() - ((Point2D)p1).getX(), ((Point2D)p0).getY() - ((Point2D)p1).getY());
        Point2D.Double v1 = new Point2D.Double(((Point2D)p2).getX() - ((Point2D)p1).getX(), ((Point2D)p2).getY() - ((Point2D)p1).getY());
        return Math.toDegrees(Math.acos(this.dotProd(v0, v1)));
    }

    public double getAngle(int i, int j) {
        Point2D.Double p0 = this.getPt(i);
        Point2D.Double p1 = this.getPt(j);
        Point2D.Double v0 = new Point2D.Double(((Point2D)p0).getX() - ((Point2D)p1).getX(), ((Point2D)p0).getY() - ((Point2D)p1).getY());
        Point2D.Double v1 = new Point2D.Double(1.0, 0.0);
        return Math.toDegrees(Math.acos(this.dotProd(v0, v1)));
    }

    public double dotProd(Point2D p0, Point2D p1) {
        double adotb = p0.getX() * p1.getX() + p0.getY() * p1.getY();
        double normab = Math.sqrt(p0.getX() * p0.getX() + p0.getY() * p0.getY()) * Math.sqrt(p1.getX() * p1.getX() + p1.getY() * p1.getY());
        return adotb / normab;
    }

    @Override
    public ROI getROI() {
        return this.roi;
    }

    @Override
    public ROIShape getROIShape() {
        return this.shape;
    }

    @Override
    public void setROI(ROI roi) {
        this.roi = roi;
    }

    @Override
    public void setROIShape(ROIShape shape) {
        this.shape = shape;
    }

    @Override
    public void calculateMeasurements() {
        if (this.shape == null) {
            return;
        }
        this.pointArrayX.clear();
        this.pointArrayY.clear();
        this.lengthArray.clear();
        this.angleArray.clear();
        for (int i = 0; i < this.getPointCount(); ++i) {
            Point2D.Double pt = this.getPt(i);
            this.pointArrayX.add(pt.getX());
            this.pointArrayY.add(pt.getY());
        }
        if (this.getPointCount() == 2) {
            double angle = this.getAngle(0, 1);
            if (angle > 90.0) {
                angle = Math.abs(angle - 180.0);
            }
            this.angleArray.add(angle);
            AnnotationKeys.ANGLE.set(this.shape, this.angleArray);
            this.lengthArray.add(this.getLength(0, 1));
            AnnotationKeys.LENGTH.set(this.shape, this.lengthArray);
        } else {
            int x;
            for (x = 1; x < this.getPointCount() - 1; ++x) {
                this.angleArray.add(this.getAngle(x - 1, x, x + 1));
            }
            for (x = 1; x < this.getPointCount(); ++x) {
                this.lengthArray.add(this.getLength(x - 1, x));
            }
            AnnotationKeys.ANGLE.set(this.shape, this.angleArray);
            AnnotationKeys.LENGTH.set(this.shape, this.lengthArray);
        }
        AnnotationKeys.STARTPOINTX.set(this.shape, (Double)this.getPt(0).getX());
        AnnotationKeys.STARTPOINTY.set(this.shape, (Double)this.getPt(0).getY());
        AnnotationKeys.ENDPOINTX.set(this.shape, (Double)this.getPt(this.getPointCount() - 1).getX());
        AnnotationKeys.ENDPOINTY.set(this.shape, (Double)this.getPt(this.getPointCount() - 1).getY());
        AnnotationKeys.POINTARRAYX.set(this.shape, this.pointArrayX);
        AnnotationKeys.POINTARRAYY.set(this.shape, this.pointArrayY);
    }

    @Override
    public String getType() {
        return "Line";
    }

    @Override
    public void setMeasurementUnits(MeasurementUnits units) {
        this.units = units;
    }

    @Override
    public PlanePoint2D[] getPoints() {
        Rectangle r = this.path.getBounds();
        ArrayList<PlanePoint2D> vector = new ArrayList<PlanePoint2D>();
        for (int i = 0; i < this.getNodeCount() - 1; ++i) {
            Point2D.Double pt1 = this.getPoint(i);
            Point2D.Double pt2 = this.getPoint(i + 1);
            Line2D.Double line = new Line2D.Double(pt1, pt2);
            this.iterateLine(line, vector);
        }
        return vector.toArray(new PlanePoint2D[vector.size()]);
    }

    private void iterateLine(Line2D line, ArrayList<PlanePoint2D> vector) {
        Point2D start = line.getP1();
        Point2D end = line.getP2();
        Point2D.Double m = new Point2D.Double(end.getX() - start.getX(), end.getY() - start.getY());
        double lengthM = Math.sqrt(((Point2D)m).getX() * ((Point2D)m).getX() + ((Point2D)m).getY() * ((Point2D)m).getY());
        Point2D.Double mNorm = new Point2D.Double(((Point2D)m).getX() / lengthM, ((Point2D)m).getY() / lengthM);
        LinkedHashMap<Point2D.Double, Boolean> map = new LinkedHashMap<Point2D.Double, Boolean>();
        for (double i = 0.0; i < lengthM; i += 0.1) {
            Point2D.Double pt = new Point2D.Double(start.getX() + i * ((Point2D)mNorm).getX(), start.getY() + i * ((Point2D)mNorm).getY());
            Point2D.Double quantisedPoint = new Point2D.Double(Math.floor(((Point2D)pt).getX()), Math.floor(((Point2D)pt).getY()));
            if (map.containsKey(quantisedPoint)) continue;
            map.put(quantisedPoint, new Boolean(true));
        }
        for (Point2D p : map.keySet()) {
            vector.add(new PlanePoint2D(p.getX(), p.getY()));
        }
    }
}

