/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.util.roi.figures;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.text.DecimalFormat;
import java.util.ArrayList;
import org.jhotdraw.draw.AttributeKeys;
import org.jhotdraw.draw.EllipseFigure;
import org.jhotdraw.draw.Figure;
import org.openmicroscopy.shoola.util.math.geom2D.PlanePoint2D;
import org.openmicroscopy.shoola.util.roi.figures.DrawingAttributes;
import org.openmicroscopy.shoola.util.roi.figures.ROIFigure;
import org.openmicroscopy.shoola.util.roi.model.ROI;
import org.openmicroscopy.shoola.util.roi.model.ROIShape;
import org.openmicroscopy.shoola.util.roi.model.annotation.AnnotationKeys;
import org.openmicroscopy.shoola.util.roi.model.util.MeasurementUnits;

public class MeasureEllipseFigure
extends EllipseFigure
implements ROIFigure {
    private Rectangle2D bounds;
    private ROI roi;
    private ROIShape shape;
    private MeasurementUnits units;

    public MeasureEllipseFigure() {
        this(0.0, 0.0, 0.0, 0.0);
    }

    public MeasureEllipseFigure(double x, double y, double width, double height) {
        super(x, y, width, height);
        this.setAttributeEnabled(AttributeKeys.TEXT_COLOR, true);
        this.shape = null;
        this.roi = null;
    }

    public double getMeasurementX() {
        if (this.units.isInMicrons()) {
            return this.getX() * this.units.getMicronsPixelX();
        }
        return this.getX();
    }

    public double getMeasurementY() {
        if (this.units.isInMicrons()) {
            return this.getY() * this.units.getMicronsPixelY();
        }
        return this.getY();
    }

    public double getMeasurementWidth() {
        if (this.units.isInMicrons()) {
            return this.getWidth() * this.units.getMicronsPixelX();
        }
        return this.getWidth();
    }

    public double getMeasurementHeight() {
        if (this.units.isInMicrons()) {
            return this.getHeight() * this.units.getMicronsPixelY();
        }
        return this.getHeight();
    }

    public Point2D getMeasurementCentre() {
        if (this.units.isInMicrons()) {
            return new Point2D.Double(this.getCentre().getX() * this.units.getMicronsPixelX(), this.getCentre().getY() * this.units.getMicronsPixelY());
        }
        return this.getCentre();
    }

    public double getX() {
        return this.ellipse.getX();
    }

    public double getY() {
        return this.ellipse.getY();
    }

    public double getWidth() {
        return this.ellipse.getWidth();
    }

    public double getHeight() {
        return this.ellipse.getHeight();
    }

    public void draw(Graphics2D g) {
        super.draw(g);
        if (((Boolean)DrawingAttributes.SHOWMEASUREMENT.get((Figure)this)).booleanValue()) {
            DecimalFormat formatter = new DecimalFormat("###.#");
            String ellipseArea = formatter.format(this.getArea());
            ellipseArea = this.addUnits(ellipseArea);
            double sz = (Double)this.getAttribute(AttributeKeys.FONT_SIZE);
            g.setFont(new Font("Arial", 0, (int)sz));
            this.bounds = g.getFontMetrics().getStringBounds(ellipseArea, g);
            this.bounds = new Rectangle2D.Double(this.getBounds().getCenterX() - this.bounds.getWidth() / 2.0, this.getBounds().getCenterY() + this.bounds.getHeight() / 2.0, this.bounds.getWidth(), this.bounds.getHeight());
            g.setColor((Color)DrawingAttributes.MEASUREMENTTEXT_COLOUR.get((Figure)this));
            g.drawString(ellipseArea, (int)this.bounds.getX(), (int)this.bounds.getY());
        }
    }

    public Rectangle2D.Double getDrawingArea() {
        Rectangle2D.Double newBounds = super.getDrawingArea();
        if (this.bounds != null) {
            double diff;
            if (newBounds.getX() > this.bounds.getX()) {
                diff = newBounds.x - this.bounds.getX();
                newBounds.x = this.bounds.getX();
                newBounds.width += diff;
            }
            if (newBounds.getY() > this.bounds.getY()) {
                diff = newBounds.y - this.bounds.getY();
                newBounds.y = this.bounds.getY();
                newBounds.height += diff;
            }
            if (this.bounds.getX() + this.bounds.getWidth() > newBounds.getX() + newBounds.getWidth()) {
                diff = this.bounds.getX() + this.bounds.getWidth() - newBounds.getX() + newBounds.getWidth();
                newBounds.width += diff;
            }
            if (this.bounds.getY() + this.bounds.getHeight() > newBounds.getY() + newBounds.getHeight()) {
                diff = this.bounds.getY() + this.bounds.getHeight() - newBounds.getY() + newBounds.getHeight();
                newBounds.height += diff;
            }
        }
        return newBounds;
    }

    public String addUnits(String str) {
        if (this.shape == null) {
            return str;
        }
        if (this.units.isInMicrons()) {
            return str + "\u00b5m" + "\u00b2";
        }
        return str + "px" + "\u00b2";
    }

    public double getArea() {
        return this.getMeasurementHeight() / 2.0 * (this.getMeasurementWidth() / 2.0) * Math.PI;
    }

    public double getPerimeter() {
        if (this.getMeasurementWidth() == this.getMeasurementHeight()) {
            return this.getMeasurementWidth() * 2.0 * Math.PI;
        }
        double a = Math.max(this.getMeasurementWidth(), this.getMeasurementHeight());
        double b = Math.min(this.getMeasurementWidth(), this.getMeasurementHeight());
        return Math.PI * (3.0 * a + 3.0 * b - Math.sqrt((a + 3.0 * b) * (b + 3.0 * a)));
    }

    public Point2D getCentre() {
        return new Point2D.Double(Math.round(this.ellipse.getCenterX()), Math.round(this.ellipse.getCenterY()));
    }

    public ROI getROI() {
        return this.roi;
    }

    public ROIShape getROIShape() {
        return this.shape;
    }

    public void setROI(ROI roi) {
        this.roi = roi;
    }

    public void setROIShape(ROIShape shape) {
        this.shape = shape;
    }

    public void calculateMeasurements() {
        if (this.shape == null) {
            return;
        }
        AnnotationKeys.AREA.set(this.shape, (Double)this.getArea());
        AnnotationKeys.WIDTH.set(this.shape, (Double)this.getMeasurementWidth());
        AnnotationKeys.HEIGHT.set(this.shape, (Double)this.getMeasurementHeight());
        AnnotationKeys.PERIMETER.set(this.shape, (Double)this.getPerimeter());
        AnnotationKeys.CENTREX.set(this.shape, (Double)this.getMeasurementCentre().getX());
        AnnotationKeys.CENTREY.set(this.shape, (Double)this.getMeasurementCentre().getY());
    }

    public String getType() {
        return "Ellipse";
    }

    public void setMeasurementUnits(MeasurementUnits units) {
        this.units = units;
    }

    public PlanePoint2D[] getPoints() {
        Rectangle r = this.ellipse.getBounds();
        ArrayList<PlanePoint2D> vector = new ArrayList<PlanePoint2D>(r.height * r.width);
        int xEnd = r.x + r.width;
        int yEnd = r.y + r.height;
        for (int y = r.y; y < yEnd; ++y) {
            for (int x = r.x; x < xEnd; ++x) {
                if (!this.ellipse.contains(x, y)) continue;
                vector.add(new PlanePoint2D(x, y));
            }
        }
        return vector.toArray(new PlanePoint2D[vector.size()]);
    }
}

