/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.util.roi.figures;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import org.jhotdraw.draw.AttributeKeys;
import org.jhotdraw.draw.BezierFigure;
import org.jhotdraw.draw.Figure;
import org.openmicroscopy.shoola.util.math.geom2D.PlanePoint2D;
import org.openmicroscopy.shoola.util.roi.figures.DrawingAttributes;
import org.openmicroscopy.shoola.util.roi.figures.ROIFigure;
import org.openmicroscopy.shoola.util.roi.model.ROI;
import org.openmicroscopy.shoola.util.roi.model.ROIShape;
import org.openmicroscopy.shoola.util.roi.model.annotation.AnnotationKeys;
import org.openmicroscopy.shoola.util.roi.model.util.MeasurementUnits;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MeasureBezierFigure
extends BezierFigure
implements ROIFigure {
    private ArrayList<Double> pointArrayX;
    private ArrayList<Double> pointArrayY;
    private ArrayList<Double> lengthArray;
    private Rectangle2D bounds;
    private ROI roi;
    private ROIShape shape;
    private MeasurementUnits units;

    public MeasureBezierFigure() {
        this.shape = null;
        this.roi = null;
        this.pointArrayX = new ArrayList();
        this.pointArrayY = new ArrayList();
        this.lengthArray = new ArrayList();
    }

    public MeasureBezierFigure(boolean closed) {
        super(closed);
        this.pointArrayX = new ArrayList();
        this.pointArrayY = new ArrayList();
        this.lengthArray = new ArrayList();
    }

    public void draw(Graphics2D g) {
        super.draw(g);
        if (((Boolean)DrawingAttributes.SHOWMEASUREMENT.get((Figure)this)).booleanValue()) {
            if (((Boolean)CLOSED.get((Figure)this)).booleanValue()) {
                DecimalFormat formatter = new DecimalFormat("###.#");
                String polygonArea = formatter.format(this.getArea());
                polygonArea = this.addAreaUnits(polygonArea);
                double sz = (Double)this.getAttribute(AttributeKeys.FONT_SIZE);
                g.setFont(new Font("Arial", 0, (int)sz));
                this.bounds = g.getFontMetrics().getStringBounds(polygonArea, g);
                this.bounds = new Rectangle2D.Double(this.getBounds().getCenterX() - this.bounds.getWidth() / 2.0, this.getBounds().getCenterY() + this.bounds.getHeight() / 2.0, this.bounds.getWidth(), this.bounds.getHeight());
                g.setColor((Color)DrawingAttributes.MEASUREMENTTEXT_COLOUR.get((Figure)this));
                g.drawString(polygonArea, (int)this.bounds.getX(), (int)this.bounds.getY());
            } else {
                DecimalFormat formatter = new DecimalFormat("###.#");
                String polygonLength = formatter.format(this.getLength());
                polygonLength = this.addLineUnits(polygonLength);
                double sz = (Double)this.getAttribute(AttributeKeys.FONT_SIZE);
                g.setFont(new Font("Arial", 0, (int)sz));
                this.bounds = g.getFontMetrics().getStringBounds(polygonLength, g);
                if (this.getPointCount() > 1) {
                    int midPoint = this.getPointCount() / 2 - 1;
                    if (midPoint < 0) {
                        midPoint = 0;
                    }
                    Point2D.Double p0 = this.getPoint(midPoint);
                    Point2D.Double p1 = this.getPoint(midPoint + 1);
                    double x = Math.min(((Point2D)p0).getX(), ((Point2D)p1).getX()) + Math.abs(((Point2D)p0).getX() - ((Point2D)p1).getX());
                    double y = Math.min(((Point2D)p0).getY(), ((Point2D)p1).getY()) + Math.abs(((Point2D)p0).getY() - ((Point2D)p1).getY());
                    this.bounds = new Rectangle2D.Double(x - this.bounds.getWidth() / 2.0, y + this.bounds.getHeight() / 2.0, this.bounds.getWidth(), this.bounds.getHeight());
                    g.setColor((Color)DrawingAttributes.MEASUREMENTTEXT_COLOUR.get((Figure)this));
                    g.drawString(polygonLength, (int)this.path.getCenter().getX(), (int)this.path.getCenter().getY());
                }
            }
        }
    }

    public Rectangle2D.Double getDrawingArea() {
        Rectangle2D.Double newBounds = super.getDrawingArea();
        if (this.bounds != null) {
            double diff;
            if (newBounds.getX() > this.bounds.getX()) {
                diff = newBounds.x - this.bounds.getX();
                newBounds.x = this.bounds.getX();
                newBounds.width += diff;
            }
            if (newBounds.getY() > this.bounds.getY()) {
                diff = newBounds.y - this.bounds.getY();
                newBounds.y = this.bounds.getY();
                newBounds.height += diff;
            }
            if (this.bounds.getX() + this.bounds.getWidth() > newBounds.getX() + newBounds.getWidth()) {
                diff = this.bounds.getX() + this.bounds.getWidth() - newBounds.getX() + newBounds.getWidth();
                newBounds.width += diff;
            }
            if (this.bounds.getY() + this.bounds.getHeight() > newBounds.getY() + newBounds.getHeight()) {
                diff = this.bounds.getY() + this.bounds.getHeight() - newBounds.getY() + newBounds.getHeight();
                newBounds.height += diff;
            }
        }
        return newBounds;
    }

    public String addDegrees(String str) {
        return str + "\u00b0";
    }

    public String addLineUnits(String str) {
        if (this.shape == null) {
            return str;
        }
        if (this.units.isInMicrons()) {
            return str + "\u00b5m";
        }
        return str + "px";
    }

    public String addAreaUnits(String str) {
        if (this.shape == null) {
            return str;
        }
        if (this.units.isInMicrons()) {
            return str + "\u00b5m" + "\u00b2";
        }
        return str + "px" + "\u00b2";
    }

    private Point2D.Double getPt(int i) {
        Point2D.Double pt = this.getPoint(i);
        if (this.units.isInMicrons()) {
            return new Point2D.Double(pt.getX() * this.units.getMicronsPixelX(), pt.getY() * this.units.getMicronsPixelY());
        }
        return pt;
    }

    public double getLength() {
        double length = 0.0;
        for (int i = 0; i < this.getPointCount() - 1; ++i) {
            Point2D.Double p0 = this.getPt(i);
            Point2D.Double p1 = this.getPt(i + 1);
            length += p0.distance(p1);
        }
        return length;
    }

    public Point2D getCentre() {
        if (this.units.isInMicrons()) {
            Point2D.Double pt1 = this.path.getCenter();
            pt1.setLocation(pt1.getX() * this.units.getMicronsPixelX(), pt1.getY() * this.units.getMicronsPixelY());
            return pt1;
        }
        return this.path.getCenter();
    }

    public double getArea() {
        double area = 0.0;
        Point2D centre = this.getCentre();
        for (int i = 0; i < this.path.size(); ++i) {
            Point2D.Double p0 = this.getPt(i);
            Point2D.Double p1 = i == this.path.size() - 1 ? this.getPt(0) : this.getPt(i + 1);
            ((Point2D)p0).setLocation(((Point2D)p0).getX() - centre.getX(), ((Point2D)p0).getY() - centre.getY());
            ((Point2D)p1).setLocation(((Point2D)p1).getX() - centre.getX(), ((Point2D)p1).getY() - centre.getY());
            area += ((Point2D)p0).getX() * ((Point2D)p1).getY() - ((Point2D)p1).getX() * ((Point2D)p0).getY();
        }
        return Math.abs(area / 2.0);
    }

    public void measureBasicRemoveNode(int index) {
        this.basicRemoveNode(index);
    }

    @Override
    public ROI getROI() {
        return this.roi;
    }

    @Override
    public ROIShape getROIShape() {
        return this.shape;
    }

    @Override
    public void setROI(ROI roi) {
        this.roi = roi;
    }

    @Override
    public void setROIShape(ROIShape shape) {
        this.shape = shape;
    }

    @Override
    public void calculateMeasurements() {
        if (this.shape == null) {
            return;
        }
        this.pointArrayX.clear();
        this.pointArrayY.clear();
        for (int i = 0; i < this.path.size(); ++i) {
            Point2D.Double pt = this.getPt(i);
            this.pointArrayX.add(pt.getX());
            this.pointArrayY.add(pt.getY());
        }
        AnnotationKeys.POINTARRAYX.set(this.shape, this.pointArrayX);
        AnnotationKeys.POINTARRAYY.set(this.shape, this.pointArrayY);
        if (((Boolean)CLOSED.get((Figure)this)).booleanValue()) {
            AnnotationKeys.AREA.set(this.shape, (Double)this.getArea());
            AnnotationKeys.PERIMETER.set(this.shape, (Double)this.getLength());
            AnnotationKeys.CENTREX.set(this.shape, (Double)this.getCentre().getX());
            AnnotationKeys.CENTREY.set(this.shape, (Double)this.getCentre().getY());
        } else {
            this.lengthArray.add(this.getLength());
            AnnotationKeys.LENGTH.set(this.shape, this.lengthArray);
            AnnotationKeys.CENTREX.set(this.shape, (Double)this.getCentre().getX());
            AnnotationKeys.CENTREY.set(this.shape, (Double)this.getCentre().getY());
            AnnotationKeys.STARTPOINTX.set(this.shape, (Double)this.getPt(0).getX());
            AnnotationKeys.STARTPOINTX.set(this.shape, (Double)this.getPt(0).getY());
            AnnotationKeys.ENDPOINTX.set(this.shape, (Double)this.getPt(this.path.size() - 1).getX());
            AnnotationKeys.ENDPOINTY.set(this.shape, (Double)this.getPt(this.path.size() - 1).getY());
        }
    }

    @Override
    public String getType() {
        if (((Boolean)CLOSED.get((Figure)this)).booleanValue()) {
            return "Polygon";
        }
        return "Scribble";
    }

    @Override
    public void setMeasurementUnits(MeasurementUnits units) {
        this.units = units;
    }

    @Override
    public PlanePoint2D[] getPoints() {
        if (this.isClosed()) {
            return this.getAreaPoints();
        }
        return this.getLinePoints();
    }

    private PlanePoint2D[] getAreaPoints() {
        Rectangle r = this.path.getBounds();
        double iX = Math.floor(r.getX());
        double iY = Math.floor(r.getY());
        ArrayList<PlanePoint2D> vector = new ArrayList<PlanePoint2D>();
        this.path.toPolygonArray();
        Point2D.Double point = new Point2D.Double(0.0, 0.0);
        int x = 0;
        while ((double)x < Math.ceil(r.getWidth())) {
            int y = 0;
            while ((double)y < Math.ceil(r.getHeight())) {
                ((Point2D)point).setLocation(iX + (double)x, iY + (double)y);
                if (this.path.contains((Point2D)point)) {
                    vector.add(new PlanePoint2D(((Point2D)point).getX(), ((Point2D)point).getY()));
                }
                ++y;
            }
            ++x;
        }
        return vector.toArray(new PlanePoint2D[vector.size()]);
    }

    private PlanePoint2D[] getLinePoints() {
        Rectangle r = this.path.getBounds();
        ArrayList<PlanePoint2D> vector = new ArrayList<PlanePoint2D>();
        for (int i = 0; i < this.getNodeCount() - 1; ++i) {
            Point2D.Double pt1 = this.getPoint(i);
            Point2D.Double pt2 = this.getPoint(i + 1);
            Line2D.Double line = new Line2D.Double(pt1, pt2);
            this.iterateLine(line, vector);
        }
        return vector.toArray(new PlanePoint2D[vector.size()]);
    }

    private void iterateLine(Line2D line, ArrayList<PlanePoint2D> vector) {
        Point2D start = line.getP1();
        Point2D end = line.getP2();
        Point2D.Double m = new Point2D.Double(end.getX() - start.getX(), end.getY() - start.getY());
        double lengthM = Math.sqrt(((Point2D)m).getX() * ((Point2D)m).getX() + ((Point2D)m).getY() * ((Point2D)m).getY());
        Point2D.Double mNorm = new Point2D.Double(((Point2D)m).getX() / lengthM, ((Point2D)m).getY() / lengthM);
        LinkedHashMap<Point2D.Double, Boolean> map = new LinkedHashMap<Point2D.Double, Boolean>();
        for (double i = 0.0; i < lengthM; i += 0.1) {
            Point2D.Double pt = new Point2D.Double(start.getX() + i * ((Point2D)mNorm).getX(), start.getY() + i * ((Point2D)mNorm).getY());
            Point2D.Double quantisedPoint = new Point2D.Double(Math.floor(((Point2D)pt).getX()), Math.floor(((Point2D)pt).getY()));
            if (map.containsKey(quantisedPoint)) continue;
            map.put(quantisedPoint, new Boolean(true));
        }
        for (Point2D p : map.keySet()) {
            vector.add(new PlanePoint2D(p.getX(), p.getY()));
        }
    }
}

