/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.util.roi.figures;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.font.FontRenderContext;
import java.awt.font.TextAttribute;
import java.awt.font.TextLayout;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import java.util.HashMap;
import org.jhotdraw.draw.AttributeKeys;
import org.jhotdraw.draw.Figure;
import org.jhotdraw.draw.TextHolderFigure;
import org.jhotdraw.draw.Tool;
import org.jhotdraw.geom.Insets2D;
import org.openmicroscopy.shoola.util.roi.figures.DrawingAttributes;
import org.openmicroscopy.shoola.util.roi.figures.MeasureLineFigure;
import org.openmicroscopy.shoola.util.roi.figures.textutil.MeasureTextTool;

public class LineAnnotationFigure
extends MeasureLineFigure
implements TextHolderFigure {
    private boolean editable = true;
    private boolean displayText = true;
    private transient TextLayout textLayout;
    private Rectangle2D.Double textBounds;

    public LineAnnotationFigure() {
        this("Text");
    }

    public LineAnnotationFigure(String text) {
        this.setText(text);
        this.textLayout = null;
        this.textBounds = null;
    }

    public Rectangle2D.Double getBounds() {
        return super.getBounds();
    }

    protected void drawStroke(Graphics2D g) {
        super.drawStroke(g);
    }

    protected void drawFill(Graphics2D g) {
        super.drawFill(g);
        this.drawText(g);
    }

    public boolean contains(Point2D.Double p) {
        return this.getBounds().contains(p);
    }

    protected void drawText(Graphics2D g) {
        if (((Boolean)DrawingAttributes.SHOWTEXT.get((Figure)this)).booleanValue() && this.displayText && (this.getText() != null || this.isEditable())) {
            TextLayout layout = this.getTextLayout();
            this.setTextBounds(g);
            layout.draw(g, (float)this.textBounds.x, (float)this.textBounds.y);
        }
    }

    protected void setTextBounds(Graphics2D g) {
        this.textBounds = new Rectangle2D.Double(this.getTextX(g), this.getTextY(g), this.getTextWidth(g), this.getTextHeight(g));
    }

    protected double getTextX(Graphics2D g) {
        return super.getBounds().getX() + super.getBounds().getWidth() / 2.0 - this.getTextWidth(g) / 2.0;
    }

    protected double getTextY(Graphics2D g) {
        return super.getBounds().getCenterY() + this.getTextHeight(g) / 2.0;
    }

    protected double getTextWidth(Graphics2D g) {
        return g.getFontMetrics((Font)AttributeKeys.FONT_FACE.get((Figure)this)).stringWidth(this.getText().trim());
    }

    protected double getTextHeight(Graphics2D g) {
        return g.getFontMetrics((Font)AttributeKeys.FONT_FACE.get((Figure)this)).getAscent();
    }

    protected Rectangle2D.Double getTextBounds() {
        if (this.textBounds == null) {
            return new Rectangle2D.Double(0.0, 0.0, 0.0, 0.0);
        }
        return this.textBounds;
    }

    public void invalidate() {
        super.invalidate();
        this.textLayout = null;
    }

    protected void validate() {
        super.validate();
        this.textLayout = null;
    }

    public Rectangle2D.Double getDrawingArea() {
        Rectangle2D.Double r = super.getDrawingArea();
        r.add(this.getTextBounds());
        return r;
    }

    public Tool getTool(Point2D.Double p) {
        boolean showText = false;
        if (this.isEditable() && this.getBounds().contains(p)) {
            showText = true;
        }
        if (this.path != null && showText && this.path.outlineContains(p, 5.0)) {
            showText = false;
        }
        if (showText) {
            this.displayText = false;
            this.invalidate();
            return new MeasureTextTool(this);
        }
        return null;
    }

    private TextLayout getTextLayout() {
        if (this.textLayout == null) {
            String text = this.getText();
            if (text == null || text.length() == 0) {
                text = " ";
            }
            FontRenderContext frc = this.getFontRenderContext();
            HashMap<TextAttribute, Serializable> textAttributes = new HashMap<TextAttribute, Serializable>();
            textAttributes.put(TextAttribute.FONT, this.getFont());
            if (((Boolean)AttributeKeys.FONT_UNDERLINED.get((Figure)this)).booleanValue()) {
                textAttributes.put(TextAttribute.UNDERLINE, TextAttribute.UNDERLINE_LOW_ONE_PIXEL);
            }
            this.textLayout = new TextLayout(text, textAttributes, frc);
        }
        return this.textLayout;
    }

    public String getText() {
        return (String)this.getAttribute(AttributeKeys.TEXT);
    }

    public void setText(String newText) {
        this.displayText = true;
        this.setAttribute(AttributeKeys.TEXT, newText);
    }

    public int getTextColumns() {
        return this.getText() == null ? 4 : Math.max(this.getText().length(), 4);
    }

    public int getTabSize() {
        return 8;
    }

    public TextHolderFigure getLabelFor() {
        return this;
    }

    public Insets2D.Double getInsets() {
        return new Insets2D.Double();
    }

    public Font getFont() {
        return AttributeKeys.getFont((Figure)this);
    }

    public Color getTextColor() {
        return (Color)AttributeKeys.TEXT_COLOR.get((Figure)this);
    }

    public Color getFillColor() {
        return (Color)AttributeKeys.FILL_COLOR.get((Figure)this);
    }

    public void setFontSize(float size) {
    }

    public float getFontSize() {
        return ((Double)AttributeKeys.FONT_SIZE.get((Figure)this)).floatValue();
    }

    public boolean isEditable() {
        return this.editable;
    }

    public void setEditable(boolean b) {
        this.editable = b;
    }
}

