/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.util.image.io;

import java.awt.image.BufferedImage;
import java.io.File;
import java.util.Iterator;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriter;
import javax.imageio.stream.ImageOutputStream;
import org.openmicroscopy.shoola.util.image.io.Encoder;
import org.openmicroscopy.shoola.util.image.io.EncoderException;

public class WriterImage {
    public static void saveImage(File f, BufferedImage img, String format) throws EncoderException {
        if (f == null) {
            throw new IllegalArgumentException("No file specified.");
        }
        if (img == null) {
            throw new IllegalArgumentException("No image specified.");
        }
        try {
            Iterator<ImageWriter> writers = ImageIO.getImageWritersByFormatName(format);
            ImageWriter writer = writers.next();
            ImageOutputStream ios = ImageIO.createImageOutputStream(f);
            writer.setOutput(ios);
            writer.write(img);
            ios.close();
        }
        catch (Exception e) {
            throw new EncoderException("Cannot encode the image.", e);
        }
    }

    public static void saveImage(Encoder encoder) throws EncoderException {
        if (encoder == null) {
            throw new IllegalArgumentException("No encoder specified.");
        }
        try {
            encoder.write();
            encoder.getOutput().close();
        }
        catch (Exception e) {
            throw new EncoderException("Cannot encode the image.", e);
        }
    }
}

