/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.svc.transport;

import org.apache.commons.httpclient.HostConfiguration;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.URI;
import org.apache.commons.httpclient.URIException;
import org.openmicroscopy.shoola.svc.transport.HttpChannel;

class BasicChannel
extends HttpChannel {
    static final int DEF_CONN_TIMEOUT = 10000;
    private final URI serverURL;
    private final String requestPath;
    private final int connTimeout;

    BasicChannel(String url, int connTimeout) throws IllegalArgumentException {
        try {
            this.serverURL = new URI(url);
            this.requestPath = this.serverURL.getPath();
        }
        catch (URIException e) {
            throw new IllegalArgumentException("Invalid URL to Server: " + url + ".");
        }
        this.connTimeout = connTimeout < 0 ? 10000 : connTimeout;
    }

    protected HttpClient getCommunicationLink() {
        HostConfiguration cfg = new HostConfiguration();
        cfg.setHost(this.serverURL);
        String proxyHost = System.getProperty("http.proxyHost");
        String proxyPort = System.getProperty("http.proxyPort");
        if (proxyHost != null && proxyPort != null) {
            int port = Integer.parseInt(proxyPort);
            cfg.setProxy(proxyHost, port);
        }
        HttpClient channel = new HttpClient();
        channel.setHostConfiguration(cfg);
        channel.setConnectionTimeout(this.connTimeout);
        return channel;
    }

    protected String getRequestPath() {
        return this.requestPath;
    }
}

