/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.svc.proxy;

import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.openmicroscopy.shoola.svc.proxy.Request;
import org.openmicroscopy.shoola.svc.transport.TransportException;

class MessengerRequest
extends Request {
    private static final String EMAIL = "email";
    private static final String COMMENT = "comment";
    private static final String ERROR = "error";
    private static final String EXTRA = "extra";
    private static final String INVOKER = "type";
    private static final String JAVA_VERSION = "java_version";
    private static final String JAVA_CLASS_PATH = "java_class_path";
    private static final String OS_NAME = "os_name";
    private static final String OS_ARCH = "os_arch";
    private static final String OS_VERSION = "os_version";
    private String error;
    private String email;
    private String comment;
    private String extra;
    private String invoker;

    MessengerRequest(String email, String comment, String extra, String error, String invoker) {
        this.error = error;
        this.email = email;
        this.comment = comment;
        this.extra = extra;
        this.invoker = invoker;
    }

    public HttpMethod marshal() throws TransportException {
        PostMethod request = new PostMethod();
        if (this.email != null) {
            request.addParameter(EMAIL, this.email);
        }
        if (this.comment != null) {
            request.addParameter(COMMENT, this.comment);
        }
        if (this.error != null) {
            request.addParameter(ERROR, this.error);
        }
        if (this.extra != null) {
            request.addParameter(EXTRA, this.extra);
        }
        request.addParameter(INVOKER, this.invoker);
        request.addParameter(JAVA_VERSION, System.getProperty("java.version"));
        request.addParameter(JAVA_CLASS_PATH, System.getProperty("java.class.path"));
        request.addParameter(OS_NAME, System.getProperty("os.name"));
        request.addParameter(OS_ARCH, System.getProperty("os.arch"));
        request.addParameter(OS_VERSION, System.getProperty("os.version"));
        return request;
    }
}

