/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.env.ui;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JOptionPane;
import org.openmicroscopy.shoola.env.Container;
import org.openmicroscopy.shoola.env.config.Registry;
import org.openmicroscopy.shoola.svc.SvcRegistry;
import org.openmicroscopy.shoola.svc.communicator.Communicator;
import org.openmicroscopy.shoola.svc.communicator.CommunicatorDescriptor;
import org.openmicroscopy.shoola.util.ui.MessengerDetails;
import org.openmicroscopy.shoola.util.ui.MessengerDialog;

class UserNotifierManager
implements PropertyChangeListener {
    private static final String MESSAGE_START = "Sorry, but due to an error we were not able to automatically \nsend your . ";
    private static final String MESSAGE_END = "\n\nYou can still send us the error message by clicking on the \nerror message tab, copying the error message to the clipboard, \nand sending it to ";
    private static final String ERROR_MSG = "debug information.";
    private static final String COMMENT_MSG = "comment.";
    private static final String COMMENT_REPLY = "Thanks, your comments have been successfully posted.";
    private static final String ERROR_REPLY = "Thanks, the error message has been successfully posted.";
    private Container container;

    private void handleSendMessage(MessengerDialog source, MessengerDetails details) {
        Registry reg = this.container.getRegistry();
        boolean bug = true;
        String error = details.getError();
        if (error == null || error.length() == 0) {
            bug = false;
        }
        String url = bug ? (String)reg.lookup("/services/DEBUGGER/hostnameBug") : (String)reg.lookup("/services/DEBUGGER/hostnameComment");
        String teamAddress = (String)reg.lookup("/services/DEBUGGER/email");
        CommunicatorDescriptor desc = new CommunicatorDescriptor(1, url, -1);
        try {
            Communicator c = SvcRegistry.getCommunicator(desc);
            String reply = "";
            if (!bug) {
                c.submitComment(details.getEmail(), details.getComment(), details.getExtra(), reply);
            } else {
                c.submitError(details.getEmail(), details.getComment(), details.getExtra(), error, reply);
            }
            reply = !bug ? reply + COMMENT_REPLY : reply + ERROR_REPLY;
            JOptionPane.showMessageDialog(source, reply);
        }
        catch (Exception e) {
            String s = MESSAGE_START;
            s = source.getDialogType() == 0 ? s + ERROR_MSG : s + COMMENT_MSG;
            s = s + MESSAGE_END;
            JOptionPane.showMessageDialog(source, s + teamAddress + ".");
        }
        source.setVisible(false);
        source.dispose();
    }

    UserNotifierManager(Container c) {
        this.container = c;
    }

    public void propertyChange(PropertyChangeEvent pce) {
        String name = pce.getPropertyName();
        if (name == null) {
            return;
        }
        if (name.equals("send")) {
            if (this.container == null) {
                return;
            }
            MessengerDialog source = (MessengerDialog)pce.getSource();
            this.handleSendMessage(source, (MessengerDetails)pce.getNewValue());
        }
    }
}

