/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.env.ui;

import javax.swing.Icon;
import javax.swing.JFrame;
import org.openmicroscopy.shoola.env.Container;
import org.openmicroscopy.shoola.env.ui.AbstractIconManager;
import org.openmicroscopy.shoola.env.ui.IconManager;
import org.openmicroscopy.shoola.env.ui.UserNotifier;
import org.openmicroscopy.shoola.env.ui.UserNotifierManager;
import org.openmicroscopy.shoola.util.ui.MessengerDialog;
import org.openmicroscopy.shoola.util.ui.NotificationDialog;
import org.openmicroscopy.shoola.util.ui.UIUtilities;

public class UserNotifierImpl
implements UserNotifier {
    private static final String DEFAULT_COMMENT_TITLE = "Comment";
    private static final String DEFAULT_ERROR_TITLE = "Error";
    private static final String DEFAULT_WARNING_TITLE = "Warning";
    private static final String DEFAULT_INFO_TITLE = "Information";
    private static JFrame SHARED_FRAME = null;
    private UserNotifierManager manager;

    private void showNotificationDialog(String title, String message, Icon icon) {
        NotificationDialog dialog = new NotificationDialog(SHARED_FRAME, title, message, icon);
        dialog.pack();
        UIUtilities.centerAndShow(dialog);
    }

    private void showErrorDialog(String title, String summary, String detail) {
        Exception e = detail == null ? new Exception(summary) : new Exception(detail);
        if (title == null || title.length() == 0) {
            title = DEFAULT_ERROR_TITLE;
        }
        MessengerDialog d = new MessengerDialog(SHARED_FRAME, title, "", e);
        d.addPropertyChangeListener(this.manager);
        d.setModal(true);
        UIUtilities.centerAndShow(d);
    }

    UserNotifierImpl(Container c) {
        this.manager = new UserNotifierManager(c);
        if (SHARED_FRAME == null) {
            SHARED_FRAME = new JFrame();
            SHARED_FRAME.setIconImage(AbstractIconManager.getOMEImageIcon());
        }
    }

    public void notifyError(String title, String summary) {
        if (title == null || title.length() == 0) {
            title = DEFAULT_ERROR_TITLE;
        }
        this.showNotificationDialog(title, summary, IconManager.getDefaultErrorIcon());
    }

    public void notifyError(String title, String summary, Throwable detail) {
        this.notifyError(title, summary, detail == null ? null : detail.getMessage());
    }

    public void notifyError(String title, String summary, String detail) {
        if (title == null || title.length() == 0) {
            title = DEFAULT_ERROR_TITLE;
        }
        this.showErrorDialog(title, summary, detail);
    }

    public void notifyWarning(String title, String message) {
        if (title == null || title.length() == 0) {
            title = DEFAULT_WARNING_TITLE;
        }
        this.showNotificationDialog(title, message, IconManager.getDefaultWarnIcon());
    }

    public void notifyWarning(String title, String summary, String detail) {
        if (title == null || title.length() == 0) {
            title = DEFAULT_WARNING_TITLE;
        }
        this.showErrorDialog(title, summary, detail);
    }

    public void notifyWarning(String title, String summary, Throwable detail) {
        this.notifyWarning(title, summary, detail == null ? null : detail.getMessage());
    }

    public void notifyInfo(String title, String message) {
        if (title == null || title.length() == 0) {
            title = DEFAULT_INFO_TITLE;
        }
        this.showNotificationDialog(title, message, IconManager.getDefaultInfoIcon());
    }

    public void notifyInfo(String title, String message, Icon icon) {
        if (title == null || title.length() == 0) {
            title = DEFAULT_INFO_TITLE;
        }
        if (icon == null) {
            icon = IconManager.getDefaultInfoIcon();
        }
        this.showNotificationDialog(title, message, icon);
    }

    public void submitMessage(String email) {
        MessengerDialog d = new MessengerDialog(SHARED_FRAME, DEFAULT_COMMENT_TITLE, email);
        d.addPropertyChangeListener(this.manager);
        d.setModal(true);
        UIUtilities.centerAndShow(d);
    }
}

