/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.env.ui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import javax.swing.AbstractButton;
import org.openmicroscopy.shoola.env.ui.TopWindow;

public class TopWindowManager {
    public static final int UNLINKED = 1;
    public static final int DISPLAYABLE = 2;
    public static final int ON_SCREEN = 3;
    private TopWindow window;
    private AbstractButton[] displayButtons;
    private int state;

    private void setInitialState() {
        this.state = this.window.isDisplayable() ? (this.window.isShowing() ? 3 : 2) : 1;
    }

    private void attachWindowListeners() {
        WindowAdapter wa = new WindowAdapter(){

            public void windowClosed(WindowEvent we) {
                TopWindowManager.this.handleDispose();
            }

            public void windowClosing(WindowEvent we) {
                TopWindowManager.this.handleHide();
            }
        };
        this.window.addWindowListener(wa);
        ComponentAdapter ca = new ComponentAdapter(){

            public void componentHidden(ComponentEvent ce) {
                TopWindowManager.this.handleHide();
            }

            public void componentShown(ComponentEvent ce) {
                TopWindowManager.this.handleDisplay();
            }
        };
        this.window.addComponentListener(ca);
    }

    private void attachButtonsListeners() {
        ActionListener al = new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                TopWindowManager.this.handleDisplay();
            }
        };
        for (int i = 0; i < this.displayButtons.length; ++i) {
            this.displayButtons[i].addActionListener(al);
        }
    }

    private void handleDisplay() {
        if (this.state == 3) {
            this.toForeground();
        } else {
            this.window.setOnScreen();
            this.toForeground();
            this.state = 3;
        }
    }

    private void handleHide() {
        if (this.state == 3) {
            this.state = 2;
        }
    }

    private void handleDispose() {
        this.state = 1;
    }

    private void toForeground() {
        this.window.setExtendedState(0);
        this.window.toFront();
    }

    public TopWindowManager(TopWindow window, AbstractButton[] displayButtons) {
        if (window == null) {
            throw new NullPointerException("No window.");
        }
        this.window = window;
        if (displayButtons != null) {
            ArrayList<AbstractButton> actualButtons = new ArrayList<AbstractButton>(displayButtons.length);
            for (int i = 0; i < displayButtons.length; ++i) {
                if (displayButtons[i] == null) continue;
                actualButtons.add(displayButtons[i]);
            }
            this.displayButtons = new AbstractButton[actualButtons.size()];
            actualButtons.toArray(this.displayButtons);
        } else {
            this.displayButtons = new AbstractButton[0];
        }
        this.setInitialState();
        this.attachWindowListeners();
        this.attachButtonsListeners();
    }

    public int getState() {
        return this.state;
    }
}

