/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.env.ui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Method;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.openmicroscopy.shoola.env.Container;
import org.openmicroscopy.shoola.env.config.Registry;
import org.openmicroscopy.shoola.env.data.DSOutOfServiceException;
import org.openmicroscopy.shoola.env.data.DataServicesFactory;
import org.openmicroscopy.shoola.env.data.events.ExitApplication;
import org.openmicroscopy.shoola.env.data.events.ServiceActivationRequest;
import org.openmicroscopy.shoola.env.data.events.ServiceActivationResponse;
import org.openmicroscopy.shoola.env.event.AgentEvent;
import org.openmicroscopy.shoola.env.event.AgentEventListener;
import org.openmicroscopy.shoola.env.event.EventBus;
import org.openmicroscopy.shoola.env.ui.ExitDialog;
import org.openmicroscopy.shoola.env.ui.IconManager;
import org.openmicroscopy.shoola.env.ui.SoftwareUpdateDialog;
import org.openmicroscopy.shoola.env.ui.TaskBar;
import org.openmicroscopy.shoola.env.ui.TaskBarView;
import org.openmicroscopy.shoola.env.ui.UserNotifier;
import org.openmicroscopy.shoola.util.ui.UIUtilities;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

class TaskBarManager
implements AgentEventListener,
PropertyChangeListener {
    private static final String ABOUT_FILE = "about.xml";
    private static final String DOC_FILE = "insight_index.html";
    private static final String A_TAG = "a";
    private static final String[] BROWSERS_UNIX = new String[6];
    private TaskBarView view;
    private Container container;
    private SoftwareUpdateDialog suDialog;

    private String parse() {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.parse(new File(this.container.resolveConfigFile(ABOUT_FILE)));
            NodeList list = document.getElementsByTagName(A_TAG);
            String url = null;
            for (int i = 0; i < list.getLength(); ++i) {
                Node n = list.item(i);
                url = n.getFirstChild().getNodeValue();
            }
            return url;
        }
        catch (Exception e) {
            if (this.suDialog != null) {
                this.suDialog.close();
            }
            UserNotifier un = this.container.getRegistry().getUserNotifier();
            un.notifyInfo("Launch Browser", "Cannot launch the web browser.");
            return null;
        }
    }

    private void openURL(String url) {
        String osName = System.getProperty("os.name");
        try {
            if (osName.startsWith("Mac OS")) {
                Class<?> fileMgr = Class.forName("com.apple.eio.FileManager");
                Method openURL = fileMgr.getDeclaredMethod("openURL", String.class);
                openURL.invoke(null, url);
                if (this.suDialog != null) {
                    this.suDialog.close();
                }
            } else if (osName.startsWith("Windows")) {
                Runtime.getRuntime().exec("rundll32 url.dll,FileProtocolHandler " + url);
            } else {
                String browser = null;
                for (int count = 0; count < BROWSERS_UNIX.length && browser == null; ++count) {
                    if (Runtime.getRuntime().exec(new String[]{"which", BROWSERS_UNIX[count]}).waitFor() != 0) continue;
                    browser = BROWSERS_UNIX[count];
                }
                if (browser == null) {
                    throw new Exception("Could not find web browser");
                }
                Runtime.getRuntime().exec(new String[]{browser, url});
                if (this.suDialog != null) {
                    this.suDialog.close();
                }
            }
        }
        catch (Exception e) {
            UserNotifier un = this.container.getRegistry().getUserNotifier();
            un.notifyInfo("Launch Browser", "Cannot launch the web browser.");
        }
    }

    private String loadAbout(String file) {
        String message;
        try {
            String line;
            FileInputStream fis = new FileInputStream(file);
            BufferedReader in = new BufferedReader(new InputStreamReader(fis));
            StringBuffer buffer = new StringBuffer();
            int number = 0;
            while ((line = in.readLine()) != null) {
                if (number != 0) {
                    buffer.append(line);
                }
                ++number;
            }
            in.close();
            message = buffer.toString();
        }
        catch (Exception e) {
            message = "Error: About information not found";
        }
        return message;
    }

    private void synchConnectionButtons() {
        boolean connected = false;
        try {
            DataServicesFactory f = DataServicesFactory.getInstance(this.container);
            connected = f.isConnected();
        }
        catch (DSOutOfServiceException dSOutOfServiceException) {
            // empty catch block
        }
        this.view.getButton(9).setEnabled(!connected);
        this.view.getButton(1).setEnabled(!connected);
        this.view.getButton(10).setEnabled(connected);
        this.view.getButton(2).setEnabled(connected);
    }

    private void doManageConnection() {
        try {
            DataServicesFactory f = DataServicesFactory.getInstance(this.container);
            if (f.isConnected()) {
                f.shutdown();
                this.synchConnectionButtons();
            } else {
                EventBus bus = this.container.getRegistry().getEventBus();
                bus.post(new ServiceActivationRequest(1));
            }
        }
        catch (DSOutOfServiceException oose) {
            this.synchConnectionButtons();
        }
    }

    private void doExit() {
        IconManager icons = IconManager.getInstance(this.container.getRegistry());
        ExitDialog d = new ExitDialog(this.view, icons.getIcon(10), this.container);
        UIUtilities.centerAndShow(d);
    }

    private void notAvailable() {
        UserNotifier un = this.container.getRegistry().getUserNotifier();
        un.notifyInfo("Not Available", "Sorry, this functionality is not yet available.");
    }

    private void sendComment() {
        Registry reg = this.container.getRegistry();
        UserNotifier un = reg.getUserNotifier();
        un.submitMessage("");
    }

    private void softWareUpdates() {
        String message = this.loadAbout(this.container.resolveConfigFile(ABOUT_FILE));
        this.suDialog = new SoftwareUpdateDialog(this.view, message);
        this.suDialog.addPropertyChangeListener("openURL", this);
        UIUtilities.centerAndShow(this.suDialog);
    }

    private void help() {
        String path = "file://" + this.container.resolveDocFile(DOC_FILE);
        this.openURL(path);
    }

    private void attachMIListeners() {
        ActionListener noOp = new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                TaskBarManager.this.notAvailable();
            }
        };
        this.view.getButton(3).addActionListener(noOp);
        this.view.getButton(4).addActionListener(noOp);
        this.view.getButton(5).addActionListener(noOp);
        this.view.getButton(6).addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                TaskBarManager.this.softWareUpdates();
            }
        });
        this.view.getButton(7).addActionListener(noOp);
        this.view.getButton(11).addActionListener(noOp);
        this.view.getButton(12).addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                TaskBarManager.this.sendComment();
            }
        });
    }

    private void attachConnectionListeners() {
        ActionListener conx = new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                TaskBarManager.this.doManageConnection();
            }
        };
        this.view.getButton(9).addActionListener(conx);
        this.view.getButton(1).addActionListener(conx);
        this.view.getButton(10).addActionListener(conx);
        this.view.getButton(2).addActionListener(conx);
    }

    private void attachOpenExitListeners() {
        this.view.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent we) {
                TaskBarManager.this.doExit();
            }

            public void windowOpened(WindowEvent we) {
                TaskBarManager.this.synchConnectionButtons();
            }
        });
        ActionListener exit = new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                TaskBarManager.this.doExit();
            }
        };
    }

    private void attachListeners() {
        this.attachOpenExitListeners();
        this.attachConnectionListeners();
        this.attachMIListeners();
        EventBus bus = this.container.getRegistry().getEventBus();
        bus.register((AgentEventListener)this, ServiceActivationResponse.class);
        bus.register((AgentEventListener)this, ExitApplication.class);
    }

    TaskBarManager(Container c) {
        this.container = c;
        this.view = new TaskBarView(IconManager.getInstance(this.container.getRegistry()));
        this.attachListeners();
    }

    TaskBar getView() {
        return this.view;
    }

    public void eventFired(AgentEvent e) {
        if (e instanceof ServiceActivationResponse) {
            this.synchConnectionButtons();
        } else if (e instanceof ExitApplication) {
            this.doExit();
        }
    }

    public void propertyChange(PropertyChangeEvent evt) {
        String name = evt.getPropertyName();
        if ("openURL".equals(name)) {
            this.openURL(this.parse());
        }
    }

    static {
        TaskBarManager.BROWSERS_UNIX[0] = "firefox";
        TaskBarManager.BROWSERS_UNIX[1] = "opera";
        TaskBarManager.BROWSERS_UNIX[2] = "konqueror";
        TaskBarManager.BROWSERS_UNIX[3] = "epiphany";
        TaskBarManager.BROWSERS_UNIX[4] = "mozilla";
        TaskBarManager.BROWSERS_UNIX[5] = "netscape";
    }
}

