/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.env.ui;

import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.awt.event.WindowStateListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JFrame;
import org.openmicroscopy.shoola.env.Container;
import org.openmicroscopy.shoola.env.data.login.UserCredentials;
import org.openmicroscopy.shoola.env.ui.IconManager;
import org.openmicroscopy.shoola.env.ui.SplashScreen;
import org.openmicroscopy.shoola.env.ui.SplashScreenFuture;
import org.openmicroscopy.shoola.env.ui.UIFactory;
import org.openmicroscopy.shoola.env.ui.UserNotifier;
import org.openmicroscopy.shoola.util.ui.login.LoginCredentials;
import org.openmicroscopy.shoola.util.ui.login.ScreenLogin;
import org.openmicroscopy.shoola.util.ui.login.ScreenLogo;

class SplashScreenManager
implements PropertyChangeListener,
WindowFocusListener,
WindowStateListener {
    static final String TITLE = "Open Microscopy Environment";
    private static final String VERSION = "3.0_Beta2.1";
    private ScreenLogin view;
    private ScreenLogo viewTop;
    private boolean isOpen;
    private SplashScreenFuture userCredentials;
    private int totalTasks;
    private int doneTasks;
    private Container container;
    private SplashScreen component;

    private void login(LoginCredentials lc) {
        try {
            UserCredentials uc = new UserCredentials(lc.getUserName(), lc.getPassword(), lc.getHostName());
            this.userCredentials.set(uc);
        }
        catch (Exception e) {
            UserNotifier un = UIFactory.makeUserNotifier(this.container);
            un.notifyError("Login Incomplete", e.getMessage());
            this.view.setControlsEnabled(true);
        }
    }

    private void setWindowState(JFrame f, int state) {
        f.removeWindowStateListener(this);
        f.setState(state);
        f.addWindowStateListener(this);
    }

    SplashScreenManager(SplashScreen component, Container c) {
        this.container = c;
        this.component = component;
        Image img = IconManager.getOMEImageIcon();
        this.view = new ScreenLogin(TITLE, IconManager.getLoginBackground(), img, VERSION);
        this.viewTop = new ScreenLogo(TITLE, IconManager.getSplashScreen(), img);
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension d = this.viewTop.getExtendedSize();
        Dimension dlogin = this.view.getPreferredSize();
        int totalHeight = d.height + dlogin.height;
        this.viewTop.setBounds((screenSize.width - d.width) / 2, (screenSize.height - totalHeight) / 2, d.width, this.viewTop.getSize().height);
        Rectangle r = this.viewTop.getBounds();
        this.view.setBounds(r.x, r.y + d.height, dlogin.width, dlogin.height);
        this.view.addPropertyChangeListener(this);
        this.viewTop.addPropertyChangeListener(this);
        this.view.addWindowStateListener(this);
        this.viewTop.addWindowStateListener(this);
        this.view.addWindowFocusListener(this);
        this.viewTop.addWindowFocusListener(this);
        this.isOpen = false;
        this.doneTasks = 0;
    }

    void open() {
        if (this.view == null || this.viewTop == null) {
            return;
        }
        this.viewTop.setVisible(true);
        this.isOpen = true;
    }

    void close() {
        if (this.view == null || this.viewTop == null) {
            return;
        }
        this.view.dispose();
        this.viewTop.dispose();
        this.view = null;
        this.viewTop = null;
        this.isOpen = false;
    }

    void setTotalTasks(int value) {
        if (!this.isOpen) {
            return;
        }
        this.totalTasks = value;
        ++this.totalTasks;
        this.viewTop.initProgressBar(value);
    }

    void updateProgress(String task) {
        if (!this.isOpen) {
            return;
        }
        int n = this.doneTasks++;
        this.viewTop.setStatus(task, n);
        if (this.doneTasks == this.totalTasks) {
            this.viewTop.setStatusVisible(false);
            this.view.setVisible(true);
        }
    }

    void collectUserCredentials(SplashScreenFuture future, boolean init) {
        this.userCredentials = future;
        this.view.setControlsEnabled(true);
        if (!init) {
            this.view.setCursor(Cursor.getDefaultCursor());
            this.view.cleanField(1);
        }
    }

    void collectUserCredentialsInit(SplashScreenFuture future) {
        this.userCredentials = future;
        this.view.setControlsEnabled(true);
    }

    public void propertyChange(PropertyChangeEvent evt) {
        String name = evt.getPropertyName();
        if ("login".equals(name)) {
            LoginCredentials lc = (LoginCredentials)evt.getNewValue();
            if (this.userCredentials != null && lc != null) {
                this.login(lc);
            }
        } else if ("quit".equals(name)) {
            this.container.exit();
            this.component.close();
        } else if ("toFront".equals(name) || "moveFront".equals(name)) {
            this.view.setAlwaysOnTop(true);
            this.viewTop.setAlwaysOnTop(true);
        }
    }

    public void windowStateChanged(WindowEvent e) {
        Object src = e.getSource();
        int state = e.getNewState();
        if (src instanceof ScreenLogo) {
            this.setWindowState(this.view, state);
        } else if (src instanceof ScreenLogin) {
            this.setWindowState(this.viewTop, state);
        }
        this.view.setAlwaysOnTop(state == 0);
        this.viewTop.setAlwaysOnTop(state == 0);
    }

    public void windowLostFocus(WindowEvent e) {
        if (e.getOppositeWindow() == null) {
            if (this.view != null) {
                this.view.setAlwaysOnTop(false);
            }
            if (this.view != null) {
                this.viewTop.setAlwaysOnTop(false);
            }
        }
    }

    public void windowGainedFocus(WindowEvent e) {
    }
}

