/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.env.rnd.roi;

import java.util.LinkedHashMap;
import java.util.Map;
import org.openmicroscopy.shoola.env.rnd.roi.PointIteratorObserver;
import org.openmicroscopy.shoola.util.math.geom2D.PlanePoint2D;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ROIShapeStats
implements PointIteratorObserver {
    double min;
    double max;
    double sum;
    double sumOfSquares;
    double mean;
    double standardDeviation;
    int pointsCount;
    private Map<PlanePoint2D, Double> pixelsValue;

    public double getMin() {
        return this.min;
    }

    public double getMax() {
        return this.max;
    }

    public double getMean() {
        return this.mean;
    }

    public double getStandardDeviation() {
        return this.standardDeviation;
    }

    public double getSum() {
        return this.sum;
    }

    public int getPointsCount() {
        return this.pointsCount;
    }

    public Map<PlanePoint2D, Double> getPixelsValue() {
        return this.pixelsValue;
    }

    @Override
    public void onEndPlane(int z, int c, int t, int pointsCount) {
        double sigmaSquare;
        if (pointsCount <= 0) {
            return;
        }
        this.mean = this.sum / (double)pointsCount;
        this.pointsCount = pointsCount;
        if (0 < pointsCount - 1 && (sigmaSquare = (this.sumOfSquares - this.sum * this.sum / (double)pointsCount) / (double)(pointsCount - 1)) > 0.0) {
            this.standardDeviation = Math.sqrt(sigmaSquare);
        }
    }

    @Override
    public void update(double pixelValue, int z, int w, int t, PlanePoint2D loc) {
        if (pixelValue < this.min) {
            this.min = pixelValue;
        }
        if (this.max < pixelValue) {
            this.max = pixelValue;
        }
        this.sum += pixelValue;
        this.sumOfSquares += pixelValue * pixelValue;
        this.pixelsValue.put(loc, new Double(pixelValue));
    }

    @Override
    public void onStartPlane(int z, int w, int t, int pointsCount) {
        this.pixelsValue = new LinkedHashMap<PlanePoint2D, Double>(pointsCount);
    }

    @Override
    public void iterationStarted() {
    }

    @Override
    public void iterationFinished() {
    }
}

