/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.env.rnd.roi;

import java.util.HashSet;
import java.util.Set;
import org.openmicroscopy.shoola.env.rnd.data.DataSink;
import org.openmicroscopy.shoola.env.rnd.data.DataSourceException;
import org.openmicroscopy.shoola.env.rnd.data.Plane2D;
import org.openmicroscopy.shoola.env.rnd.roi.PointIteratorObserver;
import org.openmicroscopy.shoola.util.math.geom2D.PlanePoint2D;
import org.openmicroscopy.shoola.util.roi.figures.ROIFigure;
import org.openmicroscopy.shoola.util.roi.model.ROIShape;

class PointIterator {
    private DataSink source;
    private int sizeZ;
    private int sizeT;
    private int sizeC;
    private Set<PointIteratorObserver> observers;

    private void notifyIterationStart() {
        for (PointIteratorObserver obs : this.observers) {
            obs.iterationStarted();
        }
    }

    private void notifyIterationEnd() {
        for (PointIteratorObserver obs : this.observers) {
            obs.iterationFinished();
        }
    }

    private void notifyPlaneStart(int z, int w, int t, int pointsCount) {
        for (PointIteratorObserver obs : this.observers) {
            obs.onStartPlane(z, w, t, pointsCount);
        }
    }

    private void notifyValue(double pixelValue, int z, int w, int t, PlanePoint2D loc) {
        for (PointIteratorObserver obs : this.observers) {
            obs.update(pixelValue, z, w, t, loc);
        }
    }

    private void notifyPlaneEnd(int z, int w, int t, int pointsCount) {
        for (PointIteratorObserver obs : this.observers) {
            obs.onEndPlane(z, w, t, pointsCount);
        }
    }

    private void iterateArea(PlanePoint2D[] points, int z, int w, int t) throws DataSourceException {
        Plane2D data = this.source.getPlane(z, t, w);
        for (int i = 0; i < points.length; ++i) {
            double value = data.getPixelValue((int)points[i].x1, (int)points[i].x2);
            this.notifyValue(value, z, w, t, points[i]);
        }
    }

    PointIterator(DataSink source, int sizeZ, int sizeT, int sizeC) {
        if (source == null) {
            throw new NullPointerException("No source.");
        }
        this.source = source;
        this.sizeZ = sizeZ;
        this.sizeC = sizeC;
        this.sizeT = sizeT;
        this.observers = new HashSet<PointIteratorObserver>();
    }

    void register(PointIteratorObserver observer) {
        if (observer == null) {
            throw new NullPointerException("No observer.");
        }
        this.observers.add(observer);
    }

    void remove(PointIteratorObserver observer) {
        if (observer == null) {
            throw new NullPointerException("No observer.");
        }
        this.observers.remove(observer);
    }

    void clearNotificationList() {
        this.observers.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void iterate(ROIShape shape, int w) throws DataSourceException {
        if (shape == null) {
            throw new NullPointerException("No shapes.");
        }
        if (w < 0 || w >= this.sizeC) {
            throw new NullPointerException("Channel not valid.");
        }
        this.notifyIterationStart();
        try {
            int z = shape.getZ();
            int t = shape.getT();
            ROIFigure selection2D = shape.getFigure();
            PlanePoint2D[] points = selection2D.getPoints();
            this.notifyPlaneStart(z, w, t, points.length);
            this.iterateArea(points, z, w, t);
            this.notifyPlaneEnd(z, w, t, points.length);
        }
        finally {
            this.notifyIterationEnd();
        }
    }
}

