/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.env.rnd.data;

import ome.model.core.Pixels;
import org.openmicroscopy.shoola.env.config.Registry;
import org.openmicroscopy.shoola.env.data.OmeroImageService;
import org.openmicroscopy.shoola.env.rnd.CachingService;
import org.openmicroscopy.shoola.env.rnd.data.BytesConverter;
import org.openmicroscopy.shoola.env.rnd.data.DataSourceException;
import org.openmicroscopy.shoola.env.rnd.data.PixelsCache;
import org.openmicroscopy.shoola.env.rnd.data.Plane2D;
import org.openmicroscopy.shoola.util.mem.ReadOnlyByteArray;

public class DataSink {
    static final String INT_8 = "int8";
    static final String UINT_8 = "uint8";
    static final String INT_16 = "int16";
    static final String UINT_16 = "uint16";
    static final String INT_32 = "int32";
    static final String UINT_32 = "uint32";
    static final String FLOAT = "float";
    static final String DOUBLE = "double";
    private Pixels source;
    private Registry context;
    private int bytesPerPixels;
    private BytesConverter strategy;
    private PixelsCache cache;

    public static DataSink makeNew(Pixels source, Registry context) {
        if (source == null) {
            throw new NullPointerException("No pixels.");
        }
        if (context == null) {
            throw new NullPointerException("No registry.");
        }
        PixelsCache cache = CachingService.createPixelsCache(source.getId(), source.getSizeX() * source.getSizeY());
        return new DataSink(source, context, cache);
    }

    private DataSink(Pixels source, Registry context, PixelsCache cache) {
        this.source = source;
        this.context = context;
        this.cache = cache;
        String type = source.getPixelsType().getValue();
        this.bytesPerPixels = this.getBytesPerPixels(type);
        this.strategy = BytesConverter.getConverter(type);
    }

    private int getBytesPerPixels(String v) {
        if (INT_8.equals(v) || UINT_8.equals(v)) {
            return 1;
        }
        if (INT_16.equals(v) || UINT_16.equals(v)) {
            return 2;
        }
        if (INT_32.equals(v) || UINT_32.equals(v) || FLOAT.equals(v)) {
            return 4;
        }
        if (DOUBLE.equals(v)) {
            return 8;
        }
        return -1;
    }

    private Integer linearize(int z, int w, int t) {
        int sizeZ = this.source.getSizeZ();
        int sizeC = this.source.getSizeC();
        if (z < 0 || sizeZ <= z) {
            throw new IllegalArgumentException("z out of range [0, " + sizeZ + "): " + z + ".");
        }
        if (w < 0 || sizeC <= w) {
            throw new IllegalArgumentException("w out of range [0, " + sizeC + "): " + w + ".");
        }
        if (t < 0 || this.source.getSizeT() <= t) {
            throw new IllegalArgumentException("t out of range [0, " + this.source.getSizeT() + "): " + t + ".");
        }
        return new Integer(sizeZ * sizeC * t + sizeZ * w + z);
    }

    private Plane2D createPlane(int z, int t, int w, BytesConverter strategy) throws DataSourceException {
        Integer planeIndex = this.linearize(z, w, t);
        Plane2D plane = this.cache.extract(planeIndex);
        if (plane != null) {
            return plane;
        }
        byte[] data = null;
        try {
            OmeroImageService service = this.context.getImageService();
            data = service.getPlane(this.source.getId(), z, t, w);
        }
        catch (Exception e) {
            String p = "(" + z + ", " + t + ", " + w + ")";
            new DataSourceException("Cannot retrieve the plane " + p, e);
        }
        ReadOnlyByteArray array = new ReadOnlyByteArray(data, 0, data.length);
        plane = new Plane2D(array, this.source.getSizeX(), this.bytesPerPixels, strategy);
        this.cache.add(planeIndex, plane);
        return plane;
    }

    public Plane2D getPlane(int z, int t, int w) throws DataSourceException {
        return this.createPlane(z, t, w, this.strategy);
    }

    public boolean isSame(long pixelsID) {
        return pixelsID == this.source.getId();
    }
}

