/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.env.rnd;

import java.awt.Color;
import java.awt.Point;
import java.awt.image.BufferedImage;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferInt;
import java.awt.image.DirectColorModel;
import java.awt.image.SampleModel;
import java.awt.image.SinglePixelPackedSampleModel;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.ejb.EJBException;
import ome.model.core.Pixels;
import ome.model.core.PixelsDimensions;
import ome.model.display.CodomainMapContext;
import ome.model.display.QuantumDef;
import ome.model.enums.Family;
import ome.model.enums.RenderingModel;
import omeis.providers.re.RenderingEngine;
import omeis.providers.re.data.PlaneDef;
import org.openmicroscopy.shoola.env.data.DSOutOfServiceException;
import org.openmicroscopy.shoola.env.data.model.ChannelMetadata;
import org.openmicroscopy.shoola.env.rnd.CachingService;
import org.openmicroscopy.shoola.env.rnd.ChannelBindingsProxy;
import org.openmicroscopy.shoola.env.rnd.RenderingControl;
import org.openmicroscopy.shoola.env.rnd.RenderingServiceException;
import org.openmicroscopy.shoola.env.rnd.RndProxyDef;
import org.openmicroscopy.shoola.env.rnd.XYCache;
import sun.awt.image.IntegerInterleavedRaster;

class RenderingControlProxy
implements RenderingControl {
    private static final String ERROR = "An error occured while trying to set the ";
    private final PixelsDimensions pixDims;
    private final List families;
    private final List models;
    private final Pixels pixs;
    private RenderingEngine servant;
    private int xyImgSize;
    private XYCache xyCache;
    private ChannelMetadata[] metadata;
    private RndProxyDef rndDef;

    private void handleException(Exception e, String message) throws RenderingServiceException, DSOutOfServiceException {
        if (e instanceof EJBException | e.getCause() instanceof IllegalStateException) {
            this.shutDown();
            throw new DSOutOfServiceException(message, e);
        }
        throw new RenderingServiceException(message, e);
    }

    private BufferedImage createImage(int sizeX, int sizeY, int[] buf) {
        DataBufferInt j2DBuf = new DataBufferInt(buf, sizeX * sizeY);
        SinglePixelPackedSampleModel sampleModel = new SinglePixelPackedSampleModel(3, sizeX, sizeY, sizeX, new int[]{0xFF0000, 65280, 255});
        IntegerInterleavedRaster raster = new IntegerInterleavedRaster((SampleModel)sampleModel, (DataBuffer)j2DBuf, new Point(0, 0));
        DirectColorModel colorModel = new DirectColorModel(32, 0xFF0000, 65280, 255);
        return new BufferedImage(colorModel, raster, false, null);
    }

    private BufferedImage getFromCache(PlaneDef pd) {
        BufferedImage img = null;
        if (pd.getSlice() == 0) {
            if (this.xyCache != null) {
                img = this.xyCache.extract(pd);
            } else if (this.xyImgSize != 0) {
                this.xyCache = CachingService.createXYCache(this.pixs.getId(), this.xyImgSize, this.getPixelsDimensionsZ(), this.getPixelsDimensionsT());
            }
        }
        return img;
    }

    private void cache(PlaneDef pd, BufferedImage img) {
        if (pd.getSlice() == 0 && this.xyCache != null) {
            this.xyCache.add(pd, img);
        }
    }

    private void invalidateCache() {
        if (this.xyCache != null) {
            this.xyCache.clear();
        }
    }

    private void checkBitResolution(int v) {
        switch (v) {
            case 1: 
            case 3: 
            case 7: 
            case 15: 
            case 31: 
            case 63: 
            case 127: 
            case 255: {
                return;
            }
        }
        throw new IllegalArgumentException("Bit resolution not supported.");
    }

    private void initialize() {
        this.rndDef.setDefaultZ(this.servant.getDefaultZ());
        this.rndDef.setDefaultT(this.servant.getDefaultT());
        QuantumDef qDef = this.servant.getQuantumDef();
        this.rndDef.setBitResolution(qDef.getBitResolution());
        this.rndDef.setColorModel(this.servant.getModel().getValue());
        this.rndDef.setCodomain(qDef.getCdStart(), qDef.getCdEnd());
        for (int i = 0; i < this.pixs.getSizeC(); ++i) {
            ChannelBindingsProxy cb = this.rndDef.getChannel(i);
            if (cb == null) {
                cb = new ChannelBindingsProxy();
                this.rndDef.setChannel(i, cb);
            }
            cb.setActive(this.servant.isActive(i));
            cb.setInterval(this.servant.getChannelWindowStart(i), this.servant.getChannelWindowEnd(i));
            cb.setQuantization(this.servant.getChannelFamily(i).getValue(), this.servant.getChannelCurveCoefficient(i), this.servant.getChannelNoiseReduction(i));
            cb.setRGBA(this.servant.getRGBA(i));
        }
    }

    private void tmpSolutionForNoiseReduction() {
        try {
            for (int i = 0; i < this.pixs.getSizeC(); ++i) {
                this.setQuantizationMap(i, this.getChannelFamily(i), this.getChannelCurveCoefficient(i), false);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    void setRenderingEngine(RenderingEngine servant) {
        if (servant == null) {
            return;
        }
        this.servant = servant;
        if (this.rndDef == null) {
            return;
        }
        servant.setDefaultZ(this.rndDef.getDefaultZ());
        servant.setDefaultT(this.rndDef.getDefaultT());
        servant.setQuantumStrategy(this.rndDef.getBitResolution());
        Iterator k = this.models.iterator();
        String value = this.rndDef.getColorModel();
        while (k.hasNext()) {
            RenderingModel model = (RenderingModel)k.next();
            if (!model.getValue().equals(value)) continue;
            servant.setModel(model);
        }
        servant.setCodomainInterval(this.rndDef.getCdStart(), this.rndDef.getCdEnd());
        for (int i = 0; i < this.pixs.getSizeC(); ++i) {
            ChannelBindingsProxy cb = this.rndDef.getChannel(i);
            servant.setActive(i, cb.isActive());
            servant.setChannelWindow(i, cb.getInputStart(), cb.getInputEnd());
            k = this.families.iterator();
            value = cb.getFamily();
            while (k.hasNext()) {
                Family family = (Family)k.next();
                if (!family.getValue().equals(value)) continue;
                servant.setQuantizationMap(i, family, cb.getCurveCoefficient(), cb.isNoiseReduction());
            }
            int[] rgba = cb.getRGBA();
            servant.setRGBA(rgba[0], rgba[1], rgba[2], rgba[3], rgba[4]);
        }
    }

    RenderingControlProxy(RenderingEngine re, PixelsDimensions pixDims, List m) {
        if (re == null) {
            throw new NullPointerException("No rendering engine.");
        }
        if (pixDims == null) {
            throw new NullPointerException("No pixels dimensions.");
        }
        this.servant = re;
        this.pixDims = pixDims;
        this.pixs = this.servant.getPixels();
        this.families = this.servant.getAvailableFamilies();
        this.models = this.servant.getAvailableModels();
        this.rndDef = new RndProxyDef();
        this.initialize();
        this.tmpSolutionForNoiseReduction();
        this.metadata = new ChannelMetadata[m.size()];
        Iterator i = m.iterator();
        while (i.hasNext()) {
            ChannelMetadata cm;
            this.metadata[cm.getIndex()] = cm = (ChannelMetadata)i.next();
        }
    }

    void resetCacheSize(int size) {
        if (this.xyCache != null) {
            this.xyCache.resetCacheSize(size);
        }
    }

    synchronized BufferedImage render(PlaneDef pDef) {
        int sizeX2;
        int sizeX1;
        if (pDef == null) {
            throw new IllegalArgumentException("Plane def cannot be null.");
        }
        BufferedImage img = this.getFromCache(pDef);
        if (img != null) {
            return img;
        }
        int[] buf = this.servant.renderAsPackedInt(pDef);
        switch (pDef.getSlice()) {
            case 2: {
                sizeX1 = this.pixs.getSizeX();
                sizeX2 = this.pixs.getSizeZ();
                break;
            }
            case 1: {
                sizeX1 = this.pixs.getSizeZ();
                sizeX2 = this.pixs.getSizeY();
                break;
            }
            default: {
                sizeX1 = this.pixs.getSizeX();
                sizeX2 = this.pixs.getSizeY();
                if (this.xyImgSize != 0) break;
                this.xyImgSize = buf.length;
            }
        }
        img = this.createImage(sizeX1, sizeX2, buf);
        this.cache(pDef, img);
        return img;
    }

    void shutDown() {
        try {
            this.servant.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setModel(String value) throws RenderingServiceException, DSOutOfServiceException {
        try {
            for (RenderingModel model : this.models) {
                if (!model.getValue().equals(value)) continue;
                this.servant.setModel(model);
                this.rndDef.setColorModel(value);
                this.invalidateCache();
            }
        }
        catch (Exception e) {
            this.rndDef.setColorModel(value);
            this.handleException(e, "An error occured while trying to set the model.");
        }
    }

    public String getModel() {
        return this.rndDef.getColorModel();
    }

    public int getDefaultZ() {
        return this.rndDef.getDefaultZ();
    }

    public int getDefaultT() {
        return this.rndDef.getDefaultT();
    }

    public void setDefaultZ(int z) throws RenderingServiceException, DSOutOfServiceException {
        try {
            this.servant.setDefaultZ(z);
            this.rndDef.setDefaultZ(z);
        }
        catch (Exception e) {
            this.rndDef.setDefaultZ(z);
            this.handleException(e, "An error occured while trying to set the default Z.");
        }
    }

    public void setDefaultT(int t) throws RenderingServiceException, DSOutOfServiceException {
        try {
            this.servant.setDefaultT(t);
            this.rndDef.setDefaultT(t);
        }
        catch (Exception e) {
            this.rndDef.setDefaultT(t);
            this.handleException(e, "An error occured while trying to set the default T.");
        }
    }

    public void setQuantumStrategy(int bitResolution) throws RenderingServiceException, DSOutOfServiceException {
        try {
            this.checkBitResolution(bitResolution);
            this.servant.setQuantumStrategy(bitResolution);
            this.rndDef.setBitResolution(bitResolution);
            this.invalidateCache();
        }
        catch (Exception e) {
            this.rndDef.setBitResolution(bitResolution);
            this.handleException(e, "An error occured while trying to set the bit beth.");
        }
    }

    public void setCodomainInterval(int start, int end) throws RenderingServiceException, DSOutOfServiceException {
        try {
            this.servant.setCodomainInterval(start, end);
            this.rndDef.setCodomain(start, end);
            this.invalidateCache();
        }
        catch (Exception e) {
            this.rndDef.setCodomain(start, end);
            this.handleException(e, "An error occured while trying to set the codomain interval.");
        }
    }

    public void setQuantizationMap(int w, String value, double coefficient, boolean noiseReduction) throws RenderingServiceException, DSOutOfServiceException {
        try {
            List list = this.servant.getAvailableFamilies();
            for (Family family : list) {
                if (!family.getValue().equals(value)) continue;
                this.servant.setQuantizationMap(w, family, coefficient, noiseReduction);
                this.rndDef.getChannel(w).setQuantization(value, coefficient, noiseReduction);
                this.invalidateCache();
            }
        }
        catch (Exception e) {
            this.rndDef.getChannel(w).setQuantization(value, coefficient, noiseReduction);
            this.handleException(e, "An error occured while trying to set the quantization map.");
        }
    }

    public String getChannelFamily(int w) {
        return this.rndDef.getChannel(w).getFamily();
    }

    public boolean getChannelNoiseReduction(int w) {
        return this.rndDef.getChannel(w).isNoiseReduction();
    }

    public double getChannelCurveCoefficient(int w) {
        return this.rndDef.getChannel(w).getCurveCoefficient();
    }

    public void setChannelWindow(int w, double start, double end) throws RenderingServiceException, DSOutOfServiceException {
        try {
            this.servant.setChannelWindow(w, start, end);
            this.rndDef.getChannel(w).setInterval(start, end);
            this.invalidateCache();
        }
        catch (Exception e) {
            this.rndDef.getChannel(w).setInterval(start, end);
            this.handleException(e, "An error occured while trying to set the input channel for: " + w + ".");
        }
    }

    public double getChannelWindowStart(int w) {
        return this.rndDef.getChannel(w).getInputStart();
    }

    public double getChannelWindowEnd(int w) {
        return this.rndDef.getChannel(w).getInputEnd();
    }

    public void setRGBA(int w, Color c) throws RenderingServiceException, DSOutOfServiceException {
        try {
            this.servant.setRGBA(w, c.getRed(), c.getGreen(), c.getBlue(), c.getAlpha());
            this.rndDef.getChannel(w).setRGBA(c.getRed(), c.getGreen(), c.getBlue(), c.getAlpha());
            this.invalidateCache();
        }
        catch (Exception e) {
            this.handleException(e, "An error occured while trying to set the color for: " + w + ".");
        }
    }

    public Color getRGBA(int w) {
        int[] rgba = this.rndDef.getChannel(w).getRGBA();
        return new Color(rgba[0], rgba[1], rgba[2], rgba[3]);
    }

    public void setActive(int w, boolean active) throws RenderingServiceException, DSOutOfServiceException {
        try {
            this.servant.setActive(w, active);
            this.rndDef.getChannel(w).setActive(active);
            this.invalidateCache();
        }
        catch (Exception e) {
            this.handleException(e, "An error occured while trying to set the active channel for: " + w + ".");
        }
    }

    public boolean isActive(int w) {
        return this.rndDef.getChannel(w).isActive();
    }

    public void addCodomainMap(CodomainMapContext mapCtx) throws RenderingServiceException, DSOutOfServiceException {
        this.invalidateCache();
    }

    public void updateCodomainMap(CodomainMapContext mapCtx) throws RenderingServiceException, DSOutOfServiceException {
        this.invalidateCache();
    }

    public void removeCodomainMap(CodomainMapContext mapCtx) throws RenderingServiceException, DSOutOfServiceException {
        this.invalidateCache();
    }

    public List getCodomainMaps() {
        return new ArrayList(0);
    }

    public void saveCurrentSettings() throws RenderingServiceException, DSOutOfServiceException {
        try {
            this.servant.saveCurrentSettings();
        }
        catch (Exception e) {
            this.handleException(e, "An error occured while trying to set the save current settings.");
        }
    }

    public void resetDefaults() throws RenderingServiceException, DSOutOfServiceException {
        try {
            this.servant.resetDefaults();
            this.initialize();
            this.tmpSolutionForNoiseReduction();
        }
        catch (Exception e) {
            this.handleException(e, "An error occured while trying to set the default settings.");
        }
    }

    public float getPixelsSizeX() {
        if (this.pixDims.getSizeX() == null) {
            return 1.0f;
        }
        return this.pixDims.getSizeX().floatValue();
    }

    public float getPixelsSizeY() {
        if (this.pixDims.getSizeY() == null) {
            return 1.0f;
        }
        return this.pixDims.getSizeY().floatValue();
    }

    public float getPixelsSizeZ() {
        if (this.pixDims.getSizeY() == null) {
            return 1.0f;
        }
        return this.pixDims.getSizeZ().floatValue();
    }

    public int getPixelsDimensionsX() {
        return this.pixs.getSizeX();
    }

    public int getPixelsDimensionsY() {
        return this.pixs.getSizeY();
    }

    public int getPixelsDimensionsZ() {
        return this.pixs.getSizeZ();
    }

    public int getPixelsDimensionsT() {
        return this.pixs.getSizeT();
    }

    public int getPixelsDimensionsC() {
        return this.pixs.getSizeC();
    }

    public List getFamilies() {
        ArrayList<String> l = new ArrayList<String>(this.families.size());
        Iterator i = this.families.iterator();
        while (i.hasNext()) {
            l.add(((Family)i.next()).getValue());
        }
        return l;
    }

    public ChannelMetadata getChannelData(int w) {
        return this.metadata[w];
    }

    public ChannelMetadata[] getChannelData() {
        return this.metadata;
    }

    public int getCodomainStart() {
        return this.rndDef.getCdStart();
    }

    public int getCodomainEnd() {
        return this.rndDef.getCdEnd();
    }

    public int getBitResolution() {
        return this.rndDef.getBitResolution();
    }

    public boolean hasActiveChannelBlue() {
        for (int i = 0; i < this.getPixelsDimensionsC(); ++i) {
            int[] rgba;
            if (!this.isActive(i) || (rgba = this.rndDef.getChannel(i).getRGBA())[0] != 0 || rgba[1] != 0 || rgba[2] != 255) continue;
            return true;
        }
        return false;
    }

    public boolean hasActiveChannelGreen() {
        for (int i = 0; i < this.getPixelsDimensionsC(); ++i) {
            int[] rgba;
            if (!this.isActive(i) || (rgba = this.rndDef.getChannel(i).getRGBA())[0] != 0 || rgba[1] != 255 || rgba[2] != 0) continue;
            return true;
        }
        return false;
    }

    public boolean hasActiveChannelRed() {
        for (int i = 0; i < this.getPixelsDimensionsC(); ++i) {
            int[] rgba;
            if (!this.isActive(i) || (rgba = this.rndDef.getChannel(i).getRGBA())[0] != 255 || rgba[1] != 0 || rgba[2] != 0) continue;
            return true;
        }
        return false;
    }

    public boolean isChannelRed(int index) {
        if (index < 0 || index > this.getPixelsDimensionsC()) {
            return false;
        }
        int[] rgba = this.rndDef.getChannel(index).getRGBA();
        return rgba[0] == 255 && rgba[1] == 0 && rgba[2] == 0;
    }

    public boolean isChannelBlue(int index) {
        if (index < 0 || index > this.getPixelsDimensionsC()) {
            return false;
        }
        int[] rgba = this.rndDef.getChannel(index).getRGBA();
        return rgba[0] == 0 && rgba[1] == 0 && rgba[2] == 255;
    }

    public boolean isChannelGreen(int index) {
        if (index < 0 || index > this.getPixelsDimensionsC()) {
            return false;
        }
        int[] rgba = this.rndDef.getChannel(index).getRGBA();
        return rgba[0] == 0 && rgba[1] == 255 && rgba[2] == 0;
    }
}

