/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.env.rnd;

import java.awt.image.BufferedImage;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import ome.model.core.Pixels;
import ome.model.core.PixelsDimensions;
import omeis.providers.re.RenderingEngine;
import omeis.providers.re.data.PlaneDef;
import org.openmicroscopy.shoola.env.Container;
import org.openmicroscopy.shoola.env.config.Registry;
import org.openmicroscopy.shoola.env.rnd.RenderingControl;
import org.openmicroscopy.shoola.env.rnd.RenderingControlProxy;
import org.openmicroscopy.shoola.env.rnd.data.DataSink;

public class PixelsServicesFactory {
    private static PixelsServicesFactory singleton;
    private static Registry registry;
    private HashMap rndSvcProxies = new HashMap();
    private DataSink pixelsSource;

    public static PixelsServicesFactory getInstance(Container c) {
        if (c == null) {
            throw new NullPointerException();
        }
        if (singleton == null) {
            registry = c.getRegistry();
            singleton = new PixelsServicesFactory();
        }
        return singleton;
    }

    public static RenderingControl createRenderingControl(Registry context, RenderingEngine re, PixelsDimensions pixDims, List metadata) {
        if (!context.equals(registry)) {
            throw new IllegalArgumentException("Not allow to access method.");
        }
        return singleton.makeNew(re, pixDims, metadata);
    }

    public static void resetRenderingControl(Registry context, long pixelsID, RenderingEngine re) {
        if (!registry.equals(context)) {
            throw new IllegalArgumentException("Not allow to access method.");
        }
        RenderingControlProxy proxy = (RenderingControlProxy)PixelsServicesFactory.singleton.rndSvcProxies.get(new Long(pixelsID));
        if (proxy != null) {
            proxy.setRenderingEngine(re);
        }
    }

    public static void shutDownRenderingControl(Registry context, long pixelsID) {
        if (!context.equals(registry)) {
            throw new IllegalArgumentException("Not allow to access method.");
        }
        RenderingControl proxy = (RenderingControl)PixelsServicesFactory.singleton.rndSvcProxies.get(new Long(pixelsID));
        if (proxy != null) {
            PixelsServicesFactory.singleton.rndSvcProxies.remove(new Long(pixelsID));
        }
    }

    public static void shutDownRenderingControls(Registry context) {
        if (!context.equals(registry)) {
            throw new IllegalArgumentException("Not allow to access method.");
        }
        Iterator i = PixelsServicesFactory.singleton.rndSvcProxies.keySet().iterator();
        while (i.hasNext()) {
            ((RenderingControlProxy)PixelsServicesFactory.singleton.rndSvcProxies.get(i.next())).shutDown();
        }
        PixelsServicesFactory.singleton.rndSvcProxies.clear();
    }

    public static RenderingControl getRenderingControl(Registry context, Long pixelsID) {
        if (!context.equals(registry)) {
            throw new IllegalArgumentException("Not allow to access method.");
        }
        return (RenderingControl)PixelsServicesFactory.singleton.rndSvcProxies.get(pixelsID);
    }

    public static DataSink createDataSink(Pixels pixels) {
        if (pixels == null) {
            throw new IllegalArgumentException("Pixels cannot be null.");
        }
        if (PixelsServicesFactory.singleton.pixelsSource != null && PixelsServicesFactory.singleton.pixelsSource.isSame(pixels.getId())) {
            return PixelsServicesFactory.singleton.pixelsSource;
        }
        PixelsServicesFactory.singleton.pixelsSource = DataSink.makeNew(pixels, registry);
        return PixelsServicesFactory.singleton.pixelsSource;
    }

    public static BufferedImage render(Registry context, Long pixelsID, PlaneDef pDef) {
        if (!context.equals(registry)) {
            throw new IllegalArgumentException("Not allow to access method.");
        }
        RenderingControlProxy proxy = (RenderingControlProxy)PixelsServicesFactory.singleton.rndSvcProxies.get(pixelsID);
        if (proxy == null) {
            throw new RuntimeException("No rendering service initialized for the specified pixels set.");
        }
        return proxy.render(pDef);
    }

    private PixelsServicesFactory() {
    }

    private RenderingControl makeNew(RenderingEngine re, PixelsDimensions pixDims, List metadata) {
        if (singleton == null) {
            throw new NullPointerException();
        }
        Long id = re.getPixels().getId();
        RenderingControl rnd = PixelsServicesFactory.getRenderingControl(registry, id);
        if (rnd != null) {
            return rnd;
        }
        int l = PixelsServicesFactory.singleton.rndSvcProxies.size();
        rnd = new RenderingControlProxy(re, pixDims, metadata);
        Iterator i = PixelsServicesFactory.singleton.rndSvcProxies.keySet().iterator();
        while (i.hasNext()) {
            RenderingControlProxy proxy = (RenderingControlProxy)PixelsServicesFactory.singleton.rndSvcProxies.get(i.next());
            proxy.resetCacheSize(l);
        }
        PixelsServicesFactory.singleton.rndSvcProxies.put(id, rnd);
        return rnd;
    }
}

