/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.env.rnd;

import java.lang.management.ManagementFactory;
import java.lang.management.MemoryUsage;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.openmicroscopy.shoola.env.Container;
import org.openmicroscopy.shoola.env.config.Registry;
import org.openmicroscopy.shoola.env.rnd.NavigationHistory;
import org.openmicroscopy.shoola.env.rnd.XYCache;
import org.openmicroscopy.shoola.env.rnd.data.PixelsCache;

public class CachingService {
    private static CachingService singleton;
    private static Registry registry;
    private static int maxSize;
    private Map<Long, PixelsCache> pixelsCache;
    private Map<Long, XYCache> imageCache;

    public static CachingService getInstance(Container c) {
        if (c == null) {
            throw new NullPointerException();
        }
        if (singleton == null) {
            registry = c.getRegistry();
            singleton = new CachingService();
        }
        return singleton;
    }

    public static XYCache createXYCache(long pixelsID, int imageSize, int sizeZ, int sizeT) {
        XYCache cache = CachingService.singleton.imageCache.get(pixelsID);
        if (cache != null) {
            return cache;
        }
        int cacheSize = CachingService.getCacheSize();
        NavigationHistory nh = new NavigationHistory(cacheSize / imageSize, sizeZ, sizeT);
        cache = new XYCache(cacheSize, imageSize, nh);
        CachingService.singleton.imageCache.put(pixelsID, cache);
        return cache;
    }

    public static PixelsCache createPixelsCache(long pixelsID, int planeSize) {
        PixelsCache cache = CachingService.singleton.pixelsCache.get(pixelsID);
        if (cache != null) {
            return cache;
        }
        cache = new PixelsCache(CachingService.getCacheSize(), planeSize);
        CachingService.singleton.pixelsCache.put(pixelsID, cache);
        return cache;
    }

    private static int getCacheSize() {
        int n = CachingService.singleton.pixelsCache.size();
        int m = CachingService.singleton.imageCache.size();
        int sizeCache = 0;
        if (n == 0 && m == 0) {
            return maxSize * 1024 * 1024;
        }
        if (n == 0 && m > 0) {
            sizeCache = maxSize / m * 1024 * 1024;
            Iterator<Long> i = CachingService.singleton.imageCache.keySet().iterator();
            while (i.hasNext()) {
                XYCache cache = CachingService.singleton.imageCache.get(i.next());
                cache.resetCacheSize(sizeCache);
            }
            return sizeCache;
        }
        if (m == 0 && n > 0) {
            sizeCache = maxSize / n * 1024 * 1024;
            Iterator<Long> i = CachingService.singleton.pixelsCache.keySet().iterator();
            while (i.hasNext()) {
                PixelsCache cache = CachingService.singleton.pixelsCache.get(i.next());
                cache.resetCacheSize(sizeCache);
            }
            return sizeCache;
        }
        sizeCache = maxSize / (m + n) * 1024 * 1024;
        Iterator<Long> i = CachingService.singleton.pixelsCache.keySet().iterator();
        while (i.hasNext()) {
            PixelsCache cache = CachingService.singleton.pixelsCache.get(i.next());
            cache.resetCacheSize(sizeCache);
        }
        i = CachingService.singleton.imageCache.keySet().iterator();
        while (i.hasNext()) {
            XYCache xyCache = CachingService.singleton.imageCache.get(i.next());
            xyCache.resetCacheSize(sizeCache);
        }
        return sizeCache;
    }

    private CachingService() {
        MemoryUsage usage = ManagementFactory.getMemoryMXBean().getNonHeapMemoryUsage();
        maxSize = (int)(0.6 * (double)usage.getMax()) / 0x100000;
        this.pixelsCache = new HashMap<Long, PixelsCache>();
        this.imageCache = new HashMap<Long, XYCache>();
    }
}

