/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.env.log;

import java.io.File;
import java.io.FileInputStream;
import java.util.Properties;
import org.openmicroscopy.shoola.env.Container;
import org.openmicroscopy.shoola.env.config.Registry;
import org.openmicroscopy.shoola.env.log.LogMessage;
import org.openmicroscopy.shoola.env.log.Logger;
import org.openmicroscopy.shoola.env.log.LoggerImpl;

public class LoggerFactory {
    public static final String LOG_CONFIG_FILE = "log4j.config";

    public static Logger makeNew(Container c) {
        if (c == null) {
            return null;
        }
        Registry reg = c.getRegistry();
        Boolean isLoggingOn = (Boolean)reg.lookup("/services/LOG/on");
        if (!isLoggingOn.booleanValue()) {
            return LoggerFactory.makeNoOpLogger();
        }
        Properties config = LoggerFactory.loadConfig(c.resolveConfigFile(LOG_CONFIG_FILE));
        if (config == null) {
            return LoggerFactory.makeNoOpLogger();
        }
        String logDirName = (String)reg.lookup("/services/LOG/dir");
        String logFileName = (String)reg.lookup("/services/LOG/file");
        File logDir = new File(c.getHomeDir(), logDirName);
        logDir.mkdir();
        File logFile = logDir.isDirectory() ? new File(logDir, logFileName) : new File(c.getHomeDir(), logFileName);
        return new LoggerImpl(config, logFile.getAbsolutePath());
    }

    private static Logger makeNoOpLogger() {
        return new Logger(){

            public void debug(Object c, String logMsg) {
            }

            public void debug(Object c, LogMessage msg) {
            }

            public void error(Object c, String logMsg) {
            }

            public void error(Object c, LogMessage msg) {
            }

            public void fatal(Object c, String logMsg) {
            }

            public void fatal(Object c, LogMessage msg) {
            }

            public void info(Object c, String logMsg) {
            }

            public void info(Object c, LogMessage msg) {
            }

            public void warn(Object c, String logMsg) {
            }

            public void warn(Object c, LogMessage msg) {
            }
        };
    }

    private static Properties loadConfig(String file) {
        Properties config = new Properties();
        try {
            FileInputStream fis = new FileInputStream(file);
            config.load(fis);
        }
        catch (Exception e) {
            return null;
        }
        return config;
    }
}

