/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.env.init;

import org.openmicroscopy.shoola.env.config.Registry;
import org.openmicroscopy.shoola.env.data.login.LoginConfig;
import org.openmicroscopy.shoola.env.data.login.LoginService;
import org.openmicroscopy.shoola.env.data.login.UserCredentials;
import org.openmicroscopy.shoola.env.init.InitializationListener;
import org.openmicroscopy.shoola.env.init.InitializationTask;
import org.openmicroscopy.shoola.env.init.StartupException;
import org.openmicroscopy.shoola.env.ui.SplashScreen;
import org.openmicroscopy.shoola.env.ui.UIFactory;
import org.openmicroscopy.shoola.env.ui.UserNotifier;

public final class SplashScreenInit
extends InitializationTask
implements InitializationListener {
    private SplashScreen splashScreen;

    SplashScreenInit() {
    }

    String getName() {
        return "";
    }

    void configure() {
        this.initializer.register(this);
        this.splashScreen = UIFactory.makeSplashScreen(this.container);
        this.splashScreen.open();
    }

    void execute() throws StartupException {
    }

    void rollback() {
    }

    public void onStart(int totalTasks) {
        this.splashScreen.setTotalTasks(totalTasks);
    }

    public void onExecute(String taskName) {
        this.splashScreen.updateProgress(taskName);
    }

    public void onEnd() {
        this.splashScreen.updateProgress("");
        Registry reg = this.container.getRegistry();
        LoginConfig cfg = new LoginConfig(reg);
        int max = cfg.getMaxRetry();
        LoginService loginSvc = (LoginService)reg.lookup("/services/Login");
        boolean succeeded = false;
        int index = max;
        while (0 < max--) {
            UserCredentials uc = this.splashScreen.getUserCredentials(max == index - 1);
            succeeded = loginSvc.login(uc);
            if (!succeeded) continue;
            reg.bind("/user/credentials", uc);
            break;
        }
        if (!succeeded) {
            UserNotifier un = UIFactory.makeUserNotifier(this.container);
            un.notifyError("Login Failure", "A valid connection to the OMERO server couldn't be established. The application will exit.");
            this.container.exit();
        }
        this.splashScreen.close();
    }
}

