/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.env.data.views.calls;

import java.awt.image.BufferedImage;
import java.util.Set;
import org.openmicroscopy.shoola.env.data.OmeroImageService;
import org.openmicroscopy.shoola.env.data.model.ThumbnailData;
import org.openmicroscopy.shoola.env.data.views.BatchCall;
import org.openmicroscopy.shoola.env.data.views.BatchCallTree;
import org.openmicroscopy.shoola.env.rnd.RenderingServiceException;
import org.openmicroscopy.shoola.util.image.geom.Factory;
import pojos.ImageData;
import pojos.PixelsData;

public class ThumbnailLoader
extends BatchCallTree {
    private ImageData[] images;
    private int maxWidth;
    private int maxHeight;
    private Object currentThumbnail;
    private boolean pixelsCall;
    private long pixelsID;
    private OmeroImageService service;

    private void loadThumbail(int index) {
        PixelsData pxd = this.images[index].getDefaultPixels();
        BufferedImage thumbPix = null;
        if (pxd == null) {
            thumbPix = Factory.createDefaultThumbnail(this.maxWidth, this.maxHeight);
        } else {
            double ratio;
            int sizeX = this.maxWidth;
            int sizeY = this.maxHeight;
            double pixSizeX = pxd.getSizeX();
            double pixSizeY = pxd.getSizeY();
            if (pixSizeX < (double)this.maxWidth) {
                sizeX = (int)pixSizeX;
            }
            if (pixSizeY < (double)this.maxHeight) {
                sizeY = (int)pixSizeY;
            }
            if ((ratio = pixSizeX / pixSizeY) < 1.0) {
                sizeX = (int)((double)sizeX * ratio);
            } else if (ratio > 1.0 && ratio != 0.0) {
                sizeY = (int)((double)sizeY * (1.0 / ratio));
            }
            try {
                thumbPix = this.service.getThumbnail(pxd.getId(), sizeX, sizeY);
            }
            catch (RenderingServiceException e) {
                this.context.getLogger().error((Object)this, "Cannot retrieve thumbnail: " + e.getExtendedMessage());
            }
            if (thumbPix == null) {
                thumbPix = Factory.createDefaultThumbnail(sizeX, sizeY);
            }
        }
        this.currentThumbnail = new ThumbnailData(this.images[index].getId(), thumbPix);
    }

    private BatchCall makeBatchCall() {
        return new BatchCall("Loading thumbnail for: " + this.pixelsID){

            public void doCall() throws Exception {
                BufferedImage thumbPix = null;
                try {
                    thumbPix = ThumbnailLoader.this.service.getThumbnail(ThumbnailLoader.this.pixelsID, ThumbnailLoader.this.maxWidth, ThumbnailLoader.this.maxHeight);
                }
                catch (RenderingServiceException e) {
                    ThumbnailLoader.this.context.getLogger().error((Object)this, "Cannot retrieve thumbnail from ID: " + e.getExtendedMessage());
                }
                if (thumbPix == null) {
                    thumbPix = Factory.createDefaultThumbnail(ThumbnailLoader.this.maxWidth, ThumbnailLoader.this.maxHeight);
                }
                ThumbnailLoader.this.currentThumbnail = thumbPix;
            }
        };
    }

    protected void buildTree() {
        if (this.pixelsCall) {
            this.add(this.makeBatchCall());
            return;
        }
        int i = 0;
        while (i < this.images.length) {
            String description = "Loading thumbnail: " + this.images[i].getName();
            final int index = i++;
            this.add(new BatchCall(description){

                public void doCall() {
                    ThumbnailLoader.this.loadThumbail(index);
                }
            });
        }
    }

    protected Object getPartialResult() {
        return this.currentThumbnail;
    }

    protected Object getResult() {
        return null;
    }

    public ThumbnailLoader(Set imgs, int maxWidth, int maxHeight) {
        if (imgs == null) {
            throw new NullPointerException("No images.");
        }
        if (maxWidth <= 0) {
            throw new IllegalArgumentException("Non-positive width: " + maxWidth + ".");
        }
        if (maxHeight <= 0) {
            throw new IllegalArgumentException("Non-positive height: " + maxHeight + ".");
        }
        this.images = imgs.toArray(new ImageData[0]);
        this.maxWidth = maxWidth;
        this.maxHeight = maxHeight;
        this.service = this.context.getImageService();
    }

    public ThumbnailLoader(ImageData image, int maxWidth, int maxHeight) {
        if (image == null) {
            throw new IllegalArgumentException("No image.");
        }
        if (maxWidth <= 0) {
            throw new IllegalArgumentException("Non-positive width: " + maxWidth + ".");
        }
        if (maxHeight <= 0) {
            throw new IllegalArgumentException("Non-positive height: " + maxHeight + ".");
        }
        this.images = new ImageData[1];
        this.images[0] = image;
        this.maxWidth = maxWidth;
        this.maxHeight = maxHeight;
        this.service = this.context.getImageService();
    }

    public ThumbnailLoader(long pixelsID, int maxWidth, int maxHeight) {
        if (maxWidth <= 0) {
            throw new IllegalArgumentException("Non-positive id: " + pixelsID + ".");
        }
        if (maxWidth <= 0) {
            throw new IllegalArgumentException("Non-positive width: " + maxWidth + ".");
        }
        if (maxHeight <= 0) {
            throw new IllegalArgumentException("Non-positive height: " + maxHeight + ".");
        }
        this.pixelsCall = true;
        this.maxWidth = maxWidth;
        this.maxHeight = maxHeight;
        this.pixelsID = pixelsID;
        this.service = this.context.getImageService();
    }
}

