/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.env.data.views.calls;

import org.openmicroscopy.shoola.env.data.DSOutOfServiceException;
import org.openmicroscopy.shoola.env.data.OmeroImageService;
import org.openmicroscopy.shoola.env.data.views.BatchCall;
import org.openmicroscopy.shoola.env.data.views.BatchCallTree;

public class RenderingControlLoader
extends BatchCallTree {
    private Object result;
    private BatchCall loadCall;

    private BatchCall makeBatchCall(final long pixelsID, final boolean reload) {
        return new BatchCall("Loading rendering control: "){

            public void doCall() throws Exception {
                try {
                    OmeroImageService rds = RenderingControlLoader.this.context.getImageService();
                    if (reload) {
                        RenderingControlLoader.this.result = Boolean.TRUE;
                        rds.reloadRenderingService(pixelsID);
                    } else {
                        RenderingControlLoader.this.result = rds.loadRenderingControl(pixelsID);
                    }
                }
                catch (Exception e) {
                    throw new DSOutOfServiceException("Cannot start the rendering engine for pixelsID " + pixelsID, e);
                }
            }
        };
    }

    protected void buildTree() {
        this.add(this.loadCall);
    }

    protected Object getResult() {
        return this.result;
    }

    public RenderingControlLoader(long pixelsID, boolean reload) {
        if (pixelsID < 0L) {
            throw new IllegalArgumentException("ID not valid.");
        }
        this.loadCall = this.makeBatchCall(pixelsID, reload);
    }
}

