/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.env.data.views.calls;

import java.util.Set;
import org.openmicroscopy.shoola.env.data.OmeroDataService;
import org.openmicroscopy.shoola.env.data.views.BatchCall;
import org.openmicroscopy.shoola.env.data.views.BatchCallTree;
import pojos.CategoryData;
import pojos.DatasetData;
import pojos.ExperimenterData;
import pojos.GroupData;
import pojos.ImageData;

public class ImagesLoader
extends BatchCallTree {
    private Set results;
    private BatchCall loadCall;

    private void checkRootLevel(Class level) {
        if (level.equals(ExperimenterData.class) || level.equals(GroupData.class)) {
            return;
        }
        throw new IllegalArgumentException("Root level not supported");
    }

    private BatchCall makeBatchCall(final long userID) {
        return new BatchCall("Loading user's images: "){

            public void doCall() throws Exception {
                OmeroDataService os = ImagesLoader.this.context.getDataService();
                ImagesLoader.this.results = os.getExperimenterImages(userID);
            }
        };
    }

    private BatchCall makeImagesInContainerBatchCall(final Class nodeType, final Set nodeIDs, final Class rootLevel, final long rootLevelID) {
        return new BatchCall("Loading container tree: "){

            public void doCall() throws Exception {
                OmeroDataService os = ImagesLoader.this.context.getDataService();
                ImagesLoader.this.results = os.getImages(nodeType, nodeIDs, rootLevel, rootLevelID);
            }
        };
    }

    protected void buildTree() {
        this.add(this.loadCall);
    }

    protected Object getResult() {
        return this.results;
    }

    public ImagesLoader(long rootLevelID) {
        this.loadCall = this.makeBatchCall(rootLevelID);
    }

    public ImagesLoader(Class nodeType, Set nodeIDs, Class rootLevel, long rootLevelID) {
        if (nodeType == null) {
            throw new IllegalArgumentException("No node type.");
        }
        if (nodeIDs == null || nodeIDs.size() == 0) {
            throw new IllegalArgumentException("Collection of node ID not valid.");
        }
        try {
            nodeIDs.toArray(new Long[0]);
        }
        catch (ArrayStoreException ase) {
            throw new IllegalArgumentException("nodeIDs only contains Long.");
        }
        this.checkRootLevel(rootLevel);
        if (!(nodeType.equals(DatasetData.class) || nodeType.equals(CategoryData.class) || nodeType.equals(ImageData.class))) {
            throw new IllegalArgumentException("Unsupported type: " + nodeType);
        }
        this.loadCall = this.makeImagesInContainerBatchCall(nodeType, nodeIDs, rootLevel, rootLevelID);
    }
}

