/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.env.data.views.calls;

import java.util.HashSet;
import java.util.Set;
import org.openmicroscopy.shoola.env.data.OmeroDataService;
import org.openmicroscopy.shoola.env.data.views.BatchCall;
import org.openmicroscopy.shoola.env.data.views.BatchCallTree;
import pojos.CategoryData;
import pojos.CategoryGroupData;
import pojos.DatasetData;
import pojos.ExperimenterData;
import pojos.GroupData;
import pojos.ProjectData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HierarchyLoader
extends BatchCallTree {
    private Class rootLevel;
    private long rootLevelID;
    private Set rootNodes;
    private BatchCall loadCall;

    private void validate(Class rootNodeType, Set<Long> rootNodeIDs) {
        if (rootNodeType == null) {
            throw new IllegalArgumentException("No root node type.");
        }
        if (rootNodeIDs == null && rootNodeIDs.size() == 0) {
            throw new IllegalArgumentException("No root node ids.");
        }
        if (!(rootNodeType.equals(ProjectData.class) || rootNodeType.equals(DatasetData.class) || rootNodeType.equals(CategoryGroupData.class) || rootNodeType.equals(CategoryData.class))) {
            throw new IllegalArgumentException("Unsupported type: " + rootNodeType);
        }
        this.loadCall = this.makeBatchCall(rootNodeType, rootNodeIDs);
    }

    private void checkRootLevel(Class level) {
        if (level.equals(ExperimenterData.class) || level.equals(GroupData.class)) {
            return;
        }
        throw new IllegalArgumentException("Root level not supported");
    }

    private BatchCall makeBatchCall(final Class rootNodeType, final Set rootNodeIDs) {
        return new BatchCall("Loading container tree: "){

            public void doCall() throws Exception {
                OmeroDataService os = HierarchyLoader.this.context.getDataService();
                HierarchyLoader.this.rootNodes = os.loadContainerHierarchy(rootNodeType, rootNodeIDs, true, HierarchyLoader.this.rootLevel, HierarchyLoader.this.rootLevelID);
            }
        };
    }

    @Override
    protected void buildTree() {
        this.add(this.loadCall);
    }

    @Override
    protected Object getResult() {
        return this.rootNodes;
    }

    public HierarchyLoader(Class rootNodeType, long rootNodeID, Class rootLevel, long rootLevelID) {
        this.checkRootLevel(rootLevel);
        this.rootLevel = rootLevel;
        this.rootLevelID = rootLevelID;
        HashSet<Long> set = new HashSet<Long>(1);
        set.add(new Long(rootNodeID));
        this.validate(rootNodeType, set);
    }

    public HierarchyLoader(Class rootNodeType, Set<Long> rootNodeIDs, Class rootLevel, long rootLevelID) {
        this.checkRootLevel(rootLevel);
        this.rootLevel = rootLevel;
        this.rootLevelID = rootLevelID;
        this.validate(rootNodeType, rootNodeIDs);
    }
}

