/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.env.data.views.calls;

import java.util.Set;
import org.openmicroscopy.shoola.env.data.OmeroDataService;
import org.openmicroscopy.shoola.env.data.views.BatchCall;
import org.openmicroscopy.shoola.env.data.views.BatchCallTree;
import pojos.CategoryGroupData;
import pojos.ExperimenterData;
import pojos.GroupData;
import pojos.ProjectData;

public class HierarchyFinder
extends BatchCallTree {
    private Set rootNodes;
    private BatchCall findCall;

    private void checkRootLevel(Class level) {
        if (level.equals(ExperimenterData.class) || level.equals(GroupData.class)) {
            return;
        }
        throw new IllegalArgumentException("Root level not supported");
    }

    private BatchCall makeBatchCall(final Class hierarchyRootNodeType, final Set ids, final Class rootLevel, final long rootLevelID) {
        return new BatchCall("Searching Container hierarchy"){

            public void doCall() throws Exception {
                OmeroDataService os = HierarchyFinder.this.context.getDataService();
                HierarchyFinder.this.rootNodes = os.findContainerHierarchy(hierarchyRootNodeType, ids, rootLevel, rootLevelID);
            }
        };
    }

    protected void buildTree() {
        this.add(this.findCall);
    }

    protected Object getResult() {
        return this.rootNodes;
    }

    public HierarchyFinder(Class hierarchyRootNodeType, Set ids, Class rootLevel, long rootLevelID) {
        if (ids == null) {
            throw new IllegalArgumentException("No images.");
        }
        if (hierarchyRootNodeType == null) {
            throw new NullPointerException("No root node type.");
        }
        try {
            ids.toArray(new Long[0]);
        }
        catch (ArrayStoreException ase) {
            throw new IllegalArgumentException("ids only contain Long.");
        }
        this.checkRootLevel(rootLevel);
        if (rootLevelID < 0L) {
            throw new IllegalArgumentException("Root level ID not valid.");
        }
        if (!hierarchyRootNodeType.equals(ProjectData.class) && !hierarchyRootNodeType.equals(CategoryGroupData.class)) {
            throw new IllegalArgumentException("Unsupported type: " + hierarchyRootNodeType + ".");
        }
        this.findCall = this.makeBatchCall(hierarchyRootNodeType, ids, rootLevel, rootLevelID);
    }
}

