/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.env.data.views.calls;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.openmicroscopy.shoola.env.data.OmeroDataService;
import org.openmicroscopy.shoola.env.data.views.BatchCall;
import org.openmicroscopy.shoola.env.data.views.BatchCallTree;
import pojos.CategoryData;
import pojos.CategoryGroupData;
import pojos.DataObject;
import pojos.DatasetData;
import pojos.ProjectData;

public class DataObjectSaver
extends BatchCallTree {
    public static final int CREATE = 0;
    public static final int UPDATE = 1;
    public static final int REMOVE = 2;
    private BatchCall saveCall;
    private Object result;

    private BatchCall create(final DataObject object, final DataObject parent) {
        return new BatchCall("Create Data object."){

            public void doCall() throws Exception {
                OmeroDataService os = DataObjectSaver.this.context.getDataService();
                DataObjectSaver.this.result = os.createDataObject(object, parent);
            }
        };
    }

    private BatchCall update(final DataObject object) {
        return new BatchCall("Update Data object."){

            public void doCall() throws Exception {
                OmeroDataService os = DataObjectSaver.this.context.getDataService();
                DataObjectSaver.this.result = os.updateDataObject(object);
            }
        };
    }

    private BatchCall remove(final Set objects, final DataObject parent) {
        return new BatchCall("Remove Data objects."){

            public void doCall() throws Exception {
                OmeroDataService os = DataObjectSaver.this.context.getDataService();
                DataObjectSaver.this.result = os.removeDataObjects(objects, parent);
            }
        };
    }

    private BatchCall remove(final Map objects) {
        return new BatchCall("Remove Data objects."){

            public void doCall() throws Exception {
                OmeroDataService os = DataObjectSaver.this.context.getDataService();
                Iterator i = objects.keySet().iterator();
                HashMap<DataObject, Set> results = new HashMap<DataObject, Set>(objects.size());
                while (i.hasNext()) {
                    DataObject p = (DataObject)i.next();
                    Set nodes = os.removeDataObjects((Set)objects.get(p), p);
                    results.put(p, nodes);
                }
                DataObjectSaver.this.result = results;
            }
        };
    }

    protected void buildTree() {
        this.add(this.saveCall);
    }

    protected Object getResult() {
        return this.result;
    }

    public DataObjectSaver(DataObject userObject, DataObject parent, int index) {
        if (userObject == null) {
            throw new IllegalArgumentException("No DataObject.");
        }
        if ((index == 0 || index == 2) && (userObject instanceof DatasetData ? !(parent instanceof ProjectData) : userObject instanceof CategoryData && !(parent instanceof CategoryGroupData))) {
            throw new IllegalArgumentException("Parent not valid.");
        }
        switch (index) {
            case 0: {
                this.saveCall = this.create(userObject, parent);
                break;
            }
            case 1: {
                this.saveCall = this.update(userObject);
                break;
            }
            case 2: {
                HashSet<DataObject> l = new HashSet<DataObject>(1);
                l.add(userObject);
                this.saveCall = this.remove(l, parent);
                break;
            }
            default: {
                throw new IllegalArgumentException("Operation not supported.");
            }
        }
    }

    public DataObjectSaver(Set userObjects, DataObject parent, int index) {
        if (userObjects == null) {
            throw new IllegalArgumentException("No DataObject.");
        }
        if (userObjects.size() == 0) {
            throw new IllegalArgumentException("No DataObject.");
        }
        switch (index) {
            case 2: {
                this.saveCall = this.remove(userObjects, parent);
                break;
            }
            default: {
                throw new IllegalArgumentException("Operation not supported.");
            }
        }
    }

    public DataObjectSaver(Map objects, int index) {
        if (objects == null) {
            throw new IllegalArgumentException("No DataObject.");
        }
        if (objects.size() == 0) {
            throw new IllegalArgumentException("No DataObject.");
        }
        switch (index) {
            case 2: {
                this.saveCall = this.remove(objects);
                break;
            }
            default: {
                throw new IllegalArgumentException("Operation not supported.");
            }
        }
    }
}

